/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.EntryChunk;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.LiteralChunk;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.NewLineChunk;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.PrefixedStringTemplateUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.TemplateChunk;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.TemplateTokenSequence;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessorKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringInterpolationPrefix;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0001CB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0016J2\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J8\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010!\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010$\u001a\u00020\t*\u0004\u0018\u00010%H\u0002J\u0010\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*H\u0002J(\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J7\u0010/\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u00104JQ\u00105\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\b\u00106\u001a\u0004\u0018\u0001012\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010;J\u0018\u0010<\u001a\u00020\u00192\u0006\u0010=\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010>\u001a\u00020\u00192\u0006\u0010=\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010?\u001a\u00020\t*\u00020@2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020\u0019H\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "<init>", "()V", "singleQuotedEntryProcessingMode", "Lorg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor$EntryProcessingMode;", "getSingleQuotedEntryProcessingMode", "()Lorg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor$EntryProcessingMode;", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "singleQuotedPaste", "interpolationPrefixLength", "", "tripleQuotedPaste", "selectionStartElement", "Lcom/intellij/psi/PsiElement;", "beginTp", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "createIndent", "templateTokenSequence", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/TemplateTokenSequence;", "indent", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/TemplateChunk;", "tripleQuoteRe", "Lkotlin/text/Regex;", "escapeTripleQuotes", "chunk", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/LiteralChunk;", "escapeDangerousDollars", "unescapedInput", "documentCharSequence", "", "adjustPastedTextAllDollars", "charAfterTrailingDollars", "", "dollarCountBefore", "dollarCountAfter", "(Ljava/lang/String;Ljava/lang/Character;III)Ljava/lang/String;", "adjustPastedText", "charAfterFirstPastedDollars", "previousTrailingDollarsCount", "firstPastedDollarsCount", "lastPastedDollarsCount", "dollarsAfterPastedTextCount", "(Ljava/lang/String;Ljava/lang/Character;Ljava/lang/Character;IIIII)Ljava/lang/String;", "countPrecedingDollars", "docCharSequence", "countFollowingDollars", "toEscapedText", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/EntryChunk;", "createEscapedDollarEntryText", "prefixLength", "EntryProcessingMode", "intellij.kotlin.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKotlinLiteralCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLiteralCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,359:1\n1342#2,2:360\n1#3:362\n1088#4,2:363\n654#4,5:365\n654#4,5:370\n654#4,5:375\n627#4,6:380\n1088#4,2:386\n654#4,5:388\n*S KotlinDebug\n*F\n+ 1 KotlinLiteralCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor\n*L\n149#1:360,2\n237#1:363,2\n244#1:365,5\n245#1:370,5\n262#1:375,5\n263#1:380,6\n267#1:386,2\n351#1:388,5\n*E\n"})
public abstract class KotlinLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @NotNull
    private final Regex tripleQuoteRe = new Regex("\"{3,}");

    @NotNull
    public abstract EntryProcessingMode getSingleQuotedEntryProcessingMode();

    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!(file instanceof KtFile)) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean changed2 = false;
        String fileText = ((KtFile)file).getText();
        int deducedBlockSelectionWidth = KotlinLiteralCopyPasteProcessorKt.access$deduceBlockSelectionWidth(startOffsets, endOffsets, text);
        int n = startOffsets.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                buffer.append('\n');
            }
            TextRange fileRange = new TextRange(startOffsets[i2], endOffsets[i2]);
            int givenTextOffset = fileRange.getStartOffset();
            while (givenTextOffset < fileRange.getEndOffset()) {
                TextRange inter;
                PsiElement tpEntry;
                IElementType elTp;
                PsiElement element = ((KtFile)file).findElementAt(givenTextOffset);
                if (element == null) {
                    Intrinsics.checkNotNull((Object)fileText);
                    String string = fileText.substring(givenTextOffset, fileRange.getEndOffset() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    buffer.append(string);
                    break;
                }
                Intrinsics.checkNotNullExpressionValue((Object)element.getNode().getElementType(), (String)"getElementType(...)");
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.ESCAPE_SEQUENCE) && fileRange.contains(FixersUtilKt.getRange((PsiElement)element))) {
                    TextRange textRange = KotlinLiteralCopyPasteProcessorKt.access$getTemplateContentRange(element);
                    boolean bl = textRange != null ? textRange.contains(fileRange) : false;
                    if (bl) {
                        PsiElement psiElement = element.getParent();
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry");
                        tpEntry = (KtEscapeStringTemplateEntry)psiElement;
                        changed2 = true;
                        buffer.append(tpEntry.getUnescapedValue());
                        givenTextOffset = PsiUtilsKt.getEndOffset((PsiElement)element);
                        continue;
                    }
                }
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START) || Intrinsics.areEqual((Object)elTp, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
                    TextRange inter2;
                    tpEntry = element.getParent();
                    Intrinsics.checkNotNull((Object)tpEntry);
                    Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange((PsiElement)tpEntry)));
                    Intrinsics.checkNotNull((Object)fileText);
                    String string = fileText.substring(inter2.getStartOffset(), inter2.getEndOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    buffer.append(string);
                    givenTextOffset = inter2.getEndOffset();
                    continue;
                }
                Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange((PsiElement)element)));
                Intrinsics.checkNotNull((Object)fileText);
                String string = fileText.substring(inter.getStartOffset(), inter.getEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                buffer.append(string);
                givenTextOffset = inter.getEndOffset();
            }
            int blockSelectionPadding = deducedBlockSelectionWidth - fileRange.getLength();
            for (int j = 0; j < blockSelectionPadding; ++j) {
                buffer.append(' ');
            }
        }
        return changed2 ? buffer.toString() : null;
    }

    @NotNull
    public String preprocessOnPaste(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull String text, @Nullable RawText rawText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!(file instanceof KtFile)) {
            return text;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        PsiElement psiElement = ((KtFile)file).findElementAt(selectionModel2.getSelectionStart());
        if (psiElement == null) {
            return text;
        }
        PsiElement selectionStartElement = psiElement;
        KtStringTemplateExpression ktStringTemplateExpression = KotlinLiteralCopyPasteProcessorKt.access$getTemplateIfAtLiteral(file, selectionModel2.getSelectionStart(), selectionStartElement);
        if (ktStringTemplateExpression == null) {
            return text;
        }
        KtStringTemplateExpression beginTp = ktStringTemplateExpression;
        KtStringTemplateExpression ktStringTemplateExpression2 = KotlinLiteralCopyPasteProcessorKt.getTemplateIfAtLiteral$default(file, selectionModel2.getSelectionEnd(), null, 2, null);
        if (ktStringTemplateExpression2 == null) {
            return text;
        }
        KtStringTemplateExpression endTp = ktStringTemplateExpression2;
        if (KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp) != KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)endTp)) {
            return text;
        }
        KtStringInterpolationPrefix interpolationPrefix = beginTp.getInterpolationPrefix();
        if (!Intrinsics.areEqual((Object)interpolationPrefix, (Object)endTp.getInterpolationPrefix())) {
            return text;
        }
        KtStringInterpolationPrefix ktStringInterpolationPrefix = interpolationPrefix;
        int prefixLength = ktStringInterpolationPrefix != null ? ktStringInterpolationPrefix.getTextLength() : 0;
        return KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp) ? this.singleQuotedPaste(text, prefixLength) : this.tripleQuotedPaste(text, prefixLength, selectionStartElement, beginTp, selectionModel2, editor);
    }

    private final String singleQuotedPaste(String text, int interpolationPrefixLength) {
        Object object;
        StringBuilder res = new StringBuilder();
        String interpolationPrefix = StringsKt.repeat((CharSequence)"$", (int)interpolationPrefixLength);
        String lineBreak = "\\n\"+\n " + interpolationPrefix + "\"";
        String additionalEscapedChars = interpolationPrefixLength > 1 ? "\"" : "$\"";
        boolean endsInLineBreak = false;
        Sequence $this$forEach$iv = new TemplateTokenSequence(text, interpolationPrefixLength);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TemplateChunk it;
            block10: {
                StringBuilder stringBuilder;
                TemplateChunk templateChunk;
                block11: {
                    block9: {
                        it = (TemplateChunk)element$iv;
                        boolean bl = false;
                        templateChunk = it;
                        if (!(templateChunk instanceof LiteralChunk)) break block9;
                        stringBuilder = StringUtil.escapeStringCharacters((int)((LiteralChunk)it).getText().length(), (String)((LiteralChunk)it).getText(), (String)additionalEscapedChars, (StringBuilder)res);
                        break block10;
                    }
                    if (!(templateChunk instanceof EntryChunk)) break block11;
                    switch (WhenMappings.$EnumSwitchMapping$0[this.getSingleQuotedEntryProcessingMode().ordinal()]) {
                        case 1: {
                            stringBuilder = res.append(((EntryChunk)it).getText());
                            break block10;
                        }
                        case 2: {
                            stringBuilder = StringUtil.escapeStringCharacters((int)((EntryChunk)it).getText().length(), (String)((EntryChunk)it).getText(), (String)additionalEscapedChars, (StringBuilder)res);
                            break block10;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (templateChunk instanceof NewLineChunk) {
                    stringBuilder = res.append(lineBreak);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            endsInLineBreak = it instanceof NewLineChunk;
        }
        if (endsInLineBreak) {
            object = StringsKt.removeSuffix((CharSequence)res, (CharSequence)lineBreak) + "\\n";
        } else {
            String string = res.toString();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        }
        return object;
    }

    private final String tripleQuotedPaste(String text, int interpolationPrefixLength, PsiElement selectionStartElement, KtStringTemplateExpression beginTp, SelectionModel selectionModel, Editor editor) {
        StringBuilder stringBuilder;
        TemplateTokenSequence templateTokenSequence = new TemplateTokenSequence(text, interpolationPrefixLength);
        String indent = this.createIndent(beginTp, templateTokenSequence, selectionStartElement);
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence docCharSequence = charSequence;
        StringBuilder $this$tripleQuotedPaste_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Ref.ObjectRef indentToAdd = new Ref.ObjectRef();
        indentToAdd.element = "";
        Iterator<TemplateChunk> sequenceIterator = templateTokenSequence.iterator();
        if (sequenceIterator.hasNext()) {
            TemplateChunk firstChunk = sequenceIterator.next();
            KotlinLiteralCopyPasteProcessor.tripleQuotedPaste$lambda$0$handleChunk(this, docCharSequence, selectionModel, interpolationPrefixLength, $this$tripleQuotedPaste_u24lambda_u240, (Ref.ObjectRef<String>)indentToAdd, indent, firstChunk, true);
            while (sequenceIterator.hasNext()) {
                TemplateChunk nextChunk = sequenceIterator.next();
                KotlinLiteralCopyPasteProcessor.tripleQuotedPaste$lambda$0$handleChunk(this, docCharSequence, selectionModel, interpolationPrefixLength, $this$tripleQuotedPaste_u24lambda_u240, (Ref.ObjectRef<String>)indentToAdd, indent, nextChunk, !sequenceIterator.hasNext());
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String createIndent(KtStringTemplateExpression beginTp, TemplateTokenSequence templateTokenSequence, PsiElement selectionStartElement) {
        Object object;
        if (KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp)) return "";
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)beginTp));
        KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (!Intrinsics.areEqual((Object)(ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null), (Object)"trimIndent")) return "";
        TemplateChunk templateChunk2 = (TemplateChunk)SequencesKt.firstOrNull((Sequence)templateTokenSequence);
        templateChunk2 = (TemplateChunk)SequencesKt.lastOrNull((Sequence)templateTokenSequence);
        if (!Intrinsics.areEqual((Object)(templateChunk != null ? this.indent(templateChunk) : null), (Object)(templateChunk2 != null ? this.indent(templateChunk2) : null))) return "";
        PsiElement psiElement = selectionStartElement.getParent();
        Object object2 = psiElement;
        if (psiElement == null) return "";
        PsiElement psiElement2 = object2.getPrevSibling();
        object2 = psiElement2;
        if (psiElement2 == null) return "";
        String string = object2.getText();
        object2 = string;
        if (string == null) return "";
        Object object3 = object = object2;
        boolean bl = false;
        CharSequence $this$all$iv = (CharSequence)object3;
        boolean $i$f$all = false;
        for (int j = 0; j < $this$all$iv.length(); ++j) {
            char element$iv;
            char c = element$iv = $this$all$iv.charAt(j);
            boolean bl2 = false;
            if (c != ' ') {
                if (c != '\t') return "";
            }
            boolean bl3 = true;
            if (bl3) continue;
            return "";
        }
        boolean bl4 = true;
        if (!bl4) return "";
        String string3 = object;
        string3 = string3;
        if (string2 != null) return string3;
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private final String indent(TemplateChunk $this$indent) {
        String string;
        block6: {
            TemplateChunk templateChunk = $this$indent;
            if (templateChunk instanceof LiteralChunk) {
                String $this$takeWhile$iv = ((LiteralChunk)$this$indent).getText();
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it22 = $this$takeWhile$iv.charAt(index$iv);
                    int n2 = 0;
                    if (CharsKt.isWhitespace((char)it22)) continue;
                    String it22 = $this$takeWhile$iv;
                    n2 = 0;
                    String string2 = it22.substring(n2, index$iv);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    break block6;
                }
                string = $this$takeWhile$iv;
            } else if (templateChunk instanceof EntryChunk) {
                void var3_4;
                String $this$takeWhile$iv = ((EntryChunk)$this$indent).getText();
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (CharsKt.isWhitespace((char)it)) continue;
                    String string3 = $this$takeWhile$iv;
                    int n3 = 0;
                    String string4 = string3.substring(n3, index$iv);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    break block6;
                }
                string = var3_4;
            } else {
                string = "";
            }
        }
        return string;
    }

    private final String escapeTripleQuotes(LiteralChunk chunk) {
        return this.tripleQuoteRe.replace((CharSequence)chunk.getText(), KotlinLiteralCopyPasteProcessor::escapeTripleQuotes$lambda$0);
    }

    private final String escapeDangerousDollars(String unescapedInput, CharSequence documentCharSequence, SelectionModel selectionModel, int interpolationPrefixLength) {
        boolean bl;
        int dollarsAfterPastedTextCount;
        int previousTrailingDollarsCount;
        int lastPastedDollarsCount;
        int firstPastedDollarsCount;
        block6: {
            String string;
            block5: {
                String string2;
                block4: {
                    if (!StringsKt.endsWith$default((String)unescapedInput, (String)"$", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)unescapedInput, (String)"$", (boolean)false, (int)2, null)) {
                        return unescapedInput;
                    }
                    String $this$takeWhile$iv = unescapedInput;
                    boolean $i$f$takeWhile = false;
                    int n = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char c22 = $this$takeWhile$iv.charAt(index$iv);
                        int n2 = 0;
                        if (c22 == '$') continue;
                        String c22 = $this$takeWhile$iv;
                        n2 = 0;
                        String string3 = c22.substring(n2, index$iv);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        break block4;
                    }
                    string2 = $this$takeWhile$iv;
                }
                firstPastedDollarsCount = ((CharSequence)string2).length();
                String $this$takeLastWhile$iv = unescapedInput;
                boolean $i$f$takeLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                    char c32 = $this$takeLastWhile$iv.charAt(index$iv);
                    int n = 0;
                    if (c32 == '$') continue;
                    String c32 = $this$takeLastWhile$iv;
                    n = index$iv + 1;
                    String string4 = c32.substring(n);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    break block5;
                }
                string = $this$takeLastWhile$iv;
            }
            lastPastedDollarsCount = ((CharSequence)string).length();
            previousTrailingDollarsCount = this.countPrecedingDollars(documentCharSequence, selectionModel);
            dollarsAfterPastedTextCount = this.countFollowingDollars(documentCharSequence, selectionModel);
            CharSequence $this$all$iv = unescapedInput;
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (it == '$') continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        boolean isOnlyDollarsPasted = bl;
        Character charAfterFirstPastedDollars = StringsKt.getOrNull((CharSequence)unescapedInput, (int)firstPastedDollarsCount);
        Character charAfterTrailingDollars = StringsKt.getOrNull((CharSequence)documentCharSequence, (int)(selectionModel.getSelectionEnd() + dollarsAfterPastedTextCount));
        return isOnlyDollarsPasted ? this.adjustPastedTextAllDollars(unescapedInput, charAfterTrailingDollars, previousTrailingDollarsCount, dollarsAfterPastedTextCount, interpolationPrefixLength) : this.adjustPastedText(unescapedInput, charAfterFirstPastedDollars, charAfterTrailingDollars, previousTrailingDollarsCount, firstPastedDollarsCount, lastPastedDollarsCount, dollarsAfterPastedTextCount, interpolationPrefixLength);
    }

    private final String adjustPastedTextAllDollars(String unescapedInput, Character charAfterTrailingDollars, int dollarCountBefore, int dollarCountAfter, int interpolationPrefixLength) {
        Character c = charAfterTrailingDollars;
        if (!(c != null ? PrefixedStringTemplateUtilsKt.canBeStartOfIdentifierOrBlock(c.charValue()) : false)) {
            return unescapedInput;
        }
        if (dollarCountBefore + dollarCountAfter + unescapedInput.length() < interpolationPrefixLength) {
            return unescapedInput;
        }
        return StringsKt.dropLast((String)unescapedInput, (int)1) + this.createEscapedDollarEntryText(interpolationPrefixLength);
    }

    /*
     * Unable to fully structure code
     */
    private final String adjustPastedText(String unescapedInput, Character charAfterFirstPastedDollars, Character charAfterTrailingDollars, int previousTrailingDollarsCount, int firstPastedDollarsCount, int lastPastedDollarsCount, int dollarsAfterPastedTextCount, int interpolationPrefixLength) {
        $this$adjustPastedText_u24lambda_u240 = var9_9 = new StringBuilder();
        $i$a$-buildString-KotlinLiteralCopyPasteProcessor$adjustPastedText$1 = false;
        if (firstPastedDollarsCount <= 0) ** GOTO lbl-1000
        v0 = charAfterFirstPastedDollars;
        v1 = v0 != null ? PrefixedStringTemplateUtilsKt.canBeStartOfIdentifierOrBlock(v0.charValue()) : false;
        if (v1 && previousTrailingDollarsCount + firstPastedDollarsCount >= interpolationPrefixLength) {
            $this$adjustPastedText_u24lambda_u240.append(StringsKt.take((String)unescapedInput, (int)(firstPastedDollarsCount - 1)));
            v2 = $this$adjustPastedText_u24lambda_u240.append(this.createEscapedDollarEntryText(interpolationPrefixLength));
        } else lbl-1000:
        // 2 sources

        {
            v2 = $this$adjustPastedText_u24lambda_u240.append(StringsKt.take((String)unescapedInput, (int)firstPastedDollarsCount));
        }
        pastedTextWithoutLeadingDollars = StringsKt.drop((String)unescapedInput, (int)firstPastedDollarsCount);
        if (lastPastedDollarsCount <= 0) ** GOTO lbl-1000
        v3 = charAfterTrailingDollars;
        v4 = v3 != null ? PrefixedStringTemplateUtilsKt.canBeStartOfIdentifierOrBlock(v3.charValue()) : false;
        if (v4 && lastPastedDollarsCount + dollarsAfterPastedTextCount >= interpolationPrefixLength) {
            $this$adjustPastedText_u24lambda_u240.append(StringsKt.dropLast((String)pastedTextWithoutLeadingDollars, (int)1));
            v5 = $this$adjustPastedText_u24lambda_u240.append(this.createEscapedDollarEntryText(interpolationPrefixLength));
        } else lbl-1000:
        // 2 sources

        {
            v5 = $this$adjustPastedText_u24lambda_u240.append(pastedTextWithoutLeadingDollars);
        }
        return var9_9.toString();
    }

    private final int countPrecedingDollars(CharSequence docCharSequence, SelectionModel selectionModel) {
        int previousTrailingDollarsCount = 0;
        while (true) {
            Character c = StringsKt.getOrNull((CharSequence)docCharSequence, (int)(selectionModel.getSelectionStart() - previousTrailingDollarsCount - 1));
            char c2 = '$';
            if (c == null || c.charValue() != c2) break;
            ++previousTrailingDollarsCount;
        }
        return previousTrailingDollarsCount;
    }

    private final int countFollowingDollars(CharSequence docCharSequence, SelectionModel selectionModel) {
        int nextEntryLeadingDollars = 0;
        while (true) {
            Character c = StringsKt.getOrNull((CharSequence)docCharSequence, (int)(selectionModel.getSelectionEnd() + nextEntryLeadingDollars));
            char c2 = '$';
            if (c == null || c.charValue() != c2) break;
            ++nextEntryLeadingDollars;
        }
        return nextEntryLeadingDollars;
    }

    private final String toEscapedText(EntryChunk $this$toEscapedText, int interpolationPrefixLength) {
        String string;
        block2: {
            if (!StringsKt.startsWith$default((String)$this$toEscapedText.getText(), (String)"$", (boolean)false, (int)2, null)) {
                return $this$toEscapedText.getText();
            }
            String $this$takeWhile$iv = $this$toEscapedText.getText();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '$') continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block2;
            }
            string = $this$takeWhile$iv;
        }
        String leadingDollars = string;
        String escapedDollar = this.createEscapedDollarEntryText(interpolationPrefixLength);
        String string4 = $this$toEscapedText.getText().substring(leadingDollars.length());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String textAfterDollars = string4;
        return StringsKt.drop((String)leadingDollars, (int)1) + escapedDollar + textAfterDollars;
    }

    private final String createEscapedDollarEntryText(int prefixLength) {
        return StringsKt.repeat((CharSequence)"$", (int)Math.max(prefixLength, 1)) + "{'$'}";
    }

    private static final void tripleQuotedPaste$lambda$0$handleChunk(KotlinLiteralCopyPasteProcessor this$0, CharSequence docCharSequence, SelectionModel $selectionModel, int $interpolationPrefixLength, StringBuilder $this_buildString, Ref.ObjectRef<String> indentToAdd, String indent, TemplateChunk chunk, boolean shouldEscapeDollars) {
        TemplateChunk templateChunk = chunk;
        if (templateChunk instanceof LiteralChunk) {
            String noQuotes = this$0.escapeTripleQuotes((LiteralChunk)chunk);
            String escapedLiteralChunk = shouldEscapeDollars ? this$0.escapeDangerousDollars(noQuotes, docCharSequence, $selectionModel, $interpolationPrefixLength) : noQuotes;
            $this_buildString.append((String)indentToAdd.element);
            $this_buildString.append(escapedLiteralChunk);
            indentToAdd.element = "";
        } else if (templateChunk instanceof EntryChunk) {
            $this_buildString.append((String)indentToAdd.element);
            $this_buildString.append(this$0.toEscapedText((EntryChunk)chunk, $interpolationPrefixLength));
            indentToAdd.element = "";
        } else if (templateChunk instanceof NewLineChunk) {
            $this_buildString.append('\n');
            indentToAdd.element = indent;
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final CharSequence escapeTripleQuotes$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"\"" + StringsKt.repeat((CharSequence)"${'\"'}", (int)(((CharSequence)it.getValue()).length() - 2));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor$EntryProcessingMode;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_ESCAPED", "ESCAPED", "intellij.kotlin.ide"})
    public static final class EntryProcessingMode
    extends Enum<EntryProcessingMode> {
        public static final /* enum */ EntryProcessingMode NOT_ESCAPED = new EntryProcessingMode();
        public static final /* enum */ EntryProcessingMode ESCAPED = new EntryProcessingMode();
        private static final /* synthetic */ EntryProcessingMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EntryProcessingMode[] values() {
            return (EntryProcessingMode[])$VALUES.clone();
        }

        public static EntryProcessingMode valueOf(String value) {
            return Enum.valueOf(EntryProcessingMode.class, value);
        }

        @NotNull
        public static EnumEntries<EntryProcessingMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = entryProcessingModeArray = new EntryProcessingMode[]{EntryProcessingMode.NOT_ESCAPED, EntryProcessingMode.ESCAPED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EntryProcessingMode.values().length];
            try {
                nArray[EntryProcessingMode.NOT_ESCAPED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntryProcessingMode.ESCAPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

