/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProvider;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a,\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a,\u0010\r\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a.\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\u000f\u001a\u00020\u00022\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\u0011\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0013\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0016"}, d2={"getRuntimeLibraryVersions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModuleRootModel;", "platformKind", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "getLibraryLanguageLevel", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "coerceRuntimeLibraryVersionToReleased", "", "getLibraryVersion", "getKotlinStdlibVersionOrNull", "getDefaultVersion", "explicitVersion", "getDefaultLanguageLevel", "addReleaseVersionIfNecessary", "shouldAdd", "getRuntimeLibraryVersion", "getRuntimeLibraryVersionOrDefault", "intellij.kotlin.base.facet"})
@SourceDebugExtension(value={"SMAP\nKotlinVersionInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinVersionInfoProvider.kt\norg/jetbrains/kotlin/idea/facet/KotlinVersionInfoProviderKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,105:1\n184#2,2:106\n*S KotlinDebug\n*F\n+ 1 KotlinVersionInfoProvider.kt\norg/jetbrains/kotlin/idea/facet/KotlinVersionInfoProviderKt\n*L\n39#1:106,2\n*E\n"})
public final class KotlinVersionInfoProviderKt {
    @NotNull
    public static final Sequence<IdeKotlinVersion> getRuntimeLibraryVersions(@NotNull Module module, @Nullable ModuleRootModel rootModel, @NotNull IdePlatformKind platformKind) {
        Sequence sequence;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)platformKind, (String)"platformKind");
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)KotlinVersionInfoProvider.Companion.getEP_NAME().getExtensionList()), arg_0 -> KotlinVersionInfoProviderKt.getRuntimeLibraryVersions$lambda$0(module, platformKind, rootModel, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Sequence it = (Sequence)element$iv;
                boolean bl = false;
                if (!SequencesKt.any((Sequence)it)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((sequence = (Sequence)v0) == null) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    @NotNull
    public static final LanguageVersion getLibraryLanguageLevel(@NotNull Module module, @Nullable ModuleRootModel rootModel, @Nullable IdePlatformKind platformKind, boolean coerceRuntimeLibraryVersionToReleased) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return KotlinVersionInfoProviderKt.getLibraryVersion(module, rootModel, platformKind, coerceRuntimeLibraryVersionToReleased).getLanguageVersion();
    }

    public static /* synthetic */ LanguageVersion getLibraryLanguageLevel$default(Module module, ModuleRootModel moduleRootModel, IdePlatformKind idePlatformKind, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return KotlinVersionInfoProviderKt.getLibraryLanguageLevel(module, moduleRootModel, idePlatformKind, bl);
    }

    @NotNull
    public static final IdeKotlinVersion getLibraryVersion(@NotNull Module module, @Nullable ModuleRootModel rootModel, @Nullable IdePlatformKind platformKind, boolean coerceRuntimeLibraryVersionToReleased) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        IdePlatformKind idePlatformKind = platformKind;
        if (idePlatformKind == null) {
            idePlatformKind = IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)JvmPlatforms.INSTANCE.getDefaultJvmPlatform());
        }
        IdeKotlinVersion minVersion = (IdeKotlinVersion)SequencesKt.minOrNull(KotlinVersionInfoProviderKt.addReleaseVersionIfNecessary(KotlinVersionInfoProviderKt.getRuntimeLibraryVersions(module, rootModel, idePlatformKind), coerceRuntimeLibraryVersionToReleased));
        return KotlinVersionInfoProviderKt.getDefaultVersion(minVersion, coerceRuntimeLibraryVersionToReleased);
    }

    public static /* synthetic */ IdeKotlinVersion getLibraryVersion$default(Module module, ModuleRootModel moduleRootModel, IdePlatformKind idePlatformKind, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return KotlinVersionInfoProviderKt.getLibraryVersion(module, moduleRootModel, idePlatformKind, bl);
    }

    @Nullable
    public static final IdeKotlinVersion getKotlinStdlibVersionOrNull(@NotNull Module module, @Nullable ModuleRootModel rootModel, @Nullable IdePlatformKind platformKind, boolean coerceRuntimeLibraryVersionToReleased) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        IdePlatformKind idePlatformKind = platformKind;
        if (idePlatformKind == null) {
            idePlatformKind = IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)JvmPlatforms.INSTANCE.getDefaultJvmPlatform());
        }
        return (IdeKotlinVersion)SequencesKt.minOrNull(KotlinVersionInfoProviderKt.addReleaseVersionIfNecessary(KotlinVersionInfoProviderKt.getRuntimeLibraryVersions(module, rootModel, idePlatformKind), coerceRuntimeLibraryVersionToReleased));
    }

    public static /* synthetic */ IdeKotlinVersion getKotlinStdlibVersionOrNull$default(Module module, ModuleRootModel moduleRootModel, IdePlatformKind idePlatformKind, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return KotlinVersionInfoProviderKt.getKotlinStdlibVersionOrNull(module, moduleRootModel, idePlatformKind, bl);
    }

    @NotNull
    public static final IdeKotlinVersion getDefaultVersion(@Nullable IdeKotlinVersion explicitVersion, boolean coerceRuntimeLibraryVersionToReleased) {
        if (explicitVersion != null) {
            return explicitVersion;
        }
        IdeKotlinVersion libVersion = (IdeKotlinVersion)SequencesKt.minOrNull(KotlinVersionInfoProviderKt.addReleaseVersionIfNecessary((Sequence<IdeKotlinVersion>)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)KotlinVersionInfoProvider.Companion.getEP_NAME().getExtensionList()), KotlinVersionInfoProviderKt::getDefaultVersion$lambda$0), coerceRuntimeLibraryVersionToReleased));
        IdeKotlinVersion ideKotlinVersion = libVersion;
        if (ideKotlinVersion == null) {
            ideKotlinVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
        }
        return ideKotlinVersion;
    }

    public static /* synthetic */ IdeKotlinVersion getDefaultVersion$default(IdeKotlinVersion ideKotlinVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            ideKotlinVersion = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return KotlinVersionInfoProviderKt.getDefaultVersion(ideKotlinVersion, bl);
    }

    @NotNull
    public static final LanguageVersion getDefaultLanguageLevel(@Nullable IdeKotlinVersion explicitVersion, boolean coerceRuntimeLibraryVersionToReleased) {
        return KotlinVersionInfoProviderKt.getDefaultVersion(explicitVersion, coerceRuntimeLibraryVersionToReleased).getLanguageVersion();
    }

    public static /* synthetic */ LanguageVersion getDefaultLanguageLevel$default(IdeKotlinVersion ideKotlinVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            ideKotlinVersion = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return KotlinVersionInfoProviderKt.getDefaultLanguageLevel(ideKotlinVersion, bl);
    }

    private static final Sequence<IdeKotlinVersion> addReleaseVersionIfNecessary(Sequence<IdeKotlinVersion> $this$addReleaseVersionIfNecessary, boolean shouldAdd) {
        return shouldAdd ? SequencesKt.plus($this$addReleaseVersionIfNecessary, (Object)KotlinPluginLayout.getStandaloneCompilerVersion()) : $this$addReleaseVersionIfNecessary;
    }

    @Nullable
    public static final IdeKotlinVersion getRuntimeLibraryVersion(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project);
        if (kotlinFacetSettingsProvider == null) {
            return null;
        }
        KotlinFacetSettingsProvider settingsProvider = kotlinFacetSettingsProvider;
        TargetPlatform targetPlatform = settingsProvider.getInitializedSettings(module).getTargetPlatform();
        TargetPlatform targetPlatform2 = targetPlatform;
        if (targetPlatform2 == null) {
            targetPlatform2 = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
        }
        Sequence<IdeKotlinVersion> versions = KotlinVersionInfoProviderKt.getRuntimeLibraryVersions(module, null, IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)targetPlatform2));
        return (IdeKotlinVersion)CollectionsKt.singleOrNull((Iterable)SequencesKt.toSet(versions));
    }

    @NotNull
    public static final IdeKotlinVersion getRuntimeLibraryVersionOrDefault(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
        if (ideKotlinVersion == null) {
            ideKotlinVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
        }
        return ideKotlinVersion;
    }

    private static final Sequence getRuntimeLibraryVersions$lambda$0(Module $module, IdePlatformKind $platformKind, ModuleRootModel $rootModel, KotlinVersionInfoProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLibraryVersionsSequence($module, $platformKind, $rootModel);
    }

    private static final IdeKotlinVersion getDefaultVersion$lambda$0(KotlinVersionInfoProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCompilerVersion();
    }
}

