/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinPredefinedCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0016\u0010\u0004\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/ProjectCodeStyleImporter;", "", "<init>", "()V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "codeStyleStr", "", "", "predefinedCodeStyle", "Lorg/jetbrains/kotlin/idea/formatter/KotlinPredefinedCodeStyle;", "intellij.kotlin.formatter"})
public final class ProjectCodeStyleImporter {
    @NotNull
    public static final ProjectCodeStyleImporter INSTANCE = new ProjectCodeStyleImporter();

    private ProjectCodeStyleImporter() {
    }

    public final boolean apply(@NotNull Project project, @Nullable String codeStyleStr) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = codeStyleStr;
        if (Intrinsics.areEqual((Object)string, (Object)"obsolete")) {
            this.apply(project, KotlinObsoleteCodeStyle.Companion.getINSTANCE());
            bl = true;
        } else if (Intrinsics.areEqual((Object)string, (Object)"official")) {
            this.apply(project, KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void apply(@NotNull Project project, @NotNull KotlinPredefinedCodeStyle predefinedCodeStyle) {
        CodeStyleSettings codeStyleSettings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)predefinedCodeStyle), (String)"predefinedCodeStyle");
        CodeStyleSettings codeStyleSettings2 = CodeStyle.getSettings((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings2, (String)"getSettings(...)");
        CodeStyleSettings customSettings = codeStyleSettings2;
        if (Intrinsics.areEqual((Object)predefinedCodeStyle.getCodeStyleId(), (Object)CodeStyleUtilsKt.kotlinCodeStyleDefaults((CodeStyleSettings)customSettings))) {
            return;
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)project);
        if (CodeStyle.usesOwnSettings((Project)project)) {
            var6_5 = settingsManager.cloneSettings(customSettings);
            Intrinsics.checkNotNull((Object)var6_5);
            codeStyleSettings = var6_5;
        } else {
            var6_5 = CodeStyle.getDefaultSettings();
            Intrinsics.checkNotNull((Object)var6_5);
            codeStyleSettings = var6_5;
        }
        CodeStyleSettings projectSettingsUpdated = codeStyleSettings;
        predefinedCodeStyle.apply(projectSettingsUpdated);
        CodeStyle.setMainProjectSettings((Project)project, (CodeStyleSettings)projectSettingsUpdated);
        settingsManager.notifyCodeStyleSettingsChanged();
    }
}

