/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.configuration.klib;

import com.intellij.openapi.util.IntellijInternalApi;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0005R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/KotlinNativeLibraryNameUtil;", "", "<init>", "()V", "KOTLIN_NATIVE_LIBRARY_PREFIX", "", "getKOTLIN_NATIVE_LIBRARY_PREFIX$annotations", "KOTLIN_NATIVE_LIBRARY_PREFIX_PLUS_SPACE", "getKOTLIN_NATIVE_LIBRARY_PREFIX_PLUS_SPACE$annotations", "GRADLE_LIBRARY_PREFIX", "getGRADLE_LIBRARY_PREFIX$annotations", "IDE_LIBRARY_NAME_REGEX", "Lkotlin/text/Regex;", "parseIDELibraryName", "Lkotlin/Triple;", "ideLibraryName", "isGradleLibraryName", "", "intellij.kotlin.gradle.gradle"})
public final class KotlinNativeLibraryNameUtil {
    @NotNull
    public static final KotlinNativeLibraryNameUtil INSTANCE = new KotlinNativeLibraryNameUtil();
    @NonNls
    @NotNull
    public static final String KOTLIN_NATIVE_LIBRARY_PREFIX = "Kotlin/Native";
    @NotNull
    public static final String KOTLIN_NATIVE_LIBRARY_PREFIX_PLUS_SPACE = "Kotlin/Native ";
    @NonNls
    @NotNull
    public static final String GRADLE_LIBRARY_PREFIX = "Gradle: ";
    @NotNull
    private static final Regex IDE_LIBRARY_NAME_REGEX = new Regex("^Kotlin/Native ([^\\s]+) - ([^\\s]+)( \\[([\\w ,()*]+)])?$");

    private KotlinNativeLibraryNameUtil() {
    }

    @IntellijInternalApi
    public static /* synthetic */ void getKOTLIN_NATIVE_LIBRARY_PREFIX$annotations() {
    }

    @IntellijInternalApi
    public static /* synthetic */ void getKOTLIN_NATIVE_LIBRARY_PREFIX_PLUS_SPACE$annotations() {
    }

    @IntellijInternalApi
    public static /* synthetic */ void getGRADLE_LIBRARY_PREFIX$annotations() {
    }

    @Nullable
    public final Triple<String, String, String> parseIDELibraryName(@NotNull String ideLibraryName) {
        Intrinsics.checkNotNullParameter((Object)ideLibraryName, (String)"ideLibraryName");
        MatchResult matchResult = IDE_LIBRARY_NAME_REGEX.matchEntire((CharSequence)ideLibraryName);
        if (matchResult == null) {
            return null;
        }
        MatchResult match2 = matchResult;
        MatchGroup matchGroup = match2.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        String kotlinVersion = matchGroup.getValue();
        MatchGroup matchGroup2 = match2.getGroups().get(2);
        Intrinsics.checkNotNull((Object)matchGroup2);
        String libraryName = matchGroup2.getValue();
        MatchGroup matchGroup3 = match2.getGroups().get(4);
        String platformPart = matchGroup3 != null ? matchGroup3.getValue() : null;
        return new Triple((Object)kotlinVersion, (Object)libraryName, (Object)platformPart);
    }

    public final boolean isGradleLibraryName(@NotNull String ideLibraryName) {
        Intrinsics.checkNotNullParameter((Object)ideLibraryName, (String)"ideLibraryName");
        return StringsKt.startsWith$default((String)ideLibraryName, (String)GRADLE_LIBRARY_PREFIX, (boolean)false, (int)2, null);
    }
}

