/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.statistics;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradle.statistics.KotlinGradleFUSCollector;
import org.jetbrains.kotlin.statistics.BuildSessionLogger;
import org.jetbrains.kotlin.statistics.fileloggers.MetricsContainer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/statistics/KotlinGradleFUSLoggerProcessor;", "", "<init>", "()V", "process", "", "statisticsFolder", "Ljava/nio/file/Path;", "intellij.kotlin.gradle.gradle"})
final class KotlinGradleFUSLoggerProcessor {
    @NotNull
    public static final KotlinGradleFUSLoggerProcessor INSTANCE = new KotlinGradleFUSLoggerProcessor();

    private KotlinGradleFUSLoggerProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull Path statisticsFolder) {
        Intrinsics.checkNotNullParameter((Object)statisticsFolder, (String)"statisticsFolder");
        File file = statisticsFolder.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        for (File statisticFile : BuildSessionLogger.Companion.listProfileFiles(file)) {
            boolean fileWasRead = true;
            try {
                Ref.ObjectRef previousEvent = new Ref.ObjectRef();
                fileWasRead = MetricsContainer.Companion.readFromFile(statisticFile, (Function1<? super MetricsContainer, Unit>)((Function1)arg_0 -> KotlinGradleFUSLoggerProcessor.process$lambda$0(previousEvent, arg_0)));
                if (!fileWasRead || statisticFile.delete()) continue;
            }
            catch (Exception e) {
                Logger.getInstance(KotlinGradleFUSCollector.class).info("Failed to process file " + statisticFile.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                if (statisticFile.delete()) continue;
                Logger.getInstance(KotlinGradleFUSCollector.class).warn("[FUS] Failed to delete file " + statisticFile.getAbsolutePath());
                continue;
            }
            Logger.getInstance(KotlinGradleFUSCollector.class).warn("[FUS] Failed to delete file " + statisticFile.getAbsolutePath());
        }
    }

    private static final Unit process$lambda$0(Ref.ObjectRef $previousEvent, MetricsContainer metricContainer) {
        Intrinsics.checkNotNullParameter((Object)metricContainer, (String)"metricContainer");
        KotlinGradleFUSCollector.INSTANCE.reportMetrics(metricContainer, (MetricsContainer)$previousEvent.element);
        $previousEvent.element = metricContainer;
        return Unit.INSTANCE;
    }
}

