/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.configuration.ChangedConfiguratorFiles;
import org.jetbrains.kotlin.idea.configuration.KotlinCompilerPluginProjectConfigurator;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptSupport;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinGradleCodeInsightUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinStdlibIndex;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH$\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/AbstractGradleKotlinCompilerPluginProjectConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinCompilerPluginProjectConfigurator;", "<init>", "()V", "configureModule", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "add", "", "addVersion", "", "sourceModule", "changedFiles", "Lorg/jetbrains/kotlin/idea/configuration/ChangedConfiguratorFiles;", "detectKotlinStdlibVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getKotlinPluginExpression", "", "forKotlinDsl", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\ngradleKotlinCompilerPluginProjectConfigurators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 gradleKotlinCompilerPluginProjectConfigurators.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/AbstractGradleKotlinCompilerPluginProjectConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public abstract class AbstractGradleKotlinCompilerPluginProjectConfigurator
implements KotlinCompilerPluginProjectConfigurator {
    @Override
    @Nullable
    public PsiFile configureModule(@NotNull Module module) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ChangedConfiguratorFiles changedFiles = new ChangedConfiguratorFiles();
        PsiFile psiFile2 = KotlinGradleCodeInsightUtils.getTopLevelBuildScriptPsiFile(project2);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile topLevelFile = psiFile2;
        PsiFile it = psiFile = KotlinGradleCodeInsightUtils.getBuildScriptPsiFile(module);
        boolean bl = false;
        PsiFile moduleFile = !Intrinsics.areEqual((Object)it, (Object)topLevelFile) ? psiFile : null;
        psiFile = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)topLevelFile.getName(), (String)"getName(...)");
        ApplicationUtilsKt.executeWriteCommand(project2, KotlinIdeaGradleBundle.message("command.name.configure.0", (Object[])psiFile), null, () -> AbstractGradleKotlinCompilerPluginProjectConfigurator.configureModule$lambda$1(this, topLevelFile, module, changedFiles, moduleFile));
        PsiFile psiFile3 = moduleFile;
        if (psiFile3 == null) {
            psiFile3 = topLevelFile;
        }
        return psiFile3;
    }

    private final void add(PsiFile $this$add, boolean addVersion, Module sourceModule, ChangedConfiguratorFiles changedFiles) {
        GradleBuildScriptManipulator manipulator = GradleBuildScriptSupport.Companion.getManipulator$default(GradleBuildScriptSupport.Companion, $this$add, false, 2, null);
        IdeKotlinVersion ideKotlinVersion = manipulator.getKotlinVersion();
        if (ideKotlinVersion == null && (ideKotlinVersion = this.detectKotlinStdlibVersion(sourceModule)) == null) {
            ideKotlinVersion = ConfigureDialogWithModulesAndVersion.Companion.getDefaultKotlinVersion();
        }
        IdeKotlinVersion version = ideKotlinVersion;
        manipulator.configureBuildScripts("kotlin." + this.getKotlinCompilerPluginId(), this.getKotlinPluginExpression($this$add instanceof KtFile), "kotlin-stdlib", addVersion, version, null, changedFiles);
    }

    @Nullable
    public final IdeKotlinVersion detectKotlinStdlibVersion(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        Iterator stdlibManifests = (Iterator)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> AbstractGradleKotlinCompilerPluginProjectConfigurator.detectKotlinStdlibVersion$lambda$0(fileBasedIndex, module));
        return (IdeKotlinVersion)ActionsKt.runReadAction(() -> AbstractGradleKotlinCompilerPluginProjectConfigurator.detectKotlinStdlibVersion$lambda$1(stdlibManifests, projectFileIndex2));
    }

    @NotNull
    protected abstract String getKotlinPluginExpression(boolean var1);

    private static final Unit configureModule$lambda$1(AbstractGradleKotlinCompilerPluginProjectConfigurator this$0, PsiFile $topLevelFile, Module $module, ChangedConfiguratorFiles $changedFiles, PsiFile $moduleFile) {
        Unit unit;
        this$0.add($topLevelFile, true, $module, $changedFiles);
        PsiFile psiFile = $moduleFile;
        if (psiFile != null) {
            this$0.add(psiFile, false, $module, $changedFiles);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final Iterator detectKotlinStdlibVersion$lambda$0(FileBasedIndex $fileBasedIndex, Module $module) {
        Iterator iterator2 = $fileBasedIndex.getContainingFilesIterator(KotlinStdlibIndex.Companion.getNAME(), (Object)KotlinStdlibIndex.Companion.getKOTLIN_STDLIB_NAME(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)$module, (boolean)true));
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getContainingFilesIterator(...)");
        return iterator2;
    }

    private static final IdeKotlinVersion detectKotlinStdlibVersion$lambda$1(Iterator $stdlibManifests, ProjectFileIndex $projectFileIndex) {
        IdeKotlinVersion stdlibVersion = null;
        Iterator iterator2 = $stdlibManifests;
        while (iterator2.hasNext()) {
            IdeKotlinVersion it;
            VirtualFile virtualFile;
            VirtualFile manifest = (VirtualFile)iterator2.next();
            if ($projectFileIndex.getClassRootForFile(manifest) == null) continue;
            if (KotlinJvmStdlibDetectorFacility.INSTANCE.getStdlibVersion(CollectionsKt.listOf((Object)virtualFile)) == null) continue;
            boolean bl = false;
            if (stdlibVersion != null && stdlibVersion.compareTo(it) >= 0) continue;
            stdlibVersion = it;
        }
        return stdlibVersion;
    }
}

