/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;
import org.jetbrains.kotlin.idea.gradle.configuration.GradlePropertiesFileFacade;
import org.jetbrains.kotlin.idea.gradle.statistics.KotlinGradleFUSLogger;
import org.jetbrains.kotlin.idea.gradleJava.configuration.GradleProjectImportHandler;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u00020\u0007\u00a2\u0006\u0002\b\tH\u0016J8\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleProjectDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Ljava/lang/Void;", "<init>", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinGradleSourceSetDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleSourceSetDataService.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleProjectDataService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,354:1\n1915#2,2:355\n30#3,2:357\n*S KotlinDebug\n*F\n+ 1 KotlinGradleSourceSetDataService.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleProjectDataService\n*L\n149#1:355,2\n157#1:357,2\n*E\n"})
public final class KotlinGradleProjectDataService
extends AbstractProjectDataService<ModuleData, Void> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"MODULE");
        return key;
    }

    public void postProcess(@NotNull Collection<? extends DataNode<ModuleData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        ProjectData projectData2 = projectData;
        if (!Intrinsics.areEqual((Object)(projectData2 != null ? projectData2.getOwner() : null), (Object)GradleConstants.SYSTEM_ID)) {
            return;
        }
        for (DataNode<ModuleData> dataNode : toImport) {
            Module ideModule;
            Collection collection = ExternalSystemApiUtil.getChildren(dataNode, (Key)GradleSourceSetData.KEY);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
            if (!collection.isEmpty()) continue;
            Object object = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
            ModuleData moduleData = (ModuleData)object;
            if (modelsProvider.findIdeModule(moduleData) == null || KotlinGradleSourceSetDataServiceKt.configureFacetByGradleModule$default(ideModule, modelsProvider, dataNode, null, null, 16, null) == null) continue;
            Iterable $this$forEach$iv = GradleProjectImportHandler.Companion.getInstances(project);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinFacet kotlinFacet;
                GradleProjectImportHandler it = (GradleProjectImportHandler)element$iv;
                boolean bl = false;
                it.importByModule(kotlinFacet, dataNode);
            }
        }
        ActionsKt.runReadAction(() -> KotlinGradleProjectDataService.postProcess$lambda$1(project));
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean bl = false;
        Class<KotlinGradleFUSLogger> serviceClass$iv = KotlinGradleFUSLogger.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((KotlinGradleFUSLogger)object).scheduleReportStatistics();
    }

    private static final boolean postProcess$lambda$1(Project $project) {
        String codeStyleStr = GradlePropertiesFileFacade.Companion.forProject($project).readProperty("kotlin.code.style");
        return ProjectCodeStyleImporter.INSTANCE.apply($project, codeStyleStr);
    }
}

