/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration.klib;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ConcurrencyUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.gradle.configuration.ClasspathDataUtilKt;
import org.jetbrains.kotlin.idea.gradle.configuration.klib.KlibInfo;
import org.jetbrains.kotlin.idea.gradle.configuration.klib.KlibInfoProvider;
import org.jetbrains.kotlin.idea.gradle.configuration.mpp.KotlinDependenciesPreprocessor;
import org.jetbrains.kotlin.idea.gradleJava.KotlinGradleFacadeImplKt;
import org.jetbrains.kotlin.idea.gradleJava.configuration.klib.DependencySubstitute;
import org.jetbrains.kotlin.idea.gradleJava.configuration.klib.KotlinNativeLibrariesDependencySubstitutorKt;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinMPPGradleModel;
import org.jetbrains.kotlin.idea.projectModel.KotlinCompilation;
import org.jetbrains.kotlin.idea.projectModel.KotlinTarget;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.model.DefaultExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\n\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000b2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000fH\u0096\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001f\u001a\u0004\u0018\u00010 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001e\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/klib/KotlinNativeLibrariesDependencySubstitutor;", "Lorg/jetbrains/kotlin/idea/gradle/configuration/mpp/KotlinDependenciesPreprocessor;", "mppModel", "Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinMPPGradleModel;", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "resolverCtx", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinMPPGradleModel;Lorg/gradle/tooling/model/idea/IdeaModule;Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;)V", "invoke", "", "Lorg/jetbrains/plugins/gradle/model/ExternalDependency;", "Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinDependency;", "dependencies", "", "substituteDependencies", "", "dependencySubstitutionCache", "", "Lorg/jetbrains/plugins/gradle/ExternalDependencyId;", "Lorg/jetbrains/kotlin/idea/gradleJava/configuration/klib/DependencySubstitute;", "Lorg/jetbrains/annotations/NotNull;", "getDependencySubstitutionCache", "(Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;)Ljava/util/Map;", "klibInfoProvider", "Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/KlibInfoProvider;", "getKlibInfoProvider", "()Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/KlibInfoProvider;", "klibInfoProvider$delegate", "Lkotlin/Lazy;", "kotlinVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getKotlinVersion", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "kotlinVersion$delegate", "getFileCollectionDependencySubstitute", "dependency", "Lorg/jetbrains/plugins/gradle/model/FileCollectionDependency;", "buildSubstituteIfNecessary", "libraryFile", "Ljava/io/File;", "Companion", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinNativeLibrariesDependencySubstitutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNativeLibrariesDependencySubstitutor.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/klib/KotlinNativeLibrariesDependencySubstitutor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n383#2,7:168\n1#3:175\n1391#4:176\n1480#4,5:177\n*S KotlinDebug\n*F\n+ 1 KotlinNativeLibrariesDependencySubstitutor.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/klib/KotlinNativeLibrariesDependencySubstitutor\n*L\n109#1:168,7\n95#1:176\n95#1:177,5\n*E\n"})
public final class KotlinNativeLibrariesDependencySubstitutor
implements KotlinDependenciesPreprocessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinMPPGradleModel mppModel;
    @NotNull
    private final IdeaModule gradleModule;
    @NotNull
    private final ProjectResolverContext resolverCtx;
    @NotNull
    private final Lazy klibInfoProvider$delegate;
    @NotNull
    private final Lazy kotlinVersion$delegate;
    @NotNull
    private static final String DEFAULT_PACKAGING = "jar";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<Map<ExternalDependencyId, DependencySubstitute>> KLIB_DEPENDENCY_SUBSTITUTION_CACHE;

    public KotlinNativeLibrariesDependencySubstitutor(@NotNull KotlinMPPGradleModel mppModel, @NotNull IdeaModule gradleModule, @NotNull ProjectResolverContext resolverCtx) {
        Intrinsics.checkNotNullParameter((Object)mppModel, (String)"mppModel");
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter((Object)resolverCtx, (String)"resolverCtx");
        this.mppModel = mppModel;
        this.gradleModule = gradleModule;
        this.resolverCtx = resolverCtx;
        this.klibInfoProvider$delegate = LazyKt.lazy(() -> KotlinNativeLibrariesDependencySubstitutor.klibInfoProvider_delegate$lambda$0(this));
        this.kotlinVersion$delegate = LazyKt.lazy(() -> KotlinNativeLibrariesDependencySubstitutor.kotlinVersion_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public List<ExternalDependency> invoke(@NotNull Iterable<? extends ExternalDependency> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        return this.substituteDependencies(CollectionsKt.toList(dependencies));
    }

    private final List<ExternalDependency> substituteDependencies(Collection<? extends ExternalDependency> dependencies) {
        ArrayList<? extends ExternalDependency> result2 = new ArrayList<ExternalDependency>(dependencies);
        int n = result2.size();
        for (int i2 = 0; i2 < n; ++i2) {
            ExternalDependency dependency = result2.get(i2);
            DependencySubstitute dependencySubstitute = dependency instanceof FileCollectionDependency ? this.getFileCollectionDependencySubstitute((FileCollectionDependency)dependency) : (DependencySubstitute)DependencySubstitute.NoSubstitute.INSTANCE;
            DependencySubstitute.YesSubstitute yesSubstitute = dependencySubstitute instanceof DependencySubstitute.YesSubstitute ? (DependencySubstitute.YesSubstitute)dependencySubstitute : null;
            if (yesSubstitute == null || (yesSubstitute = yesSubstitute.getSubstitute()) == null) continue;
            DependencySubstitute.YesSubstitute newDependency = yesSubstitute;
            result2.set(i2, (ExternalDependency)newDependency);
        }
        return result2;
    }

    private final Map<ExternalDependencyId, DependencySubstitute> getDependencySubstitutionCache(ProjectResolverContext $this$dependencySubstitutionCache) {
        Object object = ConcurrencyUtil.computeIfAbsent((UserDataHolder)((UserDataHolder)$this$dependencySubstitutionCache), KLIB_DEPENDENCY_SUBSTITUTION_CACHE, KotlinNativeLibrariesDependencySubstitutor::_get_dependencySubstitutionCache_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
        return (Map)object;
    }

    private final KlibInfoProvider getKlibInfoProvider() {
        Lazy lazy = this.klibInfoProvider$delegate;
        return (KlibInfoProvider)lazy.getValue();
    }

    private final IdeKotlinVersion getKotlinVersion() {
        Lazy lazy = this.kotlinVersion$delegate;
        return (IdeKotlinVersion)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final DependencySubstitute getFileCollectionDependencySubstitute(FileCollectionDependency dependency) {
        Object object;
        void $this$getOrPut$iv;
        Map<ExternalDependencyId, DependencySubstitute> map2 = this.getDependencySubstitutionCache(this.resolverCtx);
        ExternalDependencyId key$iv = dependency.getId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            DependencySubstitute dependencySubstitute;
            boolean bl = false;
            Collection collection = dependency.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
            File file = (File)CollectionsKt.firstOrNull((Iterable)collection);
            if (file == null) {
                dependencySubstitute = DependencySubstitute.NoSubstitute.INSTANCE;
            } else {
                File libraryFile = file;
                dependencySubstitute = this.buildSubstituteIfNecessary(libraryFile);
            }
            DependencySubstitute answer$iv = dependencySubstitute;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (DependencySubstitute)object;
    }

    private final DependencySubstitute buildSubstituteIfNecessary(File libraryFile) {
        DefaultExternalMultiLibraryDependency defaultExternalMultiLibraryDependency;
        Object object = this.getKlibInfoProvider();
        if (object == null || (object = object.getKlibInfo(libraryFile)) == null) {
            return DependencySubstitute.NoSubstitute.INSTANCE;
        }
        Object klib = object;
        DefaultExternalMultiLibraryDependency $this$buildSubstituteIfNecessary_u24lambda_u240 = defaultExternalMultiLibraryDependency = new DefaultExternalMultiLibraryDependency();
        boolean bl = false;
        $this$buildSubstituteIfNecessary_u24lambda_u240.setClasspathOrder(Intrinsics.areEqual((Object)((KlibInfo)klib).getLibraryName(), (Object)"stdlib") ? -1 : 0);
        $this$buildSubstituteIfNecessary_u24lambda_u240.setName(KotlinNativeLibrariesDependencySubstitutorKt.ideName((KlibInfo)klib, this.getKotlinVersion()));
        $this$buildSubstituteIfNecessary_u24lambda_u240.setPackaging(DEFAULT_PACKAGING);
        Collection collection = $this$buildSubstituteIfNecessary_u24lambda_u240.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        Collection collection2 = collection;
        collection2.add(((KlibInfo)klib).getPath());
        Collection collection3 = $this$buildSubstituteIfNecessary_u24lambda_u240.getSources();
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"getSources(...)");
        collection2 = collection3;
        CollectionsKt.addAll((Collection)collection2, (Iterable)((KlibInfo)klib).getSourcePaths());
        $this$buildSubstituteIfNecessary_u24lambda_u240.setScope("PROVIDED");
        DefaultExternalMultiLibraryDependency substitute = defaultExternalMultiLibraryDependency;
        return new DependencySubstitute.YesSubstitute((ExternalMultiLibraryDependency)substitute);
    }

    private static final Map _get_dependencySubstitutionCache_$lambda$0() {
        return new HashMap();
    }

    private static final KlibInfoProvider klibInfoProvider_delegate$lambda$0(KotlinNativeLibrariesDependencySubstitutor this$0) {
        KlibInfoProvider klibInfoProvider;
        File kotlinNativeHome;
        String string;
        String it = string = this$0.mppModel.getKotlinNativeHome();
        boolean bl = false;
        String string2 = !Intrinsics.areEqual((Object)it, (Object)"") ? string : null;
        if (string2 != null) {
            String p0 = string2;
            boolean bl2 = false;
            v1 = new File(p0);
        } else {
            v1 = kotlinNativeHome = null;
        }
        if (kotlinNativeHome == null) {
            LOG.warn(StringsKt.trimIndent((String)("\n                    Can't obtain Kotlin/Native home path in Kotlin Gradle plugin.\n                    " + KotlinMPPGradleModel.class.getSimpleName() + " is " + this$0.mppModel + ".\n                    " + KotlinNativeLibrariesDependencySubstitutor.class.getSimpleName() + " will run in idle mode. No dependencies will be substituted.\n                ")));
            klibInfoProvider = null;
        } else {
            klibInfoProvider = KlibInfoProvider.Companion.create(kotlinNativeHome);
        }
        return klibInfoProvider;
    }

    private static final Sequence kotlinVersion_delegate$lambda$0$0(KotlinTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence((Iterable)it.getCompilations());
    }

    private static final String kotlinVersion_delegate$lambda$0$1(KotlinCompilation it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it.getKotlinTaskProperties().getPluginVersion();
        if (string2 != null) {
            String string3;
            String p0 = string3 = string2;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)p0) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final IdeKotlinVersion kotlinVersion_delegate$lambda$0(KotlinNativeLibrariesDependencySubstitutor this$0) {
        IdeKotlinVersion ideKotlinVersion;
        BuildScriptClasspathData classpathData = ClasspathDataUtilKt.buildClasspathData(this$0.gradleModule, this$0.resolverCtx);
        IdeKotlinVersion versionFromClasspath = KotlinGradleFacadeImplKt.findKotlinPluginVersion(classpathData);
        if (versionFromClasspath == null) {
            IdeKotlinVersion versionFromModel;
            IdeKotlinVersion.Companion companion;
            Object object = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this$0.mppModel.getTargets()), KotlinNativeLibrariesDependencySubstitutor::kotlinVersion_delegate$lambda$0$0), KotlinNativeLibrariesDependencySubstitutor::kotlinVersion_delegate$lambda$0$1));
            if (object != null) {
                String string = object;
                companion = IdeKotlinVersion.Companion;
                String p0 = string;
                boolean bl = false;
                v0 = companion.opt(p0);
            } else {
                v0 = versionFromModel = null;
            }
            if (versionFromModel == null) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                String string = this$0.gradleModule.getName();
                List list2 = classpathData.getClasspathEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getClasspathEntries(...)");
                object = list2;
                String string2 = string;
                Logger logger = LOG;
                boolean $i$f$flatMap = false;
                companion = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    BuildScriptClasspathData.ClasspathEntry it = (BuildScriptClasspathData.ClasspathEntry)element$iv$iv;
                    boolean bl = false;
                    Set set = it.getClassesFile();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getClassesFile(...)");
                    Iterable list$iv$iv = set;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                logger.warn(StringsKt.trimIndent((String)("\n                        Can't obtain Kotlin Gradle plugin version for " + string2 + " module.\n                        Build classpath is " + list3 + ".\n                        " + KotlinMPPGradleModel.class.getSimpleName() + " is " + this$0.mppModel + ".\n                        " + KotlinNativeLibrariesDependencySubstitutor.class.getSimpleName() + " will run in idle mode. No dependencies will be substituted.\n                    ")));
                ideKotlinVersion = null;
            } else {
                void var3_9;
                ideKotlinVersion = var3_9;
            }
        } else {
            ideKotlinVersion = versionFromClasspath;
        }
        return ideKotlinVersion;
    }

    static {
        Logger logger = Logger.getInstance(KotlinNativeLibrariesDependencySubstitutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"KLIB_DEPENDENCY_SUBSTITUTION_CACHE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KLIB_DEPENDENCY_SUBSTITUTION_CACHE = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\t\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r \u000e*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/klib/KotlinNativeLibrariesDependencySubstitutor$Companion;", "", "<init>", "()V", "DEFAULT_PACKAGING", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "KLIB_DEPENDENCY_SUBSTITUTION_CACHE", "Lcom/intellij/openapi/util/Key;", "", "Lorg/jetbrains/plugins/gradle/ExternalDependencyId;", "Lorg/jetbrains/kotlin/idea/gradleJava/configuration/klib/DependencySubstitute;", "kotlin.jvm.PlatformType", "kotlin.gradle.gradle-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

