/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.idea.gradleJava.run.KotlinGradleTaskUtilsKt;
import org.jetbrains.plugins.gradle.execution.GradleRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/run/KotlinGradleTaskRunConfigurationProducer;", "Lorg/jetbrains/plugins/gradle/execution/GradleRunConfigurationProducer;", "<init>", "()V", "setupConfigurationFromContext", "", "configuration", "Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "findTaskNameAllowingEDT", "", "psiElement", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinGradleTaskRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleTaskRunConfigurationProducer.kt\norg/jetbrains/kotlin/idea/gradleJava/run/KotlinGradleTaskRunConfigurationProducer\n+ 2 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n*L\n1#1,61:1\n41#2,8:62\n*S KotlinDebug\n*F\n+ 1 KotlinGradleTaskRunConfigurationProducer.kt\norg/jetbrains/kotlin/idea/gradleJava/run/KotlinGradleTaskRunConfigurationProducer\n*L\n57#1:62,8\n*E\n"})
public final class KotlinGradleTaskRunConfigurationProducer
extends GradleRunConfigurationProducer {
    public boolean setupConfigurationFromContext(@NotNull GradleRunConfiguration configuration2, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Module module = context2.getModule();
        if (module == null) {
            return false;
        }
        Module module2 = module;
        Location location = context2.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        PsiElement psiElement = location2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        if (!KotlinGradleTaskUtilsKt.isInGradleKotlinScript(psiElement)) {
            return false;
        }
        String string = GradleRunnerUtil.resolveProjectPath((Module)module2);
        if (string == null) {
            return false;
        }
        String projectPath = string;
        PsiElement psiElement2 = location2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsiElement(...)");
        String string2 = this.findTaskNameAllowingEDT(psiElement2);
        if (string2 == null) {
            return false;
        }
        String taskToRun = string2;
        configuration2.getSettings().setExternalProjectPath(projectPath);
        configuration2.getSettings().setTaskNames(CollectionsKt.listOf((Object)taskToRun));
        configuration2.setName(AbstractExternalSystemTaskConfigurationType.generateName((Project)module2.getProject(), (ExternalSystemTaskExecutionSettings)configuration2.getSettings()));
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull GradleRunConfiguration configuration2, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Module module = context2.getModule();
        if (module == null) {
            return false;
        }
        Module module2 = module;
        Location location = context2.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        PsiElement psiElement = location2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        if (!KotlinGradleTaskUtilsKt.isInGradleKotlinScript(psiElement)) {
            return false;
        }
        String string = GradleRunnerUtil.resolveProjectPath((Module)module2);
        if (string == null) {
            return false;
        }
        String projectPath = string;
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = configuration2.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"getSettings(...)");
        ExternalSystemTaskExecutionSettings settings2 = externalSystemTaskExecutionSettings;
        if (!StringUtil.equals((CharSequence)projectPath, (CharSequence)settings2.getExternalProjectPath())) {
            return false;
        }
        List list2 = settings2.getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTaskNames(...)");
        String string2 = (String)CollectionsKt.singleOrNull((List)list2);
        if (string2 == null) {
            return false;
        }
        String taskFromSettings = string2;
        PsiElement psiElement2 = location2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsiElement(...)");
        String string3 = this.findTaskNameAllowingEDT(psiElement2);
        if (string3 == null) {
            return false;
        }
        String taskName = string3;
        return Intrinsics.areEqual((Object)taskName, (Object)taskFromSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findTaskNameAllowingEDT(PsiElement psiElement) {
        String string;
        boolean $i$f$allowAnalysisOnEdt = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
            boolean bl = false;
            string = KotlinGradleTaskUtilsKt.findTaskNameAround(psiElement);
        } else {
            permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
            try {
                boolean bl = false;
                String string2 = KotlinGradleTaskUtilsKt.findTaskNameAround(psiElement);
                string = string2;
            }
            finally {
                permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
            }
        }
        return string;
    }
}

