/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.groovy.inspections;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.tooling.IdePlatformKindToolingKt;
import org.jetbrains.kotlin.idea.base.externalSystem.KotlinExternalSystemUtils;
import org.jetbrains.kotlin.idea.base.externalSystem.KotlinGradleFacade;
import org.jetbrains.kotlin.idea.base.externalSystem.NodeWithData;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptManipulatorUtils;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinGradleCodeInsightUtils;
import org.jetbrains.kotlin.idea.groovy.KotlinGroovyBundle;
import org.jetbrains.kotlin.idea.groovy.inspections.GradleHeuristicHelper;
import org.jetbrains.kotlin.idea.groovy.inspections.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.groovy.inspections.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0003\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J!\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "buildErrorString", "", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "VersionFinder", "MyVisitor", "Companion", "intellij.kotlin.gradle.codeInsight.groovy"})
public final class DifferentStdlibGradleVersionInspection
extends BaseInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor("org.jetbrains.kotlin", IdePlatformKindToolingKt.getTooling((IdePlatformKind)JvmIdePlatformKind.INSTANCE).getMavenLibraryIds());
    }

    @NotNull
    protected String buildErrorString(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[]{args[0], args[1]};
        return KotlinGroovyBundle.message("error.text.different.kotlin.library.version", objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J&\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ&\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection$Companion;", "", "<init>", "()V", "findLibraryStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "libraryGroup", "", "libraryIds", "", "getRawResolvedLibVersion", "file", "Lcom/intellij/psi/PsiFile;", "groupId", "getResolvedLibVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "intellij.kotlin.gradle.codeInsight.groovy"})
    @SourceDebugExtension(value={"SMAP\nDifferentStdlibGradleVersionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DifferentStdlibGradleVersionInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n296#2:95\n1807#2,3:96\n297#2:99\n777#2:100\n873#2,2:101\n*S KotlinDebug\n*F\n+ 1 DifferentStdlibGradleVersionInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection$Companion\n*L\n66#1:95\n67#1:96,3\n66#1:99\n80#1:100\n80#1:101,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        private final GrCallExpression findLibraryStatement(GrClosableBlock closure, @NonNls String libraryGroup, List<String> libraryIds) {
            block7: {
                $this$firstOrNull$iv = GradleHeuristicHelper.INSTANCE.findStatementWithPrefixes(closure, GradleBuildScriptManipulatorUtils.getSCRIPT_PRODUCTION_DEPENDENCY_STATEMENTS());
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    block6: {
                        block8: {
                            statement = (GrCallExpression)element$iv;
                            $i$a$-firstOrNull-DifferentStdlibGradleVersionInspection$Companion$findLibraryStatement$1 = false;
                            $this$any$iv = libraryIds;
                            $i$f$any = false;
                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block8;
                            v0 = false;
                            break block6;
                        }
                        for (T element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            $i$a$-any-DifferentStdlibGradleVersionInspection$Companion$findLibraryStatement$1$1 = false;
                            v1 = statement.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
                            index = StringsKt.indexOf$default((CharSequence)v1, (String)it, (int)0, (boolean)false, (int)6, null);
                            if (index == -1) ** GOTO lbl-1000
                            v2 = statement.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getText(...)");
                            v3 = StringsKt.getOrNull((CharSequence)v2, (int)(index + it.length()));
                            var17_17 = '-';
                            if (v3 == null || v3.charValue() != var17_17) {
                                v4 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 = false;
                            }
                            if (!v4) continue;
                            v0 = true;
                            break block6;
                        }
                        v0 = false;
                    }
                    if (!v0) ** GOTO lbl-1000
                    v5 = statement.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getText(...)");
                    if (StringsKt.contains$default((CharSequence)v5, (CharSequence)libraryGroup, (boolean)false, (int)2, null)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    v7 = element$iv;
                    break block7;
                }
                v7 = null;
            }
            return v7;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getRawResolvedLibVersion(@NotNull PsiFile file, @NotNull String groupId, @NotNull List<String> libraryIds) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
            DataNode<ProjectData> dataNode = KotlinGradleCodeInsightUtils.findGradleProjectStructure(file);
            if (dataNode == null) {
                return null;
            }
            DataNode<ProjectData> projectStructureNode = dataNode;
            Module module = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex().getModuleForFile(file.getVirtualFile());
            if (module == null) {
                return null;
            }
            Module module2 = module;
            KotlinGradleFacade kotlinGradleFacade = KotlinGradleFacade.Companion.getInstance();
            if (kotlinGradleFacade == null) {
                return null;
            }
            KotlinGradleFacade gradleFacade = kotlinGradleFacade;
            Key key = ProjectKeys.MODULE;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"MODULE");
            Iterable $this$filter$iv = KotlinExternalSystemUtils.findAll(projectStructureNode, key);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                NodeWithData it = (NodeWithData)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((ModuleData)it.getData()).getInternalName(), (Object)module2.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (NodeWithData moduleData : (List)destination$iv$iv) {
                String string = gradleFacade.findLibraryVersionByModuleData(moduleData.getNode(), groupId, libraryIds);
                if (string == null) continue;
                String it = string;
                boolean bl = false;
                return it;
            }
            return null;
        }

        @Nullable
        public final IdeKotlinVersion getResolvedLibVersion(@NotNull PsiFile file, @NotNull String groupId, @NotNull List<String> libraryIds) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
            String string = this.getRawResolvedLibVersion(file, groupId, libraryIds);
            if (string == null) {
                return null;
            }
            String rawVersion = string;
            return IdeKotlinVersion.Companion.opt(rawVersion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection$MyVisitor;", "Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection$VersionFinder;", "groupId", "", "libraryIds", "", "<init>", "(Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection;Ljava/lang/String;Ljava/util/List;)V", "onFound", "", "stdlibVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "stdlibStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "intellij.kotlin.gradle.codeInsight.groovy"})
    private final class MyVisitor
    extends VersionFinder {
        public MyVisitor(@NotNull String groupId, List<String> libraryIds) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
            super(groupId, libraryIds);
        }

        @Override
        protected void onFound(@NotNull IdeKotlinVersion stdlibVersion, @NotNull GrCallExpression stdlibStatement) {
            Intrinsics.checkNotNullParameter((Object)stdlibVersion, (String)"stdlibVersion");
            Intrinsics.checkNotNullParameter((Object)stdlibStatement, (String)"stdlibStatement");
            PsiFile psiFile = stdlibStatement.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            IdeKotlinVersion gradlePluginVersion = KotlinGradleInspectionVisitorKt.findResolvedKotlinGradleVersion(psiFile);
            if (!Intrinsics.areEqual((Object)stdlibVersion, (Object)gradlePluginVersion)) {
                Object[] objectArray = new Object[]{gradlePluginVersion, stdlibVersion};
                this.registerError((PsiElement)stdlibStatement, objectArray);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection$VersionFinder;", "Lorg/jetbrains/kotlin/idea/groovy/inspections/KotlinGradleInspectionVisitor;", "groupId", "", "libraryIds", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "onFound", "", "stdlibVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "stdlibStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "visitClosure", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "intellij.kotlin.gradle.codeInsight.groovy"})
    @SourceDebugExtension(value={"SMAP\nDifferentStdlibGradleVersionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DifferentStdlibGradleVersionInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection$VersionFinder\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,94:1\n249#2:95\n*S KotlinDebug\n*F\n+ 1 DifferentStdlibGradleVersionInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/DifferentStdlibGradleVersionInspection$VersionFinder\n*L\n38#1:95\n*E\n"})
    private static abstract class VersionFinder
    extends KotlinGradleInspectionVisitor {
        @NotNull
        private final String groupId;
        @NotNull
        private final List<String> libraryIds;

        public VersionFinder(@NotNull String groupId, @NotNull List<String> libraryIds) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
            this.groupId = groupId;
            this.libraryIds = libraryIds;
        }

        protected abstract void onFound(@NotNull IdeKotlinVersion var1, @NotNull GrCallExpression var2);

        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)closure;
            boolean $i$f$getStrictParentOfType = false;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            if (!Intrinsics.areEqual((Object)dependenciesCall.getInvokedExpression().getText(), (Object)"dependencies")) {
                return;
            }
            if (!(dependenciesCall.getParent() instanceof PsiFile)) {
                return;
            }
            GrCallExpression grCallExpression = Companion.findLibraryStatement(closure, "org.jetbrains.kotlin", this.libraryIds);
            if (grCallExpression == null) {
                return;
            }
            GrCallExpression stdlibStatement = grCallExpression;
            PsiFile psiFile = closure.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            IdeKotlinVersion ideKotlinVersion = Companion.getResolvedLibVersion(psiFile, this.groupId, this.libraryIds);
            if (ideKotlinVersion == null) {
                return;
            }
            IdeKotlinVersion stdlibVersion = ideKotlinVersion;
            this.onFound(stdlibVersion, stdlibStatement);
        }
    }
}

