/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.groovy.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/GradleHeuristicHelper;", "", "<init>", "()V", "getHeuristicVersionInBuildScriptDependency", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "classpathStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "resolveVariableInBuildScript", "name", "", "findStatementWithPrefix", "", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "prefix", "findStatementWithPrefixes", "prefixes", "", "intellij.kotlin.gradle.codeInsight.groovy"})
@SourceDebugExtension(value={"SMAP\nGradleHeuristicHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleHeuristicHelper.kt\norg/jetbrains/kotlin/idea/groovy/inspections/GradleHeuristicHelper\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,93:1\n265#2:94\n265#2:95\n249#2:96\n249#2:97\n265#2:98\n265#2:99\n*S KotlinDebug\n*F\n+ 1 GradleHeuristicHelper.kt\norg/jetbrains/kotlin/idea/groovy/inspections/GradleHeuristicHelper\n*L\n25#1:94\n32#1:95\n46#1:96\n47#1:97\n79#1:98\n84#1:99\n*E\n"})
public final class GradleHeuristicHelper {
    @NotNull
    public static final GradleHeuristicHelper INSTANCE = new GradleHeuristicHelper();

    private GradleHeuristicHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final IdeKotlinVersion getHeuristicVersionInBuildScriptDependency(@NotNull GrCallExpression classpathStatement) {
        GrArgumentList grArgumentList;
        Intrinsics.checkNotNullParameter((Object)classpathStatement, (String)"classpathStatement");
        if (classpathStatement instanceof GrMethodCall) {
            grArgumentList = ((GrMethodCall)classpathStatement).getArgumentList();
        } else {
            PsiElement psiElement = (PsiElement)classpathStatement;
            boolean $i$f$getChildrenOfType = false;
            Object[] objectArray = PsiTreeUtil.getChildrenOfType((PsiElement)psiElement, GrCommandArgumentList.class);
            if (objectArray == null) {
                objectArray = (PsiElement[])new GrCommandArgumentList[0];
            }
            grArgumentList = (GrArgumentList)ArraysKt.singleOrNull((Object[])objectArray);
        }
        if (grArgumentList == null) {
            return null;
        }
        GrArgumentList argumentList = grArgumentList;
        PsiElement[] psiElementArray = argumentList.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object object = ArraysKt.firstOrNull((Object[])psiElementArray);
        if (!(object instanceof GrLiteral)) return null;
        GrLiteral grLiteral = (GrLiteral)object;
        if (grLiteral == null) {
            return null;
        }
        GrLiteral grLiteral2 = grLiteral;
        if (grLiteral2 instanceof GrString && ((GrString)grLiteral2).getInjections().length == 1) {
            GrStringInjection[] grStringInjectionArray = ((GrString)grLiteral2).getInjections();
            Intrinsics.checkNotNullExpressionValue((Object)grStringInjectionArray, (String)"getInjections(...)");
            GrStringInjection grStringInjection = (GrStringInjection)ArraysKt.first((Object[])grStringInjectionArray);
            if (grStringInjection == null) {
                return null;
            }
            GrStringInjection versionInjection = grStringInjection;
            GrExpression grExpression = versionInjection.getExpression();
            GrReferenceExpression grReferenceExpression = grExpression instanceof GrReferenceExpression ? (GrReferenceExpression)grExpression : null;
            if (grReferenceExpression == null) {
                Object[] objectArray = versionInjection.getClosableBlock();
                Object[] objectArray2 = objectArray;
                if (objectArray == null) return null;
                PsiElement $this$getChildrenOfType$iv = (PsiElement)objectArray2;
                boolean $i$f$getChildrenOfType = false;
                PsiElement[] psiElementArray2 = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, GrReferenceExpression.class);
                if (psiElementArray2 == null) {
                    psiElementArray2 = (PsiElement[])new GrReferenceExpression[0];
                }
                Object[] objectArray3 = (GrReferenceExpression[])psiElementArray2;
                objectArray2 = objectArray3;
                if (objectArray3 == null) return null;
                GrReferenceExpression grReferenceExpression2 = (GrReferenceExpression)ArraysKt.singleOrNull((Object[])objectArray2);
                grReferenceExpression = grReferenceExpression2;
                if (grReferenceExpression2 == null) {
                    return null;
                }
            }
            GrReferenceExpression grReferenceExpression3 = grReferenceExpression;
            String string = grReferenceExpression3.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return this.resolveVariableInBuildScript(classpathStatement, string);
        }
        Object object2 = grLiteral2.getValue();
        if (object2 == null) {
            return null;
        }
        Object literalValue = object2;
        String string = StringsKt.substringAfterLast$default((String)literalValue.toString(), (char)':', null, (int)2, null);
        if (((CharSequence)string).length() == 0) {
            return null;
        }
        boolean bl = false;
        if (!bl) return IdeKotlinVersion.Companion.opt(string);
        return null;
    }

    private final IdeKotlinVersion resolveVariableInBuildScript(GrCallExpression classpathStatement, String name2) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)classpathStatement;
        boolean $i$f$getStrictParentOfType = false;
        GrClosableBlock grClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, GrClosableBlock.class, (boolean)true);
        if (grClosableBlock == null) {
            return null;
        }
        GrClosableBlock dependenciesClosure = grClosableBlock;
        PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)dependenciesClosure;
        boolean $i$f$getStrictParentOfType2 = false;
        GrClosableBlock grClosableBlock2 = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, GrClosableBlock.class, (boolean)true);
        if (grClosableBlock2 == null) {
            return null;
        }
        GrClosableBlock buildScriptClosure = grClosableBlock2;
        PsiElement[] psiElementArray = buildScriptClosure.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        for (PsiElement psiElement : psiElementArray) {
            GrVariable[] grVariableArray;
            PsiElement child;
            Intrinsics.checkNotNull((Object)psiElement);
            psiElement = child = psiElement;
            if (psiElement instanceof GrAssignmentExpression) {
                GrExpression assignValue;
                if (!Intrinsics.areEqual((Object)((GrAssignmentExpression)child).getLValue().getText(), (Object)("ext." + name2)) || !((assignValue = ((GrAssignmentExpression)child).getRValue()) instanceof GrLiteral)) continue;
                return IdeKotlinVersion.Companion.opt(String.valueOf(((GrLiteral)assignValue).getValue()));
            }
            if (!(psiElement instanceof GrVariableDeclaration)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((GrVariableDeclaration)child).getVariables(), (String)"getVariables(...)");
            for (GrVariable variable : grVariableArray) {
                GrExpression assignValue;
                if (!Intrinsics.areEqual((Object)variable.getName(), (Object)name2) || !((assignValue = variable.getInitializerGroovy()) instanceof GrLiteral)) continue;
                return IdeKotlinVersion.Companion.opt(String.valueOf(((GrLiteral)assignValue).getValue()));
            }
        }
        return null;
    }

    @NotNull
    public final List<GrCallExpression> findStatementWithPrefix(@NotNull GrClosableBlock closure, @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        return this.findStatementWithPrefixes(closure, SetsKt.setOf((Object)prefix2));
    }

    @NotNull
    public final List<GrCallExpression> findStatementWithPrefixes(@NotNull GrClosableBlock closure, @NotNull Set<String> prefixes) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        PsiElement $this$getChildrenOfType$iv = (PsiElement)closure;
        boolean $i$f$getChildrenOfType = false;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, GrCallExpression.class);
        if (psiElementArray == null) {
            psiElementArray = (PsiElement[])new GrCallExpression[0];
        }
        GrCallExpression[] applicationStatements = (GrCallExpression[])psiElementArray;
        ArrayList<GrCallExpression> classPathStatements = new ArrayList<GrCallExpression>();
        for (GrCallExpression statement : applicationStatements) {
            String expressionText;
            GrReferenceExpression startExpression;
            PsiElement $this$getChildrenOfType$iv2 = (PsiElement)statement;
            boolean $i$f$getChildrenOfType2 = false;
            Object[] objectArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv2, GrReferenceExpression.class);
            if (objectArray == null) {
                objectArray = (PsiElement[])new GrReferenceExpression[0];
            }
            if ((GrReferenceExpression)ArraysKt.firstOrNull((Object[])objectArray) == null || startExpression.getText() == null || !prefixes.contains(expressionText)) continue;
            classPathStatements.add(statement);
        }
        return classPathStatements;
    }
}

