/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.ui.LayeredIcon;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000fJ\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyNodeDescriptor;", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "Lcom/intellij/pom/Navigatable;", "parentDescriptor", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "isBase", "", "navigateToReference", "<init>", "(Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;Lorg/jetbrains/kotlin/psi/KtElement;ZZ)V", "usageCount", "", "references", "", "Lcom/intellij/psi/PsiReference;", "javaDelegate", "Lcom/intellij/ide/hierarchy/call/CallHierarchyNodeDescriptor;", "incrementUsageCount", "", "addReference", "reference", "isValid", "update", "navigate", "requestFocus", "canNavigate", "canNavigateToSource", "Companion", "kotlin.idea"})
public final class KotlinCallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int usageCount;
    @NotNull
    private final Set<PsiReference> references;
    @NotNull
    private final CallHierarchyNodeDescriptor javaDelegate;

    public KotlinCallHierarchyNodeDescriptor(@Nullable HierarchyNodeDescriptor parentDescriptor, @NotNull KtElement element, boolean isBase, boolean navigateToReference) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element.getProject(), (NodeDescriptor)parentDescriptor, (PsiElement)element, isBase);
        this.usageCount = 1;
        this.references = new HashSet();
        this.javaDelegate = new CallHierarchyNodeDescriptor(this.myProject, null, (PsiElement)element, isBase, navigateToReference);
    }

    public final void incrementUsageCount() {
        int n = this.usageCount;
        this.usageCount = n + 1;
        this.javaDelegate.incrementUsageCount();
    }

    public final void addReference(@NotNull PsiReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        this.references.add(reference);
        this.javaDelegate.addReference(reference);
    }

    public boolean isValid() {
        PsiElement myElement = this.getPsiElement();
        return myElement != null && myElement.isValid();
    }

    public boolean update() {
        String string;
        Icon icon2;
        Object[] $this$update_u24lambda_u240;
        PsiElement targetElement;
        CompositeAppearance compositeAppearance = this.myHighlightedText;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance, (String)"myHighlightedText");
        CompositeAppearance oldText = compositeAppearance;
        Icon oldIcon = this.getIcon();
        int flags = this.isMarkReadOnly() ? 3 : 1;
        boolean changes = super.update();
        String elementText = KotlinCallHierarchyNodeDescriptor.Companion.renderElement(this.getPsiElement());
        if (elementText == null) {
            String string2 = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String invalidPrefix = string2;
            String string3 = this.myHighlightedText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            if (!StringsKt.startsWith$default((String)string3, (String)invalidPrefix, (boolean)false, (int)2, null)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        PsiElement psiElement = targetElement = this.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement);
        Icon elementIcon = psiElement.getIcon(flags);
        KotlinCallHierarchyNodeDescriptor kotlinCallHierarchyNodeDescriptor = this;
        if (changes && this.myIsBase) {
            LayeredIcon layeredIcon;
            LayeredIcon layeredIcon2 = layeredIcon = new LayeredIcon(2);
            KotlinCallHierarchyNodeDescriptor kotlinCallHierarchyNodeDescriptor2 = kotlinCallHierarchyNodeDescriptor;
            boolean bl = false;
            $this$update_u24lambda_u240.setIcon(elementIcon, 0);
            $this$update_u24lambda_u240.setIcon(AllIcons.General.Modified, 1, -AllIcons.General.Modified.getIconWidth() / 2, 0);
            kotlinCallHierarchyNodeDescriptor = kotlinCallHierarchyNodeDescriptor2;
            icon2 = (Icon)layeredIcon;
        } else {
            icon2 = elementIcon;
        }
        kotlinCallHierarchyNodeDescriptor.setIcon(icon2);
        TextAttributes mainTextAttributes = this.myColor != null ? new TextAttributes(this.myColor, null, null, null, 0) : null;
        this.myHighlightedText = new CompositeAppearance();
        this.myHighlightedText.getEnding().addText(elementText, mainTextAttributes);
        if (this.usageCount > 1) {
            $this$update_u24lambda_u240 = new Object[]{this.usageCount};
            this.myHighlightedText.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])$this$update_u24lambda_u240), HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
        }
        if ((string = KtPsiUtil.getPackageName((KtElement)((KtElement)targetElement))) == null) {
            string = "";
        }
        String packageName = string;
        this.myHighlightedText.getEnding().addText("  (" + packageName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.getIcon(), (Object)oldIcon)) {
            changes = true;
        }
        return changes;
    }

    public void navigate(boolean requestFocus) {
        this.javaDelegate.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.javaDelegate.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.javaDelegate.canNavigateToSource();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyNodeDescriptor$Companion;", "", "<init>", "()V", "renderElement", "", "element", "Lcom/intellij/psi/PsiElement;", "renderNamedFunction", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "renderClassOrObject", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NlsSafe
        private final String renderElement(PsiElement element) {
            PsiElement psiElement = element;
            if (psiElement instanceof KtFile) {
                return ((KtFile)element).getName();
            }
            if (!(psiElement instanceof KtNamedDeclaration)) {
                return null;
            }
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny((KtDeclaration)element, BodyResolveMode.PARTIAL);
            if (declarationDescriptor == null) {
                return null;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            String elementText = null;
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)element;
            if (ktNamedDeclaration instanceof KtClassOrObject) {
                if (element instanceof KtObjectDeclaration && ((KtObjectDeclaration)element).isCompanion()) {
                    DeclarationDescriptor containingDescriptor = descriptor2.getContainingDeclaration();
                    if (!(containingDescriptor instanceof ClassDescriptor)) {
                        return null;
                    }
                    descriptor2 = containingDescriptor;
                    elementText = this.renderClassOrObject((ClassDescriptor)descriptor2);
                } else {
                    elementText = element instanceof KtEnumEntry ? ((KtEnumEntry)element).getName() : (((KtClassOrObject)element).getName() != null ? this.renderClassOrObject((ClassDescriptor)descriptor2) : KotlinBundle.message((String)"hierarchy.text.anonymous", (Object[])new Object[0]));
                }
            } else if (ktNamedDeclaration instanceof KtNamedFunction || ktNamedDeclaration instanceof KtConstructor) {
                if (!(descriptor2 instanceof FunctionDescriptor)) {
                    return null;
                }
                elementText = this.renderNamedFunction((FunctionDescriptor)descriptor2);
            } else if (ktNamedDeclaration instanceof KtProperty) {
                elementText = ((KtProperty)element).getName();
            } else {
                return null;
            }
            if (elementText == null) {
                return null;
            }
            Object containerText = null;
            for (DeclarationDescriptor containerDescriptor = descriptor2.getContainingDeclaration(); containerDescriptor != null && !(containerDescriptor instanceof PackageFragmentDescriptor) && !(containerDescriptor instanceof ModuleDescriptor); containerDescriptor = containerDescriptor.getContainingDeclaration()) {
                String identifier;
                Name name2;
                Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor.getName(), (String)"getName(...)");
                if (name2.isSpecial()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)name2.getIdentifier(), (String)"getIdentifier(...)");
                Object object = containerText;
                containerText = object != null ? identifier + "." + object : identifier;
            }
            Object object = containerText;
            return object != null ? object + "." + elementText : elementText;
        }

        @NotNull
        public final String renderNamedFunction(@NotNull FunctionDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            ConstructorDescriptor constructorDescriptor = descriptor2 instanceof ConstructorDescriptor ? (ConstructorDescriptor)descriptor2 : null;
            DeclarationDescriptor descriptorForName = constructorDescriptor != null && (constructorDescriptor = constructorDescriptor.getContainingDeclaration()) != null ? (DeclarationDescriptor)constructorDescriptor : (DeclarationDescriptor)descriptor2;
            String string = descriptorForName.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String name2 = string;
            String string2 = StringUtil.join((Collection)descriptor2.getValueParameters(), arg_0 -> Companion.renderNamedFunction$lambda$1(Companion::renderNamedFunction$lambda$0, arg_0), (String)", ");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
            String paramTypes = string2;
            return name2 + "(" + paramTypes + ")";
        }

        private final String renderClassOrObject(ClassDescriptor descriptor2) {
            String string = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return string;
        }

        private static final String renderNamedFunction$lambda$0(ValueParameterDescriptor descriptor1) {
            Intrinsics.checkNotNullParameter((Object)descriptor1, (String)"descriptor1");
            KotlinType kotlinType = descriptor1.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            return DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(kotlinType);
        }

        private static final String renderNamedFunction$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

