/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.overrides;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.MethodHierarchyBrowserBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.hierarchy.HierarchyUtilsKt;
import org.jetbrains.kotlin.idea.hierarchy.overrides.KotlinOverrideHierarchyBrowser;
import org.jetbrains.kotlin.idea.hierarchy.overrides.KotlinOverrideHierarchyProviderKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/overrides/KotlinOverrideHierarchyProvider;", "Lcom/intellij/ide/hierarchy/HierarchyProvider;", "<init>", "()V", "getTarget", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createHierarchyBrowser", "Lcom/intellij/ide/hierarchy/HierarchyBrowser;", "target", "browserActivated", "", "hierarchyBrowser", "getOverrideHierarchyElement", "element", "kotlin.idea"})
public final class KotlinOverrideHierarchyProvider
implements HierarchyProvider {
    @Nullable
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            Project project2 = project;
            boolean bl = false;
            psiElement = this.getOverrideHierarchyElement(HierarchyUtilsKt.getCurrentElement(dataContext, project2));
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (HierarchyBrowser)new KotlinOverrideHierarchyBrowser(project, target);
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        Intrinsics.checkNotNullParameter((Object)hierarchyBrowser, (String)"hierarchyBrowser");
        ((HierarchyBrowserBaseEx)hierarchyBrowser).changeView(MethodHierarchyBrowserBase.getMethodType());
    }

    private final PsiElement getOverrideHierarchyElement(PsiElement element) {
        PsiElement psiElement = element;
        return psiElement != null ? PsiUtilsKt.getParentOfTypesAndPredicate$default((PsiElement)psiElement, (boolean)false, (Class[])new Class[0], KotlinOverrideHierarchyProvider::getOverrideHierarchyElement$lambda$0, (int)1, null) : null;
    }

    private static final boolean getOverrideHierarchyElement$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KotlinOverrideHierarchyProviderKt.isOverrideHierarchyElement(it);
    }
}

