/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.fe10.highlighting.KotlinBaseFe10HighlightingBundle;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuspendCallLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.SuspendCallKind;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0016\u0010\u0011\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\u0012j\u0002`\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinSuspendCallLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "<init>", "()V", "getName", "", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "collectSlowLineMarkers", "", "elements", "", "result", "", "Lorg/jetbrains/kotlin/idea/highlighter/markers/LineMarkerInfos;", "SuspendCallMarkerInfo", "kotlin.highlighting.k1"})
public final class KotlinSuspendCallLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        return KotlinBaseFe10HighlightingBundle.message("gutter.name.suspend.call", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = KotlinIcons.SUSPEND_CALL;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SUSPEND_CALL");
        return icon2;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        HashSet markedLineNumbers = new HashSet();
        for (PsiElement psiElement : elements) {
            PsiElement anchor;
            SuspendCallKind<?> kind2;
            int lineNumber;
            PsiFile containingFile;
            ProgressManager.checkCanceled();
            if (!(psiElement instanceof KtExpression) || !((containingFile = ((KtExpression)psiElement).getContainingFile()) instanceof KtFile) || containingFile instanceof KtCodeFragment || markedLineNumbers.contains(lineNumber = PsiLinesUtilsKt.getLineNumber$default(psiElement, false, 1, null)) || KotlinSuspendCallLineMarkerProviderKt.getSuspendCallKind((KtExpression)psiElement, ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)psiElement, BodyResolveMode.PARTIAL)) == null || kind2.getAnchor() == null) continue;
            ((Collection)markedLineNumbers).add(lineNumber);
            result2.add(new SuspendCallMarkerInfo(KotlinSuspendCallLineMarkerProviderKt.getElementForLineMark(anchor), kind2.getDescription()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinSuspendCallLineMarkerProvider$SuspendCallMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "callElement", "message", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "kotlin.highlighting.k1"})
    private static final class SuspendCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        public SuspendCallMarkerInfo(@NotNull PsiElement callElement, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)callElement, (String)"callElement");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(callElement, callElement.getTextRange(), KotlinIcons.SUSPEND_CALL, arg_0 -> SuspendCallMarkerInfo._init_$lambda$1(arg_0 -> SuspendCallMarkerInfo._init_$lambda$0(message2, arg_0), arg_0), null, GutterIconRenderer.Alignment.RIGHT, () -> SuspendCallMarkerInfo._init_$lambda$2(message2));
        }

        @NotNull
        public GutterIconRenderer createGutterRenderer() {
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }

        private static final String _init_$lambda$0(String $message, PsiElement it) {
            return $message;
        }

        private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final String _init_$lambda$2(String $message) {
            return $message;
        }
    }
}

