/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.highlighting.dsl.DslStyleUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.dsl.DslKotlinHighlightingVisitorExtension;
import org.jetbrains.kotlin.idea.highlighter.dsl.DslKotlinHighlightingVisitorExtensionKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtScriptInitializer;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\f0\u000bj\u0002`\r\u001a\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"navHandler", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "Lcom/intellij/psi/PsiElement;", "toolTipHandler", "Lcom/intellij/util/Function;", "", "collectHighlightingColorsMarkers", "", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/idea/highlighter/markers/LineMarkerInfos;", "styleIdForMarkerAnnotation", "", "(Lorg/jetbrains/kotlin/psi/KtClass;)Ljava/lang/Integer;", "toDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kotlin.highlighting.k1"})
@SourceDebugExtension(value={"SMAP\nDslHighlightingMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DslHighlightingMarker.kt\norg/jetbrains/kotlin/idea/highlighter/markers/DslHighlightingMarkerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class DslHighlightingMarkerKt {
    @NotNull
    private static final GutterIconNavigationHandler<PsiElement> navHandler = DslHighlightingMarkerKt::navHandler$lambda$0;
    @NotNull
    private static final Function<PsiElement, String> toolTipHandler = DslHighlightingMarkerKt::toolTipHandler$lambda$0;

    public static final void collectHighlightingColorsMarkers(@NotNull KtClass ktClass, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter((Object)ktClass, (String)"ktClass");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!KotlinLineMarkerOptions.INSTANCE.getDslOption().isEnabled()) {
            return;
        }
        Integer n = DslHighlightingMarkerKt.styleIdForMarkerAnnotation(ktClass);
        if (n == null) {
            return;
        }
        int styleId = n;
        PsiElement psiElement = ktClass.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        result2.add(new LineMarkerInfo(anchor, anchor.getTextRange(), DslStyleUtils.INSTANCE.createDslStyleIcon(styleId), toolTipHandler, navHandler, GutterIconRenderer.Alignment.RIGHT, DslHighlightingMarkerKt::collectHighlightingColorsMarkers$lambda$0));
    }

    private static final Integer styleIdForMarkerAnnotation(KtClass $this$styleIdForMarkerAnnotation) {
        DeclarationDescriptor declarationDescriptor = DslHighlightingMarkerKt.toDescriptor((KtDeclaration)$this$styleIdForMarkerAnnotation);
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2.getKind() != ClassKind.ANNOTATION_CLASS) {
            return null;
        }
        if (!DslKotlinHighlightingVisitorExtensionKt.isDslHighlightingMarker(classDescriptor2)) {
            return null;
        }
        return DslKotlinHighlightingVisitorExtension.Companion.styleIdByMarkerAnnotation(classDescriptor2);
    }

    @Nullable
    public static final DeclarationDescriptor toDescriptor(@NotNull KtDeclaration $this$toDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$toDescriptor, (String)"<this>");
        if ($this$toDescriptor instanceof KtScriptInitializer) {
            return null;
        }
        return ResolutionUtils.resolveToDescriptorIfAny$default($this$toDescriptor, null, 1, null);
    }

    private static final void navHandler$lambda$0(MouseEvent event, PsiElement element) {
        JComponent jComponent;
        block6: {
            block5: {
                Component component = event.getComponent();
                jComponent = component instanceof JComponent ? (JComponent)component : null;
                if (jComponent == null) break block5;
                JComponent it = jComponent;
                boolean bl = false;
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)it);
                jComponent = dataContext;
                if (dataContext != null) break block6;
            }
            return;
        }
        JComponent dataContext = jComponent;
        PsiElement psiElement = element;
        PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
        KtClass ktClass = psiElement2 instanceof KtClass ? (KtClass)psiElement2 : null;
        if (ktClass == null) {
            return;
        }
        KtClass ktClass2 = ktClass;
        Integer n = DslHighlightingMarkerKt.styleIdForMarkerAnnotation(ktClass2);
        if (n == null) {
            return;
        }
        int styleId = n;
        ColorAndFontOptions.selectOrEditColor((DataContext)dataContext, (String)DslStyleUtils.INSTANCE.styleOptionDisplayName(styleId), (String)"Kotlin");
    }

    private static final String toolTipHandler$lambda$0(PsiElement it) {
        return KotlinBundle.message((String)"highlighter.tool.tip.marker.annotation.for.dsl", (Object[])new Object[0]);
    }

    private static final String collectHighlightingColorsMarkers$lambda$0() {
        return KotlinBundle.message((String)"highlighter.tool.tip.marker.annotation.for.dsl", (Object[])new Object[0]);
    }
}

