/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.MarkersKt;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasExpectActualMarkerUtilKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasExpectedMarkerKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005*\u00020\u0003\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"getExpectedDeclarationTooltip", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "allNavigatableExpectedDeclarations", "", "buildNavigateToExpectedDeclarationsPopup", "Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/NavigationPopupDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class HasExpectedMarkerKt {
    @Nullable
    public static final String getExpectedDeclarationTooltip(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration);
        MemberDescriptor memberDescriptor = declarationDescriptor instanceof MemberDescriptor ? (MemberDescriptor)declarationDescriptor : null;
        if (memberDescriptor == null) {
            return null;
        }
        MemberDescriptor descriptor2 = memberDescriptor;
        List<DeclarationDescriptor> expectDescriptors = ExpectActualUtilKt.expectedDescriptors(descriptor2);
        String string = HasExpectActualMarkerUtilKt.getModulesStringForExpectActualMarkerTooltip(expectDescriptors);
        if (string == null) {
            return null;
        }
        String modulesString = string;
        Object[] objectArray = new Object[]{modulesString, expectDescriptors.size() == 1 ? 0 : 1};
        return KotlinBundle.message((String)"highlighter.tool.tip.has.expect.declaration.in", (Object[])objectArray);
    }

    @NotNull
    public static final List<KtDeclaration> allNavigatableExpectedDeclarations(@NotNull KtDeclaration $this$allNavigatableExpectedDeclarations) {
        Intrinsics.checkNotNullParameter((Object)$this$allNavigatableExpectedDeclarations, (String)"<this>");
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)ExpectActualUtilKt.expectedDeclarationIfAny($this$allNavigatableExpectedDeclarations)), (Sequence)SequencesKt.mapNotNull(MarkersKt.findMarkerBoundDeclarations($this$allNavigatableExpectedDeclarations), HasExpectedMarkerKt::allNavigatableExpectedDeclarations$lambda$0));
    }

    @Nullable
    public static final NavigationPopupDescriptor buildNavigateToExpectedDeclarationsPopup(@Nullable PsiElement element) {
        return MarkersKt.buildNavigateToExpectedDeclarationsPopup(element, (Function1<? super KtDeclaration, ? extends Collection<? extends KtDeclaration>>)((Function1)buildNavigateToExpectedDeclarationsPopup.1.INSTANCE));
    }

    private static final KtDeclaration allNavigatableExpectedDeclarations$lambda$0(KtNamedDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ExpectActualUtilKt.expectedDeclarationIfAny((KtDeclaration)it);
    }
}

