/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.AbstractKotlinLineMarkerProvider;
import org.jetbrains.kotlin.idea.highlighter.markers.DslHighlightingMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0016\u0010\t\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\nj\u0002`\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProvider;", "Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/AbstractKotlinLineMarkerProvider;", "<init>", "()V", "doCollectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/LineMarkerInfos;", "kotlin.idea"})
public final class KotlinLineMarkerProvider
extends AbstractKotlinLineMarkerProvider {
    @Override
    public void doCollectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        HashSet<KtNamedDeclaration> functions = new HashSet<KtNamedDeclaration>();
        HashSet<KtNamedDeclaration> properties = new HashSet<KtNamedDeclaration>();
        HashSet<KtNamedDeclaration> declarations2 = new HashSet<KtNamedDeclaration>();
        for (PsiElement psiElement : elements) {
            KtNamedDeclaration element;
            ProgressManager.checkCanceled();
            if (!(psiElement instanceof PsiIdentifier) && psiElement.getFirstChild() != null) continue;
            PsiElement psiElement2 = psiElement.getParent();
            KtNamedDeclaration ktNamedDeclaration = psiElement2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement2 : null;
            if (ktNamedDeclaration == null || !declarations2.add(element = ktNamedDeclaration)) continue;
            KtNamedDeclaration ktNamedDeclaration2 = element;
            if (ktNamedDeclaration2 instanceof KtClass) {
                KotlinLineMarkerProviderKt.access$collectInheritedClassMarker((KtClass)element, result2);
                DslHighlightingMarkerKt.collectHighlightingColorsMarkers((KtClass)element, result2);
            } else if (ktNamedDeclaration2 instanceof KtNamedFunction) {
                functions.add(element);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)element, result2);
            } else if (ktNamedDeclaration2 instanceof KtProperty) {
                properties.add(element);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)element, result2);
            } else if (ktNamedDeclaration2 instanceof KtParameter && ((KtParameter)element).hasValOrVar()) {
                properties.add(element);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)element, result2);
            }
            KotlinLineMarkerProviderKt.access$collectMultiplatformMarkers(element, result2);
        }
        KotlinLineMarkerProviderKt.access$collectOverriddenFunctions(functions, result2);
        KotlinLineMarkerProviderKt.access$collectOverriddenPropertyAccessors(properties, result2);
    }
}

