/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.analyzers;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaAnonymousObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassifierSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeParameterType;
import org.jetbrains.kotlin.analysis.api.types.TypeUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.HighlightingFactory;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightInfoTypeSemanticNames;
import org.jetbrains.kotlin.idea.highlighting.analyzers.KotlinSemanticAnalyzer;
import org.jetbrains.kotlin.idea.highlighting.analyzers.KotlinTypeSemanticAnalyzerKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtIntersectionType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/analyzers/KotlinTypeSemanticAnalyzer;", "Lorg/jetbrains/kotlin/idea/highlighting/analyzers/KotlinSemanticAnalyzer;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "session", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<init>", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "visitSimpleNameExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitIntersectionType", "intersectionType", "Lorg/jetbrains/kotlin/psi/KtIntersectionType;", "highlightSimpleNameExpression", "toInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol;", "highlight", "element", "Lcom/intellij/psi/PsiElement;", "color", "isAnnotationCall", "", "target", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "intellij.kotlin.highlighting"})
public final class KotlinTypeSemanticAnalyzer
extends KotlinSemanticAnalyzer {
    public KotlinTypeSemanticAnalyzer(@NotNull HighlightInfoHolder holder2, @NotNull KaSession session2) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        super(holder2, session2);
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.highlightSimpleNameExpression(expression);
    }

    public void visitIntersectionType(@NotNull KtIntersectionType intersectionType) {
        Intrinsics.checkNotNullParameter((Object)intersectionType, (String)"intersectionType");
        PsiElement[] psiElementArray = intersectionType.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        for (PsiElement psiElement : psiElementArray) {
            Object object;
            KtTypeReference typeReference;
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement element = psiElement;
            if ((element instanceof KtTypeReference ? (KtTypeReference)element : null) == null) continue;
            typeReference = typeReference;
            KaSession $this$visitIntersectionType_u24lambda_u240 = this.getSession();
            boolean bl = false;
            KaType type2 = $this$visitIntersectionType_u24lambda_u240.getType(typeReference);
            if (type2 instanceof KaTypeParameterType) {
                object = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_PARAMETER();
            } else {
                KaClassLikeSymbol kaClassLikeSymbol = TypeUtilsKt.getSymbol(type2);
                object = kaClassLikeSymbol != null ? this.toInfoType(kaClassLikeSymbol) : null;
            }
            if (object == null) continue;
            HighlightInfoType infoType = object;
            this.highlight((PsiElement)typeReference, infoType);
        }
    }

    private final void highlightSimpleNameExpression(KtSimpleNameExpression expression) {
        KaSession $this$highlightSimpleNameExpression_u24lambda_u240 = this.getSession();
        boolean bl = false;
        if (KotlinTypeSemanticAnalyzerKt.isCalleeExpression(expression)) {
            return;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof KtInstanceExpressionWithLabel) {
            return;
        }
        if (KotlinTypeSemanticAnalyzerKt.access$isPartOfIntersectionType(expression)) {
            return;
        }
        if (KotlinTypeSemanticAnalyzerKt.isConstructorCallReference(expression)) {
            return;
        }
        KaSymbol kaSymbol = $this$highlightSimpleNameExpression_u24lambda_u240.resolveToSymbol((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)expression));
        KaClassifierSymbol kaClassifierSymbol = kaSymbol instanceof KaClassifierSymbol ? (KaClassifierSymbol)kaSymbol : null;
        if (kaClassifierSymbol == null) {
            return;
        }
        KaClassifierSymbol symbol = kaClassifierSymbol;
        if (this.isAnnotationCall($this$highlightSimpleNameExpression_u24lambda_u240, expression, symbol)) {
            return;
        }
        HighlightInfoType color = this.toInfoType(symbol);
        this.highlight((PsiElement)expression, color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final HighlightInfoType toInfoType(KaClassifierSymbol $this$toInfoType) {
        HighlightInfoType highlightInfoType;
        KaClassifierSymbol kaClassifierSymbol = $this$toInfoType;
        if (kaClassifierSymbol instanceof KaAnonymousObjectSymbol) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getCLASS();
            return highlightInfoType;
        }
        if (kaClassifierSymbol instanceof KaNamedClassSymbol) {
            switch (WhenMappings.$EnumSwitchMapping$1[((KaNamedClassSymbol)$this$toInfoType).getClassKind().ordinal()]) {
                case 1: {
                    if (((KaNamedClassSymbol)$this$toInfoType).isData()) {
                        highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getDATA_CLASS();
                        return highlightInfoType;
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[$this$toInfoType.getModality().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getCLASS();
                            return highlightInfoType;
                        }
                        case 4: {
                            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getABSTRACT_CLASS();
                            return highlightInfoType;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                case 2: {
                    highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getENUM();
                    return highlightInfoType;
                }
                case 3: {
                    highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION();
                    return highlightInfoType;
                }
                case 4: {
                    highlightInfoType = ((KaNamedClassSymbol)$this$toInfoType).isData() ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getDATA_OBJECT() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getOBJECT();
                    return highlightInfoType;
                }
                case 5: {
                    highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getOBJECT();
                    return highlightInfoType;
                }
                case 6: {
                    highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTRAIT();
                    return highlightInfoType;
                }
                case 7: {
                    highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getCLASS();
                    return highlightInfoType;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (kaClassifierSymbol instanceof KaTypeAliasSymbol) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_ALIAS();
            return highlightInfoType;
        } else {
            if (!(kaClassifierSymbol instanceof KaTypeParameterSymbol)) throw new NoWhenBranchMatchedException();
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_PARAMETER();
        }
        return highlightInfoType;
    }

    private final void highlight(PsiElement element, HighlightInfoType color) {
        HighlightInfo.Builder builder2 = HighlightingFactory.highlightName$default((HighlightingFactory)HighlightingFactory.INSTANCE, (PsiElement)element, (HighlightInfoType)color, null, (int)4, null);
        this.getHolder().add((HighlightInfo)(builder2 != null ? builder2.create() : null));
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isAnnotationCall(KaSession $this$isAnnotationCall, KtSimpleNameExpression expression, KaSymbol target) {
        if (!(target instanceof KaConstructorSymbol) || !((KaConstructorSymbol)target).isPrimary()) ** GOTO lbl-1000
        var6_4 = $this$isAnnotationCall.getContainingDeclaration(target);
        v0 = var6_4 instanceof KaClassSymbol != false ? (KaClassSymbol)var6_4 : null;
        if ((v0 != null ? v0.getClassKind() : null) == KaClassKind.ANNOTATION_CLASS) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = isKotlinAnnotation = false;
        }
        if (!isKotlinAnnotation) {
            targetPsi = target.getPsi();
            v2 = targetPsi instanceof KtClass != false ? ((KtClass)targetPsi).isAnnotation() : (targetIsAnnotation = targetPsi instanceof PsiClass != false ? ((PsiClass)targetPsi).isAnnotationType() : false);
            if (!targetIsAnnotation) {
                return false;
            }
        }
        var6_4 = new Class[]{KtValueArgumentList.class};
        v3 = annotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression), KtAnnotationEntry.class, (boolean)false, (Class[])var6_4);
        return (v3 != null ? v3.getAtSymbol() : null) != null;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KaSymbolModality.values().length];
            try {
                nArray[KaSymbolModality.FINAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolModality.SEALED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolModality.OPEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolModality.ABSTRACT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[KaClassKind.values().length];
            try {
                nArray[KaClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.ENUM_CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.ANNOTATION_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.COMPANION_OBJECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.INTERFACE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.ANONYMOUS_OBJECT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

