/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinOptimizeImportsFacility;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizer;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizerKt;
import org.jetbrains.kotlin.idea.imports.OptimizedImportsBuilder;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtReferenceKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.references.SyntheticPropertyAccessorReference;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.references.fe10.base.KtFe10Reference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0003\u000f\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002R\u0018\u0010\n\u001a\u00020\u0005*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer;", "Lcom/intellij/lang/ImportOptimizer;", "<init>", "()V", "supports", "", "file", "Lcom/intellij/psi/PsiFile;", "processFile", "Lcom/intellij/lang/ImportOptimizer$CollectingInfoRunnable;", "isDocumentUncommitted", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)Z", "prepareImports", "Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$OptimizeInformation;", "OptimizeInformation", "CollectUsedDescriptorsVisitor", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinImportOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinImportOptimizer.kt\norg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1586#2:285\n1661#2,3:286\n*S KotlinDebug\n*F\n+ 1 KotlinImportOptimizer.kt\norg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer\n*L\n90#1:285\n90#1:286,3\n*E\n"})
public final class KotlinImportOptimizer
implements ImportOptimizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Companion.DO_NOTHING.1 DO_NOTHING = new ImportOptimizer.CollectingInfoRunnable(){

        public void run() {
        }

        public String getUserNotificationInfo() {
            return KotlinBundle.message((String)"import.optimizer.notification.text.unused.imports.not.found", (Object[])new Object[0]);
        }
    };

    public boolean supports(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof KtFile;
    }

    @NotNull
    public ImportOptimizer.CollectingInfoRunnable processFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtFile ktFile2 = file instanceof KtFile ? (KtFile)file : null;
        if (ktFile2 == null) {
            return DO_NOTHING;
        }
        KtFile ktFile3 = ktFile2;
        OptimizeInformation optimizeInformation = this.prepareImports(ktFile3);
        if (optimizeInformation == null) {
            return DO_NOTHING;
        }
        OptimizeInformation optimizeInformation2 = optimizeInformation;
        int add2 = optimizeInformation2.component1();
        int remove = optimizeInformation2.component2();
        List<ImportPath> imports2 = optimizeInformation2.component3();
        return new ImportOptimizer.CollectingInfoRunnable(remove, add2, ktFile3, imports2){
            final /* synthetic */ int $remove;
            final /* synthetic */ int $add;
            final /* synthetic */ KtFile $ktFile;
            final /* synthetic */ List<ImportPath> $imports;
            {
                this.$remove = $remove;
                this.$add = $add;
                this.$ktFile = $ktFile;
                this.$imports = $imports;
            }

            public String getUserNotificationInfo() {
                String string;
                if (this.$remove == 0) {
                    string = KotlinBundle.message((String)"import.optimizer.text.zero", (Object[])new Object[0]);
                } else {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = this.$remove;
                    Object[] objectArray2 = new Object[]{this.$remove};
                    objectArray[1] = KotlinBundle.message((String)"import.optimizer.text.import", (Object[])objectArray2);
                    objectArray[2] = this.$add;
                    objectArray2 = new Object[]{this.$add};
                    objectArray[3] = KotlinBundle.message((String)"import.optimizer.text.import", (Object[])objectArray2);
                    string = KotlinBundle.message((String)"import.optimizer.text.non.zero", (Object[])objectArray);
                }
                return string;
            }

            public void run() {
                KotlinOptimizeImportsFacility.Companion.getInstance().replaceImports(this.$ktFile, (Iterable<ImportPath>)this.$imports);
            }
        };
    }

    private final boolean isDocumentUncommitted(KtFile $this$isDocumentUncommitted) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)$this$isDocumentUncommitted.getProject());
        Document cachedDocument = documentManager.getCachedDocument((PsiFile)$this$isDocumentUncommitted);
        return cachedDocument != null && documentManager.isUncommited(cachedDocument);
    }

    /*
     * WARNING - void declaration
     */
    private final OptimizeInformation prepareImports(KtFile file) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.isDocumentUncommitted(file)) {
            return null;
        }
        IdeaModuleInfo moduleInfo = ModuleInfoProviderUtils.getModuleInfoOrNull((PsiElement)file);
        if (!(moduleInfo instanceof ModuleSourceInfo) && !(moduleInfo instanceof ScriptModuleInfo)) {
            return null;
        }
        List oldImports = file.getImportDirectives();
        if (oldImports.isEmpty()) {
            return null;
        }
        OptimizedImportsBuilder.InputData descriptorsToImport = Companion.collectDescriptorsToImport(file, true);
        List<ImportPath> list2 = Companion.prepareOptimizedImports(file, descriptorsToImport);
        if (list2 == null) {
            return null;
        }
        List<ImportPath> imports2 = list2;
        Iterable iterable = oldImports;
        Iterable iterable2 = imports2;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtImportDirective ktImportDirective = (KtImportDirective)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getImportPath());
        }
        Set intersect = CollectionsKt.intersect((Iterable)iterable2, (Iterable)((List)destination$iv$iv));
        return new OptimizeInformation(imports2.size() - intersect.size(), oldImports.size() - intersect.size(), imports2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u00011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020)H\u0016J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0011\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00130\u0012j\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000ej\b\u0012\u0004\u0012\u00020\f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$CollectUsedDescriptorsVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "Lcom/intellij/psi/PsiRecursiveVisitor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "currentPackageName", "Lorg/jetbrains/kotlin/name/FqName;", "aliases", "", "", "Lorg/jetbrains/kotlin/name/Name;", "descriptorsToImport", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportableDescriptor;", "Lkotlin/collections/HashSet;", "namesToImport", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "abstractRefs", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$AbstractReference;", "Lkotlin/collections/ArrayList;", "unresolvedNames", "data", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "getData", "()Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "visitImportList", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "visitPackageDirective", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "visitKtElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isAccessibleAsMember", "", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "place", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "AbstractReferenceImpl", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinImportOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinImportOptimizer.kt\norg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$CollectUsedDescriptorsVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1026#2:285\n1062#2,3:286\n1065#2,3:296\n383#3,7:289\n383#3,7:300\n1#4:299\n1807#5,3:307\n*S KotlinDebug\n*F\n+ 1 KotlinImportOptimizer.kt\norg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$CollectUsedDescriptorsVisitor\n*L\n107#1:285\n107#1:286,3\n107#1:296,3\n107#1:289,7\n169#1:300,7\n204#1:307,3\n*E\n"})
    private static final class CollectUsedDescriptorsVisitor
    extends KtVisitorVoid
    implements PsiRecursiveVisitor {
        @NotNull
        private final FqName currentPackageName;
        @NotNull
        private final Map<FqName, List<Name>> aliases;
        @NotNull
        private final HashSet<OptimizedImportsBuilder.ImportableDescriptor> descriptorsToImport;
        @NotNull
        private final HashMap<FqName, Set<Name>> namesToImport;
        @NotNull
        private final ArrayList<OptimizedImportsBuilder.AbstractReference> abstractRefs;
        @NotNull
        private final HashSet<Name> unresolvedNames;

        /*
         * WARNING - void declaration
         */
        public CollectUsedDescriptorsVisitor(@NotNull KtFile file) {
            Map map2;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.currentPackageName = file.getPackageFqName();
            CollectUsedDescriptorsVisitor collectUsedDescriptorsVisitor = this;
            if (file.hasImportAlias()) {
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)file.getImportDirectives()), CollectUsedDescriptorsVisitor::aliases$lambda$0), CollectUsedDescriptorsVisitor::aliases$lambda$1);
                CollectUsedDescriptorsVisitor collectUsedDescriptorsVisitor2 = collectUsedDescriptorsVisitor;
                boolean $i$f$groupBy = false;
                void var4_5 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    void it;
                    Object object;
                    void $this$getOrPut$iv$iv$iv;
                    ImportPath it2 = (ImportPath)element$iv$iv;
                    boolean $i$a$-groupBy-KotlinImportOptimizer$CollectUsedDescriptorsVisitor$aliases$52 = false;
                    FqName key$iv$iv = it2.getFqName();
                    Map map3 = destination$iv$iv;
                    FqName key$iv$iv$iv = key$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    ImportPath $i$a$-groupBy-KotlinImportOptimizer$CollectUsedDescriptorsVisitor$aliases$52 = (ImportPath)element$iv$iv;
                    List list2 = list$iv$iv;
                    boolean bl = false;
                    Name name2 = it.getImportedName();
                    Intrinsics.checkNotNull((Object)name2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.name.Name");
                    list2.add(name2);
                }
                map2 = destination$iv$iv;
                collectUsedDescriptorsVisitor = collectUsedDescriptorsVisitor2;
            } else {
                map2 = MapsKt.emptyMap();
            }
            collectUsedDescriptorsVisitor.aliases = map2;
            this.descriptorsToImport = new HashSet();
            this.namesToImport = new HashMap();
            this.abstractRefs = new ArrayList();
            this.unresolvedNames = new HashSet();
        }

        @NotNull
        public final OptimizedImportsBuilder.InputData getData() {
            return new OptimizedImportsBuilder.InputData((Set<OptimizedImportsBuilder.ImportableDescriptor>)this.descriptorsToImport, (Map<FqName, ? extends Set<Name>>)this.namesToImport, (Collection<? extends OptimizedImportsBuilder.AbstractReference>)this.abstractRefs, (Set<Name>)this.unresolvedNames);
        }

        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            ProgressIndicatorProvider.checkCanceled();
            element.acceptChildren((PsiElementVisitor)this);
        }

        public void visitImportList(@NotNull KtImportList importList) {
            Intrinsics.checkNotNullParameter((Object)importList, (String)"importList");
        }

        public void visitPackageDirective(@NotNull KtPackageDirective directive) {
            Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        }

        /*
         * WARNING - void declaration
         */
        public void visitKtElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super.visitKtElement(element);
            if (element instanceof KtLabelReferenceExpression) {
                return;
            }
            PsiReference[] psiReferenceArray = element.getReferences();
            if (psiReferenceArray.length == 0) {
                boolean bl = false;
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"ifEmpty(...)");
            PsiReference[] references = psiReferenceArray;
            BindingContext bindingContext = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode(element, BodyResolveMode.PARTIAL);
            boolean isResolved = KotlinImportOptimizerKt.access$hasResolvedDescriptor(element, bindingContext);
            for (PsiReference reference : references) {
                if (!(reference instanceof KtReference)) continue;
                ProgressIndicatorProvider.checkCanceled();
                this.abstractRefs.add(new AbstractReferenceImpl((KtReference)reference));
                Collection names = ((KtReference)reference).getResolvesByNames();
                if (!isResolved) {
                    CollectionsKt.addAll((Collection)this.unresolvedNames, (Iterable)names);
                }
                for (DeclarationDescriptor target : Companion.targets((KtReference)reference, bindingContext)) {
                    Object object;
                    void $this$getOrPut$iv;
                    FqName importableFqName;
                    DeclarationDescriptor importableDescriptor = DescriptorUtilsKt.getImportableDescriptor((DeclarationDescriptor)target);
                    if (ImportsUtils.getImportableFqName(target) == null) continue;
                    FqName parentFqName = importableFqName.parent();
                    if (target instanceof PackageViewDescriptor && Intrinsics.areEqual((Object)parentFqName, (Object)FqName.ROOT) || !(target instanceof PackageViewDescriptor) && Intrinsics.areEqual((Object)parentFqName, (Object)this.currentPackageName) && !this.aliases.containsKey(importableFqName)) continue;
                    ProgressIndicatorProvider.checkCanceled();
                    if (!ReferenceUtilKt.canBeResolvedViaImport((KtReference)reference, target, bindingContext) || names.contains(importableDescriptor.getName()) && this.isAccessibleAsMember(importableDescriptor, element, bindingContext)) continue;
                    List list2 = this.aliases.get(importableFqName);
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    Set descriptorNames = CollectionsKt.intersect((Iterable)CollectionsKt.plus((Collection)list2, (Object)importableFqName.shortName()), (Iterable)names);
                    Map map2 = this.namesToImport;
                    FqName key$iv = importableFqName;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        Set answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    CollectionsKt.addAll((Collection)((Collection)object), (Iterable)descriptorNames);
                    ((Collection)this.descriptorsToImport).add(new OptimizedImportsBuilder.ImportableDescriptor(importableDescriptor, importableFqName));
                }
            }
        }

        private final boolean isAccessibleAsMember(DeclarationDescriptor target, KtElement place, BindingContext bindingContext) {
            boolean bl;
            block7: {
                if (!(target.getContainingDeclaration() instanceof ClassDescriptor)) {
                    return false;
                }
                LexicalScope resolutionScope = ScopeUtils.getResolutionScope((PsiElement)place, bindingContext, ResolutionUtils.getResolutionFacade(place));
                LexicalScope noImportsScope = ScopeUtilsKt.replaceImportingScopes((LexicalScope)resolutionScope, null);
                if (CollectUsedDescriptorsVisitor.isAccessibleAsMember$isInScope(target, bindingContext, place, (HierarchicalScope)noImportsScope)) {
                    return true;
                }
                if (target instanceof ClassDescriptor) {
                    bl = false;
                } else {
                    Iterable $this$any$iv = ScopeUtilsKt.getImplicitReceiversHierarchy((LexicalScope)resolutionScope);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv;
                            boolean bl2 = false;
                            if (!CollectUsedDescriptorsVisitor.isAccessibleAsMember$isInScope(target, bindingContext, place, (HierarchicalScope)ScopeUtilsKt.memberScopeAsImportingScope$default((MemberScope)it.getType().getMemberScope(), null, (int)1, null))) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
            }
            return bl;
        }

        private static final boolean aliases$lambda$0(KtImportDirective it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !it.isAllUnder() && it.getAlias() != null;
        }

        private static final ImportPath aliases$lambda$1(KtImportDirective it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getImportPath();
        }

        private static final boolean isAccessibleAsMember$isInScope$lambda$0(DeclarationDescriptor $target, FunctionDescriptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it, (Object)$target);
        }

        private static final boolean isAccessibleAsMember$isInScope$lambda$1(DeclarationDescriptor $target, VariableDescriptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it, (Object)$target);
        }

        private static final boolean isAccessibleAsMember$isInScope(DeclarationDescriptor $target, BindingContext $bindingContext, KtElement $place, HierarchicalScope scope) {
            boolean bl;
            ProgressIndicatorProvider.checkCanceled();
            DeclarationDescriptor declarationDescriptor = $target;
            if (declarationDescriptor instanceof FunctionDescriptor) {
                Name name2 = ((FunctionDescriptor)$target).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                bl = ScopeUtilsKt.findFunction((HierarchicalScope)scope, (Name)name2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), arg_0 -> CollectUsedDescriptorsVisitor.isAccessibleAsMember$isInScope$lambda$0($target, arg_0)) != null && !Intrinsics.areEqual((Object)$bindingContext.get((ReadOnlySlice)BindingContext.DEPRECATED_SHORT_NAME_ACCESS, (Object)$place), (Object)true);
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                Name name3 = ((PropertyDescriptor)$target).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"getName(...)");
                bl = ScopeUtilsKt.findVariable((HierarchicalScope)scope, (Name)name3, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), arg_0 -> CollectUsedDescriptorsVisitor.isAccessibleAsMember$isInScope$lambda$1($target, arg_0)) != null && !Intrinsics.areEqual((Object)$bindingContext.get((ReadOnlySlice)BindingContext.DEPRECATED_SHORT_NAME_ACCESS, (Object)$place), (Object)true);
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                Name name4 = ((ClassDescriptor)$target).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"getName(...)");
                bl = Intrinsics.areEqual((Object)ScopeUtilsKt.findClassifier((HierarchicalScope)scope, (Name)name4, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE)), (Object)$target) && !Intrinsics.areEqual((Object)$bindingContext.get((ReadOnlySlice)BindingContext.DEPRECATED_SHORT_NAME_ACCESS, (Object)$place), (Object)true);
            } else {
                bl = false;
            }
            return bl;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u00020\u0014H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$CollectUsedDescriptorsVisitor$AbstractReferenceImpl;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$AbstractReference;", "reference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "<init>", "(Lorg/jetbrains/kotlin/idea/references/KtReference;)V", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "dependsOnNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getDependsOnNames", "()Ljava/util/Collection;", "resolve", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "toString", "", "kotlin.idea"})
        private static final class AbstractReferenceImpl
        implements OptimizedImportsBuilder.AbstractReference {
            @NotNull
            private final KtReference reference;

            public AbstractReferenceImpl(@NotNull KtReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                this.reference = reference;
            }

            @Override
            @NotNull
            public KtElement getElement() {
                return this.reference.getElement();
            }

            @Override
            @NotNull
            public Collection<Name> getDependsOnNames() {
                Collection resolvesByNames = this.reference.getResolvesByNames();
                if (this.reference instanceof KtInvokeFunctionReference) {
                    Collection additionalNames;
                    KtExpression ktExpression = ((KtCallExpression)((KtInvokeFunctionReference)this.reference).getElement()).getCalleeExpression();
                    KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
                    Collection collection = ktNameReferenceExpression != null && (ktNameReferenceExpression = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)ktNameReferenceExpression))) != null ? ktNameReferenceExpression.getResolvesByNames() : (additionalNames = null);
                    if (additionalNames != null) {
                        return CollectionsKt.plus((Collection)resolvesByNames, (Iterable)additionalNames);
                    }
                }
                return resolvesByNames;
            }

            @Override
            @NotNull
            public Collection<DeclarationDescriptor> resolve(@NotNull BindingContext bindingContext) {
                Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
                return KtReferenceKt.resolveToDescriptors(this.reference, bindingContext);
            }

            @NotNull
            public String toString() {
                return this.reference instanceof SyntheticPropertyAccessorReference && this.reference instanceof KtFe10Reference ? StringsKt.replace$default((String)((SyntheticPropertyAccessorReference)this.reference).toString(), (String)"Fe10SyntheticPropertyAccessorReference", (String)(((SyntheticPropertyAccessorReference)this.reference).getGetter() ? "Getter" : "Setter"), (boolean)false, (int)4, null) : StringsKt.replace$default((String)this.reference.toString(), (String)"Fe10", (String)"", (boolean)false, (int)4, null);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003*\u0001\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion;", "", "<init>", "()V", "collectDescriptorsToImport", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "inProgressBar", "", "prepareOptimizedImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "data", "targets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "DO_NOTHING", "org/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion$DO_NOTHING$1", "Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion$DO_NOTHING$1;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinImportOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinImportOptimizer.kt\norg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n1#2:285\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OptimizedImportsBuilder.InputData collectDescriptorsToImport(@NotNull KtFile file, boolean inProgressBar) {
            ProgressIndicator progressIndicator;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ProgressIndicator progressIndicator2 = progressIndicator = inProgressBar ? ProgressIndicatorProvider.getInstance().getProgressIndicator() : null;
            if (progressIndicator2 != null) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
                progressIndicator2.setText(KotlinBundle.message((String)"import.optimizer.progress.indicator.text.collect.imports.for", (Object[])objectArray));
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setIndeterminate(true);
            }
            CollectUsedDescriptorsVisitor visitor2 = new CollectUsedDescriptorsVisitor(file);
            file.accept((PsiElementVisitor)visitor2);
            return visitor2.getData();
        }

        public static /* synthetic */ OptimizedImportsBuilder.InputData collectDescriptorsToImport$default(Companion companion, KtFile ktFile2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.collectDescriptorsToImport(ktFile2, bl);
        }

        @Nullable
        public final List<ImportPath> prepareOptimizedImports(@NotNull KtFile file, @NotNull OptimizedImportsBuilder.InputData data) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            KotlinCodeStyleSettings settings2 = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)((PsiFile)file));
            OptimizedImportsBuilder.Options options2 = new OptimizedImportsBuilder.Options(settings2.NAME_COUNT_TO_USE_STAR_IMPORT, settings2.NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS, (Function1<? super FqName, Boolean>)((Function1)arg_0 -> Companion.prepareOptimizedImports$lambda$0(settings2, arg_0)));
            return new OptimizedImportsBuilder(file, data, options2, LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)file).getApiVersion()).buildOptimizedImports();
        }

        /*
         * Enabled aggressive block sorting
         */
        private final Collection<DeclarationDescriptor> targets(KtReference $this$targets, BindingContext bindingContext) {
            Collection collection;
            KtElement ktElement = $this$targets.getElement();
            Object object = (ClassifierDescriptorWithTypeParameters)bindingContext.get((ReadOnlySlice)BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, (Object)(ktElement instanceof KtReferenceExpression ? (KtReferenceExpression)ktElement : null));
            if (object != null) {
                ClassifierDescriptorWithTypeParameters it = object;
                boolean bl = false;
                List list2 = CollectionsKt.listOf((Object)it);
                object = list2;
                if (list2 != null) {
                    collection = (Collection)object;
                    return collection;
                }
            }
            collection = KtReferenceKt.resolveToDescriptors($this$targets, bindingContext);
            return collection;
        }

        private static final boolean prepareOptimizedImports$lambda$0(KotlinCodeStyleSettings $settings, FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            return $settings.PACKAGES_TO_USE_STAR_IMPORTS.contains(fqName2.asString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$OptimizeInformation;", "", "add", "", "remove", "imports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "<init>", "(IILjava/util/List;)V", "getAdd", "()I", "getRemove", "getImports", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin.idea"})
    private static final class OptimizeInformation {
        private final int add;
        private final int remove;
        @NotNull
        private final List<ImportPath> imports;

        public OptimizeInformation(int add2, int remove, @NotNull List<ImportPath> imports2) {
            Intrinsics.checkNotNullParameter(imports2, (String)"imports");
            this.add = add2;
            this.remove = remove;
            this.imports = imports2;
        }

        public final int getAdd() {
            return this.add;
        }

        public final int getRemove() {
            return this.remove;
        }

        @NotNull
        public final List<ImportPath> getImports() {
            return this.imports;
        }

        public final int component1() {
            return this.add;
        }

        public final int component2() {
            return this.remove;
        }

        @NotNull
        public final List<ImportPath> component3() {
            return this.imports;
        }

        @NotNull
        public final OptimizeInformation copy(int add2, int remove, @NotNull List<ImportPath> imports2) {
            Intrinsics.checkNotNullParameter(imports2, (String)"imports");
            return new OptimizeInformation(add2, remove, imports2);
        }

        public static /* synthetic */ OptimizeInformation copy$default(OptimizeInformation optimizeInformation, int n, int n2, List list2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = optimizeInformation.add;
            }
            if ((n3 & 2) != 0) {
                n2 = optimizeInformation.remove;
            }
            if ((n3 & 4) != 0) {
                list2 = optimizeInformation.imports;
            }
            return optimizeInformation.copy(n, n2, list2);
        }

        @NotNull
        public String toString() {
            return "OptimizeInformation(add=" + this.add + ", remove=" + this.remove + ", imports=" + this.imports + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.add);
            result2 = result2 * 31 + Integer.hashCode(this.remove);
            result2 = result2 * 31 + ((Object)this.imports).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OptimizeInformation)) {
                return false;
            }
            OptimizeInformation optimizeInformation = (OptimizeInformation)other;
            if (this.add != optimizeInformation.add) {
                return false;
            }
            if (this.remove != optimizeInformation.remove) {
                return false;
            }
            return Intrinsics.areEqual(this.imports, optimizeInformation.imports);
        }
    }
}

