/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ConvertNaNEqualityInspectionKt;
import org.jetbrains.kotlin.idea.inspections.ConvertNaNEqualityQuickFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertNaNEqualityInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class ConvertNaNEqualityInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.binaryExpressionVisitor(arg_0 -> ConvertNaNEqualityInspection.buildVisitor$lambda$0(holder2, arg_0));
    }

    private static final Unit buildVisitor$lambda$0(ProblemsHolder $holder, KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (ConvertNaNEqualityInspectionKt.access$isNaNExpression(expression.getLeft()) || ConvertNaNEqualityInspectionKt.access$isNaNExpression(expression.getRight())) {
            boolean bl;
            LocalQuickFix[] localQuickFixArray = expression.getOperationToken();
            if (Intrinsics.areEqual((Object)localQuickFixArray, (Object)KtTokens.EXCLEQ)) {
                bl = true;
            } else if (Intrinsics.areEqual((Object)localQuickFixArray, (Object)KtTokens.EQEQ)) {
                bl = false;
            } else {
                return Unit.INSTANCE;
            }
            boolean inverted = bl;
            localQuickFixArray = new LocalQuickFix[]{new ConvertNaNEqualityQuickFix(inverted)};
            $holder.registerProblem((PsiElement)expression, KotlinBundle.message((String)"equality.check.with.nan.should.be.replaced.with.isnan", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
        }
        return Unit.INSTANCE;
    }
}

