/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.ConvertNaNEqualityInspectionKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertNaNEqualityQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "inverted", "", "<init>", "(Z)V", "getInverted", "()Z", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
final class ConvertNaNEqualityQuickFix
implements LocalQuickFix {
    private final boolean inverted;

    public ConvertNaNEqualityQuickFix(boolean inverted) {
        this.inverted = inverted;
    }

    public final boolean getInverted() {
        return this.inverted;
    }

    @NotNull
    public String getName() {
        return KotlinBundle.message((String)"convert.na.n.equality.quick.fix.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression element = ktBinaryExpression;
        if (ConvertNaNEqualityInspectionKt.access$isNaNExpression(element.getLeft())) {
            ktExpression = element.getRight();
            if (ktExpression == null) {
                return;
            }
        } else if (ConvertNaNEqualityInspectionKt.access$isNaNExpression(element.getRight())) {
            ktExpression = element.getLeft();
            if (ktExpression == null) {
                return;
            }
        } else {
            return;
        }
        KtExpression other = ktExpression;
        String pattern2 = this.inverted ? "!$0.isNaN()" : "$0.isNaN()";
        Object[] objectArray = new Object[]{other};
        element.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)pattern2, (Object[])objectArray, (boolean)false, (int)4, null));
    }
}

