/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MoveLambdaOutsideParenthesesInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "()V", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "element", "isApplicable", "", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionText", "", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "kotlin.idea"})
public final class MoveLambdaOutsideParenthesesInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    public MoveLambdaOutsideParenthesesInspection() {
        super(KtCallExpression.class);
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinCommonRefactoringUtilKt.isComplexCallWithLambdaArgument(element) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    @Override
    public boolean isApplicable(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(element, false);
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(element, false)) {
            KotlinCommonRefactoringUtilKt.moveFunctionLiteralOutsideParentheses$default(element, null, 1, null);
        }
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new Object[]{KotlinCommonRefactoringUtilKt.isComplexCallWithLambdaArgument(element) ? 0 : 1};
        return KotlinBundle.message((String)"lambda.argument.0.be.moved.out", (Object[])objectArray);
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtLambdaExpression ktLambdaExpression = KotlinCommonRefactoringUtilKt.getLastLambdaExpression(element);
        return ktLambdaExpression != null && (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) != null && (ktLambdaExpression = ktLambdaExpression.getLBrace()) != null ? TextRangeUtilsKt.textRangeIn((PsiElement)ktLambdaExpression, (PsiElement)element) : null;
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"move.lambda.argument.out.of.parentheses", (Object[])new Object[0]);
    }
}

