/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantUnitExpressionInspectionKt;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantUnitFix;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantUnitExpressionInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Util", "kotlin.idea"})
public final class RedundantUnitExpressionInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.referenceExpressionVisitor(arg_0 -> RedundantUnitExpressionInspection.buildVisitor$lambda$0(holder2, arg_0));
    }

    private static final Unit buildVisitor$lambda$0(ProblemsHolder $holder, KtReferenceExpression expression) {
        if (Util.INSTANCE.isRedundantUnit(expression)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveRedundantUnitFix()};
            $holder.registerProblem((PsiElement)expression, KotlinBundle.message((String)"redundant.unit", (Object[])new Object[0]), localQuickFixArray);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantUnitExpressionInspection$Util;", "", "<init>", "()V", "isRedundantUnit", "", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "kotlin.idea"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        public final boolean isRedundantUnit(@NotNull KtReferenceExpression referenceExpression) {
            Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
            if (!ExpressionExtKt.isUnitLiteral((KtExpression)referenceExpression)) {
                return false;
            }
            PsiElement psiElement = referenceExpression.getParent();
            if (psiElement == null) {
                return false;
            }
            PsiElement parent = psiElement;
            if (parent instanceof KtReturnExpression) {
                KotlinType kotlinType = RedundantUnitExpressionInspectionKt.access$expectedReturnType((KtReturnExpression)parent);
                if (kotlinType == null) {
                    return false;
                }
                KotlinType expectedReturnType = kotlinType;
                return !Intrinsics.areEqual((Object)DescriptorUtilsKt.getNameIfStandardType((KotlinType)expectedReturnType), (Object)StandardNames.FqNames.any.shortName()) && !expectedReturnType.isMarkedNullable();
            }
            if (parent instanceof KtBlockExpression) {
                if (Intrinsics.areEqual((Object)referenceExpression, (Object)KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)((KtExpression)parent)))) {
                    KtExpression parentIfOrWhen = RedundantUnitExpressionInspectionKt.access$getParentIfOrWhen((KtExpression)parent);
                    KtExpression ktExpression = CommonUtilsKt.previousStatement((KtExpression)referenceExpression);
                    if (ktExpression == null) {
                        return parentIfOrWhen == null;
                    }
                    KtExpression prev = ktExpression;
                    if (ExpressionExtKt.isUnitLiteral(prev)) {
                        return true;
                    }
                    if (prev instanceof KtDeclaration && RedundantUnitExpressionInspectionKt.access$isDynamicCall((KtBlockExpression)parent)) {
                        return false;
                    }
                    BindingContext context2 = ResolutionUtils.analyze((KtElement)prev, BodyResolveMode.PARTIAL);
                    KotlinType prevType = context2.getType(prev);
                    if (prevType != null) {
                        return TypeUtilsKt.isUnit((KotlinType)prevType) && RedundantUnitExpressionInspectionKt.access$canBeUsedAsValue(prev, context2);
                    }
                    if (!(prev instanceof KtDeclaration)) {
                        return false;
                    }
                    if (!(prev instanceof KtFunction)) {
                        return true;
                    }
                    return parentIfOrWhen == null;
                }
                return true;
            }
            return false;
        }
    }
}

