/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantQualifierNameInspectionKt;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantQualifierNameQuickFix$applyFix$;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantQualifierNameQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nRemoveRedundantQualifierNameInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveRedundantQualifierNameInspection.kt\norg/jetbrains/kotlin/idea/inspections/RemoveRedundantQualifierNameQuickFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n611#2,2:232\n1915#3,2:234\n*S KotlinDebug\n*F\n+ 1 RemoveRedundantQualifierNameInspection.kt\norg/jetbrains/kotlin/idea/inspections/RemoveRedundantQualifierNameQuickFix\n*L\n218#1:232,2\n226#1:234,2\n*E\n"})
public final class RemoveRedundantQualifierNameQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return KotlinBundle.message((String)"remove.redundant.qualifier.name.quick.fix.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        int endOffset;
        String selectorReference;
        IntRange intRange;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile file = (KtFile)psiFile;
        PsiElement element = descriptor2.getPsiElement();
        if (element instanceof KtUserType) {
            intRange = new IntRange(PsiUtilsKt.getStartOffset((PsiElement)element), PsiUtilsKt.getEndOffset((PsiElement)element));
        } else if (element instanceof KtDotQualifiedExpression) {
            int n;
            KtExpression ktExpression = ((KtDotQualifiedExpression)element).getSelectorExpression();
            String string = selectorReference = ktExpression != null ? RemoveRedundantQualifierNameInspectionKt.access$declarationDescriptor((KtElement)ktExpression, ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)element, BodyResolveMode.FULL)) : null;
            if (RemoveRedundantQualifierNameInspectionKt.access$isEnumClass((DeclarationDescriptor)selectorReference) || RemoveRedundantQualifierNameInspectionKt.access$isEnumCompanionObject((DeclarationDescriptor)selectorReference)) {
                n = PsiUtilsKt.getEndOffset((PsiElement)element);
            } else {
                KtDotQualifiedExpression ktDotQualifiedExpression;
                PsiElement $this$getLastParentOfTypeInRowWithSelf$iv = element;
                boolean $i$f$getLastParentOfTypeInRowWithSelf = false;
                Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)$this$getLastParentOfTypeInRowWithSelf$iv), (Function1)applyFix$$inlined$getLastParentOfTypeInRowWithSelf$1.INSTANCE));
                if (!(object instanceof KtDotQualifiedExpression)) {
                    object = null;
                }
                if ((ktDotQualifiedExpression = (KtDotQualifiedExpression)((PsiElement)((KtDotQualifiedExpression)object))) != null && (ktDotQualifiedExpression = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktDotQualifiedExpression))) != null) {
                    n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktDotQualifiedExpression));
                } else {
                    return;
                }
            }
            endOffset = n;
            intRange = new IntRange(PsiUtilsKt.getStartOffset((PsiElement)element), endOffset);
        } else {
            intRange = IntRange.Companion.getEMPTY();
        }
        IntRange range2 = intRange;
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        selectorReference = string;
        endOffset = range2.getFirst();
        int n = range2.getLast();
        String string2 = selectorReference.substring(endOffset, n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String substring = string2;
        Regex regex = Regex.Companion.fromLiteral(substring);
        String string3 = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        KtImportList ktImportList = file.getImportList();
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)regex.findAll((CharSequence)string3, ktImportList != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktImportList)) : 0)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult it = (MatchResult)element$iv;
            boolean bl = false;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, file, it.getRange().getFirst(), it.getRange().getLast() + 1, null, false, 24, null);
        }
    }
}

