/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.psi.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\u0002H\u0002R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SimplifyAssertNotNullInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "()V", "isApplicable", "", "element", "inspectionText", "", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "fixText", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "findVariableDeclaration", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "extractMessage", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSimplifyAssertNotNullInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyAssertNotNullInspection.kt\norg/jetbrains/kotlin/idea/inspections/SimplifyAssertNotNullInspection\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,112:1\n18#2,2:113\n*S KotlinDebug\n*F\n+ 1 SimplifyAssertNotNullInspection.kt\norg/jetbrains/kotlin/idea/inspections/SimplifyAssertNotNullInspection\n*L\n100#1:113,2\n*E\n"})
public final class SimplifyAssertNotNullInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    public SimplifyAssertNotNullInspection() {
        super(KtCallExpression.class);
    }

    @Override
    public boolean isApplicable(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getCalleeExpression();
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (!Intrinsics.areEqual((Object)(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null), (Object)"assert")) {
            return false;
        }
        List arguments2 = element.getValueArguments();
        if (arguments2.size() != 1 && arguments2.size() != 2) {
            return false;
        }
        KtExpression ktExpression2 = ((KtValueArgument)CollectionsKt.first((List)arguments2)).getArgumentExpression();
        KtBinaryExpression ktBinaryExpression = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression condition2 = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)condition2.getOperationToken(), (Object)KtTokens.EXCLEQ)) {
            return false;
        }
        KtExpression ktExpression3 = IfThenUtilsKt.expressionComparedToNull(condition2);
        KtNameReferenceExpression ktNameReferenceExpression2 = ktExpression3 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression3 : null;
        if (ktNameReferenceExpression2 == null) {
            return false;
        }
        KtNameReferenceExpression value = ktNameReferenceExpression2;
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element);
        if (ktVariableDeclaration == null) {
            return false;
        }
        KtVariableDeclaration prevDeclaration = ktVariableDeclaration;
        if (!Intrinsics.areEqual((Object)value.getReferencedNameAsName(), (Object)prevDeclaration.getNameAsName())) {
            return false;
        }
        if (prevDeclaration.getInitializer() == null) {
            return false;
        }
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)element, null, 1, null);
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        if (!ArgumentMappingKt.isReallySuccess((ResolvedCall)resolvedCall2)) {
            return false;
        }
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor function = functionDescriptor;
        FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)function);
        if (!Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)"kotlin.assert")) {
            return false;
        }
        return arguments2.size() == 1 || this.extractMessage(element) != null;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"assert.should.be.replaced.with.operator", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"replace.assert.with.operator", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtCallExpression element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getValueArguments().size() == 1) {
            Object[] objectArray = new Object[]{"!!"};
            string = KotlinBundle.message((String)"replace.with.0.operator", (Object[])objectArray);
        } else {
            string = KotlinBundle.message((String)"replace.with.error", (Object[])new Object[0]);
        }
        return string;
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element, @NotNull Project project, @Nullable Editor editor) {
        KtExpression newInitializer;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element);
        if (ktVariableDeclaration == null) {
            return;
        }
        KtVariableDeclaration declaration = ktVariableDeclaration;
        KtExpression ktExpression = declaration.getInitializer();
        if (ktExpression == null) {
            return;
        }
        KtExpression initializer2 = ktExpression;
        KtExpression message2 = this.extractMessage(element);
        CommentSaver commentSaver = new CommentSaver((PsiElement)element, false, 2, null);
        if (message2 == null) {
            var9_8 = new Object[]{initializer2};
            newInitializer = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0!!", (Object[])var9_8, (boolean)false, (int)4, null);
            initializer2.replace((PsiElement)newInitializer);
        } else {
            var9_8 = new Object[]{initializer2, message2};
            newInitializer = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0 ?: kotlin.error($1)", (Object[])var9_8, (boolean)false, (int)4, null);
            PsiElement result2 = initializer2.replace((PsiElement)newInitializer);
            Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            KtExpression ktExpression2 = ((KtBinaryExpression)result2).getRight();
            Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
            KtDotQualifiedExpression qualifiedExpression = (KtDotQualifiedExpression)ktExpression2;
            KtFile ktFile2 = element.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)qualifiedExpression));
            KtExpression ktExpression3 = qualifiedExpression.getSelectorExpression();
            Intrinsics.checkNotNull((Object)ktExpression3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            KtExpression ktExpression4 = ((KtCallExpression)ktExpression3).getCalleeExpression();
            Intrinsics.checkNotNull((Object)ktExpression4);
            ShortenReferences.process$default(ShortenReferences.DEFAULT, ktFile2, n, PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktExpression4)), null, false, 24, null);
        }
        element.delete();
        CommentSaver.restore$default(commentSaver, (PsiElement)declaration, false, 2, null);
        if (editor != null) {
            int n;
            KtVariableDeclaration ktVariableDeclaration2 = (KtVariableDeclaration)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)declaration));
            if (ktVariableDeclaration2 == null || (ktVariableDeclaration2 = ktVariableDeclaration2.getInitializer()) == null) {
                return;
            }
            newInitializer = ktVariableDeclaration2;
            if (message2 == null) {
                n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)newInitializer));
            } else {
                KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)newInitializer).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
                n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktOperationReferenceExpression));
            }
            int offset = n;
            GenerateUtilsKt.moveCaret$default(editor, offset, null, 2, null);
        }
    }

    private final KtVariableDeclaration findVariableDeclaration(KtCallExpression element) {
        Object v0;
        block2: {
            if (!(element.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)element), (boolean)false, (boolean)false);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof KtExpression)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Object var2_6 = v0;
        return var2_6 instanceof KtVariableDeclaration ? (KtVariableDeclaration)var2_6 : null;
    }

    private final KtExpression extractMessage(KtCallExpression element) {
        List list2;
        List arguments2 = element.getValueArguments();
        if (arguments2.size() != 2) {
            return null;
        }
        KtExpression ktExpression = ((KtValueArgument)arguments2.get(1)).getArgumentExpression();
        KtLambdaExpression ktLambdaExpression = ktExpression instanceof KtLambdaExpression ? (KtLambdaExpression)ktExpression : null;
        return ktLambdaExpression != null && (ktExpression = ktLambdaExpression.getBodyExpression()) != null && (list2 = ktExpression.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)list2) : null;
    }
}

