/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.conventionNameCalls;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.ReplaceGetOrSetInspectionUtils;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.ModifierChecksKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\u0002H\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/conventionNameCalls/ReplaceGetOrSetInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "<init>", "()V", "isExplicitOperator", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isApplicable", "element", "inspectionText", "", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "fixText", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nReplaceGetOrSetInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceGetOrSetInspection.kt\norg/jetbrains/kotlin/idea/inspections/conventionNameCalls/ReplaceGetOrSetInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1807#2,3:82\n1#3:85\n*S KotlinDebug\n*F\n+ 1 ReplaceGetOrSetInspection.kt\norg/jetbrains/kotlin/idea/inspections/conventionNameCalls/ReplaceGetOrSetInspection\n*L\n35#1:82,3\n*E\n"})
public final class ReplaceGetOrSetInspection
extends AbstractApplicabilityBasedInspection<KtDotQualifiedExpression> {
    public ReplaceGetOrSetInspection() {
        super(KtDotQualifiedExpression.class);
    }

    private final boolean isExplicitOperator(FunctionDescriptor $this$isExplicitOperator) {
        boolean bl;
        block5: {
            if ($this$isExplicitOperator.getOverriddenDescriptors().isEmpty()) {
                bl = !($this$isExplicitOperator.getContainingDeclaration() instanceof JavaClassDescriptor) && $this$isExplicitOperator.isOperator();
            } else {
                Collection collection = $this$isExplicitOperator.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOverriddenDescriptors(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FunctionDescriptor it = (FunctionDescriptor)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!this.isExplicitOperator(it)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isApplicable(@NotNull KtDotQualifiedExpression element) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!ReplaceGetOrSetInspectionUtils.INSTANCE.looksLikeGetOrSetOperatorCall(element)) {
            return false;
        }
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)element);
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression callExpression = ktCallExpression;
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)callExpression, BodyResolveMode.PARTIAL_WITH_CFA);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)callExpression), (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        if (!ArgumentMappingKt.isReallySuccess((ResolvedCall)resolvedCall2)) {
            return false;
        }
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor target = functionDescriptor;
        if (!ModifierChecksKt.isValidOperator((FunctionDescriptor)target) || !SetsKt.setOf((Object[])(objectArray = new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET})).contains(target.getName())) {
            return false;
        }
        if (!UtilsKt.isReceiverExpressionWithValue((KtQualifiedExpression)element)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)target.getName(), (Object)OperatorNameConventions.SET) || !BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)element), (BindingContext)bindingContext);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"should.be.replaced.with.indexing", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = UtilsKt.toResolvedCall((KtQualifiedExpression)element, BodyResolveMode.PARTIAL);
        CallableDescriptor callableDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
        FunctionDescriptor functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        return (functionDescriptor != null ? this.isExplicitOperator(functionDescriptor) : false) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"replace.get.or.set.call.with.indexing.operator", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)element);
        if (ktCallExpression == null) {
            return this.getDefaultFixText();
        }
        KtCallExpression callExpression = ktCallExpression;
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)callExpression, null, 1, null);
        if (resolvedCall == null) {
            return this.getDefaultFixText();
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)((Named)resolvedCall2.getResultingDescriptor()).getName().asString(), (String)"asString(...)");
        return KotlinBundle.message((String)"replace.0.call.with.indexing.operator", (Object[])objectArray);
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ExpressionExtKt.calleeTextRangeInThis(element);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element, @NotNull Project project, @Nullable Editor editor) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ReplaceGetOrSetInspectionUtils replaceGetOrSetInspectionUtils = ReplaceGetOrSetInspectionUtils.INSTANCE;
        KtDotQualifiedExpression ktDotQualifiedExpression = element;
        boolean bl = Intrinsics.areEqual((Object)UtilsKt.getCalleeName((KtQualifiedExpression)element), (Object)OperatorNameConventions.SET.getIdentifier());
        Editor editor2 = editor;
        if (editor2 != null) {
            void e;
            Editor editor3 = editor2;
            boolean bl2 = bl;
            KtDotQualifiedExpression ktDotQualifiedExpression2 = ktDotQualifiedExpression;
            ReplaceGetOrSetInspectionUtils replaceGetOrSetInspectionUtils2 = replaceGetOrSetInspectionUtils;
            boolean bl3 = false;
            Function1 function12 = arg_0 -> ReplaceGetOrSetInspection.applyTo$lambda$0$0((Editor)e, arg_0);
            replaceGetOrSetInspectionUtils = replaceGetOrSetInspectionUtils2;
            ktDotQualifiedExpression = ktDotQualifiedExpression2;
            bl = bl2;
            function1 = function12;
        } else {
            function1 = null;
        }
        replaceGetOrSetInspectionUtils.replaceGetOrSetWithPropertyAccessor(ktDotQualifiedExpression, bl, function1);
    }

    private static final Unit applyTo$lambda$0$0(Editor $e, int it) {
        $e.getCaretModel().moveToOffset(it);
        return Unit.INSTANCE;
    }
}

