/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import java.util.Objects;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.inspections.dfa.KtClassDef;
import org.jetbrains.kotlin.idea.inspections.dfa.KtClassDef$superTypes$;
import org.jetbrains.kotlin.idea.inspections.dfa.KtClassDefKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0001H\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u001eH\u0096\u0082\u0004J\n\u0010\u001f\u001a\u00020\u0014H\u0096\u0080\u0004J\n\u0010 \u001a\u00020\u0016H\u0096\u0080\u0004J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtClassDef;", "Lcom/intellij/codeInspection/dataFlow/TypeConstraints$ClassDef;", "cls", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "getCls", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isInheritor", "", "superType", "isConvertible", "other", "isInterface", "isEnum", "isFinal", "isAbstract", "getEnumConstant", "Lcom/intellij/psi/PsiEnumConstant;", "ordinal", "", "getQualifiedName", "", "superTypes", "Ljava/util/stream/Stream;", "toPsiType", "Lcom/intellij/psi/PsiType;", "project", "Lcom/intellij/openapi/project/Project;", "equals", "", "hashCode", "toString", "correctFqName", "fqNameUnsafe", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKtClassDef.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtClassDef.kt\norg/jetbrains/kotlin/idea/inspections/dfa/KtClassDef\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n479#2:121\n1#3:122\n*S KotlinDebug\n*F\n+ 1 KtClassDef.kt\norg/jetbrains/kotlin/idea/inspections/dfa/KtClassDef\n*L\n67#1:121\n*E\n"})
public final class KtClassDef
implements TypeConstraints.ClassDef {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassDescriptor cls;

    public KtClassDef(@NotNull ClassDescriptor cls) {
        Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
        this.cls = cls;
    }

    @NotNull
    public final ClassDescriptor getCls() {
        return this.cls;
    }

    public boolean isInheritor(@NotNull TypeConstraints.ClassDef superType) {
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        return superType instanceof KtClassDef && DescriptorUtilsKt.isSubclassOf((ClassDescriptor)this.cls, (ClassDescriptor)((KtClassDef)superType).cls);
    }

    public boolean isConvertible(@NotNull TypeConstraints.ClassDef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof KtClassDef)) {
            return false;
        }
        if (this.isInterface() && ((KtClassDef)other).isInterface()) {
            return true;
        }
        if (this.isInterface() && !((KtClassDef)other).isFinal()) {
            return true;
        }
        if (((KtClassDef)other).isInterface() && !this.isFinal()) {
            return true;
        }
        return this.isInheritor(other) || ((KtClassDef)other).isInheritor(this);
    }

    public boolean isInterface() {
        return this.cls.getKind() == ClassKind.INTERFACE || this.cls.getKind() == ClassKind.ANNOTATION_CLASS;
    }

    public boolean isEnum() {
        return this.cls.getKind() == ClassKind.ENUM_CLASS;
    }

    public boolean isFinal() {
        return this.cls.getModality() == Modality.FINAL && this.cls.getKind() != ClassKind.ANNOTATION_CLASS;
    }

    public boolean isAbstract() {
        return this.cls.getModality() == Modality.ABSTRACT;
    }

    @Nullable
    public PsiEnumConstant getEnumConstant(int ordinal) {
        SourceElement sourceElement = ModuleVisibilityUtilsKt.getToSourceElement((DeclarationDescriptor)((DeclarationDescriptor)this.cls));
        PsiSourceElement psiSourceElement = sourceElement instanceof PsiSourceElement ? (PsiSourceElement)sourceElement : null;
        PsiClass psiClass = KtClassDefKt.access$asPsiClass((PsiElement)(psiSourceElement != null ? psiSourceElement.getPsi() : null));
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        int cur = 0;
        PsiField[] psiFieldArray = psiClass2.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
        for (PsiField field2 : psiFieldArray) {
            if (!(field2 instanceof PsiEnumConstant)) continue;
            if (cur == ordinal) {
                return (PsiEnumConstant)field2;
            }
            ++cur;
        }
        return null;
    }

    @NotNull
    public String getQualifiedName() {
        return this.correctFqName(DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)this.cls)));
    }

    @NotNull
    public Stream<TypeConstraints.ClassDef> superTypes() {
        Sequence $this$filterIsInstance$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)this.cls));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)superTypes$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return StreamsKt.asStream((Sequence)SequencesKt.map((Sequence)sequence, (Function1)superTypes.1.INSTANCE));
    }

    @Nullable
    public PsiType toPsiType(@NotNull Project project) {
        PsiClassType psiClassType;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiClass psiClass = KtClassDefKt.access$asPsiClass(DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, (DeclarationDescriptor)this.cls));
        if (psiClass != null) {
            PsiClass it = psiClass;
            boolean bl = false;
            psiClassType = JavaPsiFacade.getElementFactory((Project)project).createType(it);
        } else {
            psiClassType = null;
        }
        return (PsiType)psiClassType;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof KtClassDef && Intrinsics.areEqual((Object)((KtClassDef)other).cls.getTypeConstructor(), (Object)this.cls.getTypeConstructor());
    }

    public int hashCode() {
        return Objects.hashCode(this.cls.getName().hashCode());
    }

    @NotNull
    public String toString() {
        return this.getQualifiedName();
    }

    private final String correctFqName(FqNameUnsafe fqNameUnsafe) {
        Object object = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (object == null || (object = object.asFqNameString()) == null) {
            object = fqNameUnsafe.asString();
        }
        return object;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KtClassDef$Companion;", "", "<init>", "()V", "getClassConstraint", "Lcom/intellij/codeInspection/dataFlow/TypeConstraint$Exact;", "context", "Lorg/jetbrains/kotlin/psi/KtElement;", "name", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "fromJvmClassName", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KtClassDef;", "jvmClassName", "", "typeConstraintFactory", "Lcom/intellij/codeInspection/dataFlow/TypeConstraints$TypeConstraintFactory;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TypeConstraint.Exact getClassConstraint(@NotNull KtElement context2, @NotNull FqNameUnsafe name2) {
            TypeConstraint.Exact exact;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            ClassDescriptor descriptor2 = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)ResolutionUtils.findModuleDescriptor(context2), (FqName)name2.toSafe(), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
            if (descriptor2 == null) {
                TypeConstraint.Exact exact2 = TypeConstraints.unresolved((String)name2.asString());
                exact = exact2;
                Intrinsics.checkNotNullExpressionValue((Object)exact2, (String)"unresolved(...)");
            } else if (descriptor2.getKind() == ClassKind.OBJECT) {
                TypeConstraint.Exact exact3 = TypeConstraints.singleton((TypeConstraints.ClassDef)new KtClassDef(descriptor2));
                exact = exact3;
                Intrinsics.checkNotNullExpressionValue((Object)exact3, (String)"singleton(...)");
            } else {
                TypeConstraint.Exact exact4 = TypeConstraints.exactClass((TypeConstraints.ClassDef)new KtClassDef(descriptor2));
                exact = exact4;
                Intrinsics.checkNotNullExpressionValue((Object)exact4, (String)"exactClass(...)");
            }
            return exact;
        }

        @Nullable
        public final KtClassDef fromJvmClassName(@NotNull KtElement context2, @NotNull String jvmClassName) {
            ClassDescriptor descriptor2;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)jvmClassName, (String)"jvmClassName");
            CharSequence charSequence = jvmClassName;
            Regex regex = new Regex("[$/]");
            int n = 0;
            FqName fqName2 = FqName.Companion.fromSegments(regex.split(charSequence, n));
            if (StringsKt.startsWith$default((String)jvmClassName, (String)"java/", (boolean)false, (int)2, null)) {
                ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
                if (classId == null || (classId = classId.asSingleFqName()) == null) {
                    classId = fqName2;
                }
                fqName2 = classId;
            }
            return (descriptor2 = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)ResolutionUtils.findModuleDescriptor(context2), (FqName)fqName2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE))) == null ? null : new KtClassDef(descriptor2);
        }

        @NotNull
        public final TypeConstraints.TypeConstraintFactory typeConstraintFactory(@NotNull KtElement context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return arg_0 -> Companion.typeConstraintFactory$lambda$0(context2, arg_0);
        }

        private static final TypeConstraint.Exact typeConstraintFactory$lambda$0(KtElement $context, String fqn) {
            Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
            String[] stringArray = new String[]{"."};
            FqName fqName2 = FqName.Companion.fromSegments(StringsKt.split$default((CharSequence)fqn, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (StringsKt.startsWith$default((String)fqn, (String)"java.", (boolean)false, (int)2, null)) {
                ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
                if (classId == null || (classId = classId.asSingleFqName()) == null) {
                    classId = fqName2;
                }
                fqName2 = classId;
            }
            return Companion.getClassConstraint($context, fqName2.toUnsafe());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

