/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.LocalQuickFix;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteImportsUsageReporter;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteKotlinBrowserUsageFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteKotlinJsPackagesUsagesInWholeProjectFix;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0005H\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/KotlinBrowserImportUsageReporter;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter;", "<init>", "()V", "textMarker", "", "getTextMarker", "()Ljava/lang/String;", "packageBindings", "", "getPackageBindings", "()Ljava/util/Map;", "wholeProjectFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "getWholeProjectFix", "()Lcom/intellij/codeInspection/LocalQuickFix;", "problemMessage", "wrapFix", "fix", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeFix;", "kotlin.idea"})
final class KotlinBrowserImportUsageReporter
extends ObsoleteImportsUsageReporter {
    @NotNull
    public static final KotlinBrowserImportUsageReporter INSTANCE = new KotlinBrowserImportUsageReporter();
    @NotNull
    private static final String textMarker = "browser";
    @NotNull
    private static final Map<String, String> packageBindings = MapsKt.mapOf((Pair)TuplesKt.to((Object)"kotlin.browser", (Object)"kotlinx.browser"));
    @NotNull
    private static final LocalQuickFix wholeProjectFix = ObsoleteKotlinJsPackagesUsagesInWholeProjectFix.INSTANCE;

    private KotlinBrowserImportUsageReporter() {
    }

    @Override
    @NotNull
    protected String getTextMarker() {
        return textMarker;
    }

    @Override
    @NotNull
    protected Map<String, String> getPackageBindings() {
        return packageBindings;
    }

    @Override
    @NotNull
    protected LocalQuickFix getWholeProjectFix() {
        return wholeProjectFix;
    }

    @Override
    @NotNull
    protected String problemMessage() {
        Object[] objectArray = new Object[]{"kotlin.browser"};
        return KotlinBundle.message((String)"package.usages.are.obsolete.since.1.4", (Object[])objectArray);
    }

    @Override
    @NotNull
    protected LocalQuickFix wrapFix(@NotNull ObsoleteCodeFix fix3) {
        Intrinsics.checkNotNullParameter((Object)fix3, (String)"fix");
        return new ObsoleteKotlinBrowserUsageFix(fix3);
    }
}

