/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.idea.inspections.migration.AbstractDiagnosticBasedMigrationInspection;
import org.jetbrains.kotlin.idea.migration.MigrationInfo;
import org.jetbrains.kotlin.idea.migration.MigrationInfoKt;
import org.jetbrains.kotlin.idea.quickfix.AddWhenElseBranchFix;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/NonExhaustiveWhenStatementMigrationInspection;", "Lorg/jetbrains/kotlin/idea/inspections/migration/AbstractDiagnosticBasedMigrationInspection;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrationFix;", "<init>", "()V", "isApplicable", "", "migrationInfo", "Lorg/jetbrains/kotlin/idea/migration/MigrationInfo;", "getDiagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "customIntentionFactory", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "customHighlightRangeIn", "Lcom/intellij/openapi/util/TextRange;", "element", "kotlin.idea"})
public final class NonExhaustiveWhenStatementMigrationInspection
extends AbstractDiagnosticBasedMigrationInspection<KtWhenExpression>
implements MigrationFix {
    public NonExhaustiveWhenStatementMigrationInspection() {
        super(KtWhenExpression.class);
    }

    @Override
    public boolean isApplicable(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        return MigrationInfoKt.isLanguageVersionUpdate(migrationInfo, LanguageVersion.KOTLIN_1_5, LanguageVersion.KOTLIN_1_6);
    }

    @NotNull
    public DiagnosticFactory2<KtWhenExpression, String, List<WhenMissingCase>> getDiagnosticFactory(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        DiagnosticFactory2 diagnosticFactory2 = Errors.NON_EXHAUSTIVE_WHEN_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory2, (String)"NON_EXHAUSTIVE_WHEN_STATEMENT");
        return diagnosticFactory2;
    }

    @Override
    @NotNull
    public Function1<Diagnostic, IntentionAction> customIntentionFactory() {
        return NonExhaustiveWhenStatementMigrationInspection::customIntentionFactory$lambda$0;
    }

    @Override
    @NotNull
    public TextRange customHighlightRangeIn(@NotNull KtWhenExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextRange textRange = element.getWhenKeyword().getTextRangeInParent();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRangeInParent(...)");
        return textRange;
    }

    private static final IntentionAction customIntentionFactory$lambda$0(Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return (IntentionAction)CollectionsKt.singleOrNull(AddWhenElseBranchFix.Companion.createQuickFix(diagnostic.getPsiElement()));
    }
}

