/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggestionProvider;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilsKt;
import org.jetbrains.kotlin.idea.intentions.AbstractProcessableUsageInfo;
import org.jetbrains.kotlin.idea.intentions.ConvertFunctionTypeParameterToReceiverIntentionKt;
import org.jetbrains.kotlin.idea.intentions.ConvertFunctionTypeReceiverToParameterIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoringKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtFunctionTypeReceiver;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u0010\u0011\u0012\u0013\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "<init>", "()V", "getConversionData", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "startInWriteAction", "", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "ConversionData", "CallableDefinitionInfo", "ParameterCallInfo", "LambdaInfo", "Converter", "Factory", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertFunctionTypeReceiverToParameterIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertFunctionTypeReceiverToParameterIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n137#2:340\n21#3:341\n1#4:342\n*S KotlinDebug\n*F\n+ 1 ConvertFunctionTypeReceiverToParameterIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention\n*L\n304#1:340\n320#1:341\n*E\n"})
public final class ConvertFunctionTypeReceiverToParameterIntention
extends SelfTargetingRangeIntention<KtTypeReference> {
    public ConvertFunctionTypeReceiverToParameterIntention() {
        super(KtTypeReference.class, KotlinBundle.messagePointer((String)"convert.function.type.receiver.to.parameter", (Object[])new Object[0]), null, 4, null);
    }

    private final ConversionData getConversionData(KtTypeReference $this$getConversionData) {
        Pair pair;
        KtCallableDeclaration callableDeclaration;
        PsiElement psiElement;
        KotlinType lambdaReceiverType;
        KotlinType kotlinType;
        block12: {
            block11: {
                PsiElement psiElement2 = $this$getConversionData.getParent();
                KtFunctionTypeReceiver ktFunctionTypeReceiver = psiElement2 instanceof KtFunctionTypeReceiver ? (KtFunctionTypeReceiver)psiElement2 : null;
                if (ktFunctionTypeReceiver == null) {
                    return null;
                }
                KtFunctionTypeReceiver functionTypeReceiver = ktFunctionTypeReceiver;
                PsiElement psiElement3 = functionTypeReceiver.getParent();
                KtFunctionType ktFunctionType = psiElement3 instanceof KtFunctionType ? (KtFunctionType)psiElement3 : null;
                if (ktFunctionType == null) {
                    return null;
                }
                KtFunctionType functionType = ktFunctionType;
                psiElement3 = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeElement)((KtTypeElement)functionType), (BindingContext)ResolutionUtils.analyze((KtElement)functionType, BodyResolveMode.PARTIAL));
                if (psiElement3 == null || (kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType((KotlinType)psiElement3)) == null) {
                    return null;
                }
                lambdaReceiverType = kotlinType;
                psiElement = functionType.getParent();
                if (psiElement == null) break block11;
                PsiElement $this$safeAs$iv = psiElement;
                boolean $i$f$safeAs = false;
                PsiElement psiElement4 = $this$safeAs$iv;
                if (!(psiElement4 instanceof KtTypeReference)) {
                    psiElement4 = null;
                }
                if ((psiElement = (KtTypeReference)psiElement4) == null || (psiElement = psiElement.getParent()) == null) break block11;
                PsiElement $this$safeAs$iv2 = psiElement;
                boolean $i$f$safeAs2 = false;
                PsiElement psiElement5 = $this$safeAs$iv2;
                if (!(psiElement5 instanceof KtCallableDeclaration)) {
                    psiElement5 = null;
                }
                if ((psiElement = (KtCallableDeclaration)psiElement5) != null) break block12;
            }
            return null;
        }
        PsiElement typeReferenceHolder = psiElement;
        if (typeReferenceHolder instanceof KtParameter) {
            KtDeclarationWithBody ktDeclarationWithBody = ((KtParameter)typeReferenceHolder).getOwnerFunction();
            KtCallableDeclaration ktCallableDeclaration = ktDeclarationWithBody instanceof KtCallableDeclaration ? (KtCallableDeclaration)ktDeclarationWithBody : null;
            if (ktCallableDeclaration == null) {
                return null;
            }
            callableDeclaration = ktCallableDeclaration;
            pair = TuplesKt.to((Object)callableDeclaration, (Object)callableDeclaration.getValueParameters().indexOf(typeReferenceHolder));
        } else {
            pair = TuplesKt.to((Object)typeReferenceHolder, null);
        }
        kotlinType = pair;
        callableDeclaration = (KtCallableDeclaration)kotlinType.component1();
        Integer parameterIndex = (Integer)kotlinType.component2();
        return new ConversionData(parameterIndex, lambdaReceiverType, callableDeclaration);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtTypeReference element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ConversionData conversionData = this.getConversionData(element);
        if (conversionData == null) {
            return null;
        }
        ConversionData data = conversionData;
        KtFunctionType ktFunctionType = ConversionData.functionType$default(data, null, 1, null);
        if (ktFunctionType == null) {
            return null;
        }
        KtFunctionType elementBefore = ktFunctionType;
        PsiElement $this$copied$iv = (PsiElement)elementBefore;
        boolean $i$f$copied = false;
        PsiElement psiElement = $this$copied$iv.copy();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        Object[] objectArray = (Object[])((KtFunctionType)psiElement);
        KtFunctionType $this$applicabilityRange_u24lambda_u240 = (KtFunctionType)objectArray;
        boolean bl = false;
        KtParameterList ktParameterList = $this$applicabilityRange_u24lambda_u240.getParameterList();
        if (ktParameterList != null) {
            Object object;
            Project project = $this$applicabilityRange_u24lambda_u240.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ktParameterList.addParameterBefore(new KtPsiFactory(project, false, 2, null).createFunctionTypeParameter(element), (object = $this$applicabilityRange_u24lambda_u240.getParameterList()) != null && (object = object.getParameters()) != null ? (KtParameter)CollectionsKt.firstOrNull((List)object) : null);
        }
        TypeRefHelpersKt.setReceiverTypeReference((KtFunctionType)$this$applicabilityRange_u24lambda_u240, null);
        KtFunctionType elementAfter = (KtFunctionType)objectArray;
        objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)elementBefore.getText(), (String)"getText(...)");
        Intrinsics.checkNotNullExpressionValue((Object)elementAfter.getText(), (String)"getText(...)");
        this.setTextGetter(KotlinBundle.messagePointer((String)"convert.0.to.1", (Object[])objectArray));
        return element.getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtTypeReference element, @Nullable Editor editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            ConversionData conversionData = this.getConversionData(element);
            if (conversionData == null) break block0;
            ConversionData it = conversionData;
            boolean bl = false;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            new Converter(it, editor, project).run();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$CallableDefinitionInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;)V", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.idea"})
    public static final class CallableDefinitionInfo
    extends AbstractProcessableUsageInfo<KtCallableDeclaration, ConversionData> {
        public CallableDefinitionInfo(@NotNull KtCallableDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(elementsToShorten, (String)"elementsToShorten");
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)this.getElement();
            if (ktCallableDeclaration == null) {
                return;
            }
            KtCallableDeclaration declaration = ktCallableDeclaration;
            KtFunctionType ktFunctionType = data.functionType(declaration);
            if (ktFunctionType == null) {
                return;
            }
            KtFunctionType functionType = ktFunctionType;
            KtParameterList ktParameterList = functionType.getParameterList();
            if (ktParameterList == null) {
                return;
            }
            KtParameterList functionTypeParameterList = ktParameterList;
            KtTypeReference ktTypeReference = functionType.getReceiverTypeReference();
            if (ktTypeReference == null) {
                return;
            }
            KtTypeReference functionTypeReceiver = ktTypeReference;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtParameter parameterToAdd = new KtPsiFactory(project, false, 2, null).createFunctionTypeParameter(functionTypeReceiver);
            List list2 = functionTypeParameterList.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
            functionTypeParameterList.addParameterBefore(parameterToAdd, (KtParameter)CollectionsKt.firstOrNull((List)list2));
            TypeRefHelpersKt.setReceiverTypeReference((KtFunctionType)functionType, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0007R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "", "functionParameterIndex", "", "lambdaReceiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "callableDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "<init>", "(Ljava/lang/Integer;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;)V", "getFunctionParameterIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getLambdaReceiverType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "declarationPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getCallableDeclaration", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getFunctionDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "functionDescriptor$delegate", "Lkotlin/Lazy;", "functionType", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "declaration", "kotlin.idea"})
    public static final class ConversionData {
        @Nullable
        private final Integer functionParameterIndex;
        @NotNull
        private final KotlinType lambdaReceiverType;
        @NotNull
        private final SmartPsiElementPointer<KtCallableDeclaration> declarationPointer;
        @NotNull
        private final Lazy functionDescriptor$delegate;

        public ConversionData(@Nullable Integer functionParameterIndex, @NotNull KotlinType lambdaReceiverType, @NotNull KtCallableDeclaration callableDeclaration) {
            Intrinsics.checkNotNullParameter((Object)lambdaReceiverType, (String)"lambdaReceiverType");
            Intrinsics.checkNotNullParameter((Object)callableDeclaration, (String)"callableDeclaration");
            this.functionParameterIndex = functionParameterIndex;
            this.lambdaReceiverType = lambdaReceiverType;
            this.declarationPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)callableDeclaration));
            this.functionDescriptor$delegate = LazyKt.lazy(() -> ConversionData.functionDescriptor_delegate$lambda$0(callableDeclaration));
        }

        @Nullable
        public final Integer getFunctionParameterIndex() {
            return this.functionParameterIndex;
        }

        @NotNull
        public final KotlinType getLambdaReceiverType() {
            return this.lambdaReceiverType;
        }

        private final KtCallableDeclaration getCallableDeclaration() {
            return (KtCallableDeclaration)this.declarationPointer.getElement();
        }

        @NotNull
        public final CallableDescriptor getFunctionDescriptor() {
            Lazy lazy = this.functionDescriptor$delegate;
            return (CallableDescriptor)lazy.getValue();
        }

        @Nullable
        public final KtFunctionType functionType(@Nullable KtCallableDeclaration declaration) {
            Object object;
            KtCallableDeclaration functionTypeOwner = this.functionParameterIndex != null ? (KtCallableDeclaration)((object = declaration) != null && (object = object.getValueParameters()) != null ? (KtParameter)CollectionsKt.getOrNull((List)object, (int)this.functionParameterIndex) : null) : declaration;
            KtCallableDeclaration ktCallableDeclaration = functionTypeOwner;
            KtTypeElement ktTypeElement = ktCallableDeclaration != null && (ktCallableDeclaration = ktCallableDeclaration.getTypeReference()) != null ? ktCallableDeclaration.getTypeElement() : null;
            return ktTypeElement instanceof KtFunctionType ? (KtFunctionType)ktTypeElement : null;
        }

        public static /* synthetic */ KtFunctionType functionType$default(ConversionData conversionData, KtCallableDeclaration ktCallableDeclaration, int n, Object object) {
            if ((n & 1) != 0) {
                ktCallableDeclaration = conversionData.getCallableDeclaration();
            }
            return conversionData.functionType(ktCallableDeclaration);
        }

        private static final CallableDescriptor functionDescriptor_delegate$lambda$0(KtCallableDeclaration $callableDeclaration) {
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)$callableDeclaration, null, 1, null);
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
            return (CallableDescriptor)declarationDescriptor;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0014J@\u0010\u000f\u001a\u00020\f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112*\u0010\u0012\u001a&\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u00140\u0013j\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u0014`\u0015H\u0002J<\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182*\u0010\u0012\u001a&\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u00140\u0013j\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u0014`\u0015H\u0002J<\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182*\u0010\u0012\u001a&\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u00140\u0013j\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u0014`\u0015H\u0002JF\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2*\u0010\u0012\u001a&\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u00140\u0013j\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u0014`\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f\u00b2\u0006\n\u0010 \u001a\u00020!X\u008a\u0084\u0002\u00b2\u0006\f\u0010\"\u001a\u0004\u0018\u00010#X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$Converter;", "Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "data", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention;Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "performRefactoring", "", "descriptorsForChange", "", "processExternalUsage", "ref", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "usages", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lkotlin/collections/ArrayList;", "processInternalUsages", "callable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "processLambdasInReturnExpressions", "processBody", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;"})
    @SourceDebugExtension(value={"SMAP\nConvertFunctionTypeReceiverToParameterIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertFunctionTypeReceiverToParameterIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$Converter\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,339:1\n300#2,2:340\n232#2:342\n300#2,2:344\n232#2:346\n376#2,9:347\n395#2:356\n377#2:357\n1#3:343\n1080#4:358\n1915#4,2:359\n137#5:361\n*S KotlinDebug\n*F\n+ 1 ConvertFunctionTypeReceiverToParameterIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$Converter\n*L\n222#1:340,2\n222#1:342\n251#1:344,2\n251#1:346\n283#1:347,9\n283#1:356\n283#1:357\n211#1:358\n211#1:359,2\n286#1:361\n*E\n"})
    private final class Converter
    extends CallableRefactoring<CallableDescriptor> {
        @NotNull
        private final ConversionData data;

        public Converter(@Nullable ConversionData data, @NotNull Editor editor, Project project) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, editor, data.getFunctionDescriptor(), ConvertFunctionTypeReceiverToParameterIntention.this.getText());
            this.data = data;
        }

        @Override
        protected void performRefactoring(@NotNull Collection<? extends CallableDescriptor> descriptorsForChange) {
            Intrinsics.checkNotNullParameter(descriptorsForChange, (String)"descriptorsForChange");
            Collection<PsiElement> callables2 = CallableRefactoringKt.getAffectedCallables(this.getProject(), descriptorsForChange);
            MultiMap conflicts = new MultiMap();
            ArrayList usages2 = new ArrayList();
            ProgressUtilsKt.runSynchronouslyWithProgress(this.getProject(), KotlinBundle.message((String)"looking.for.usages.and.conflicts", (Object[])new Object[0]), true, () -> Converter.performRefactoring$lambda$0(callables2, this, conflicts, usages2));
            KotlinCommonRefactoringUtilKt.checkConflictsInteractively$default(this.getProject(), conflicts, null, () -> Converter.performRefactoring$lambda$1(this, ConvertFunctionTypeReceiverToParameterIntention.this, usages2), 2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void processExternalUsage(KtSimpleReference<?> ref, ArrayList<AbstractProcessableUsageInfo<?, ConversionData>> usages2) {
            KtExpression ktExpression;
            block7: {
                block6: {
                    KtExpression ktExpression2;
                    void $this$getParentOfType$iv$iv;
                    void $this$getParentOfTypeAndBranch_u24default$iv;
                    Integer n = this.data.getFunctionParameterIndex();
                    if (n == null) {
                        return;
                    }
                    int parameterIndex = n;
                    PsiElement psiElement = ref.getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
                    PsiElement psiElement2 = psiElement;
                    Function1 branch$iv = Converter::processExternalUsage$lambda$0;
                    boolean strict$iv = false;
                    boolean $i$f$getParentOfTypeAndBranch = false;
                    void var10_10 = $this$getParentOfTypeAndBranch_u24default$iv;
                    boolean strict$iv$iv = strict$iv;
                    boolean $i$f$getParentOfType = false;
                    PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtCallElement.class, (boolean)strict$iv$iv);
                    KtCallElement ktCallElement = (KtCallElement)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement3, (PsiElement)$this$getParentOfTypeAndBranch_u24default$iv, (Function1)branch$iv) : null);
                    if (ktCallElement == null) {
                        return;
                    }
                    KtCallElement callElement = ktCallElement;
                    BindingContext context2 = ResolutionUtils.analyze((KtElement)callElement, BodyResolveMode.PARTIAL);
                    ValueArgument valueArgument = (ValueArgument)CollectionsKt.singleOrNull((List)ResolvedCallUtilKt.getArgumentByParameterIndex((KtCallElement)callElement, (int)parameterIndex, (BindingContext)context2));
                    if (valueArgument == null || (ktExpression2 = valueArgument.getArgumentExpression()) == null) break block6;
                    KtExpression it = ktExpression2;
                    boolean bl = false;
                    ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)it);
                    if (ktExpression != null) break block7;
                }
                return;
            }
            KtExpression expressionToProcess = ktExpression;
            if (expressionToProcess instanceof KtLambdaExpression) {
                ((Collection)usages2).add(new LambdaInfo((KtLambdaExpression)expressionToProcess));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processInternalUsages(KtCallableDeclaration callable, ArrayList<AbstractProcessableUsageInfo<?, ConversionData>> usages2) {
            KtElement body2;
            Integer n = this.data.getFunctionParameterIndex();
            if (n == null) {
                this.processLambdasInReturnExpressions(callable, usages2);
                return;
            }
            int parameterIndex = n;
            KtCallableDeclaration ktCallableDeclaration = callable;
            if (ktCallableDeclaration instanceof KtConstructor) {
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)callable));
                v2 = (KtElement)(ktClassOrObject != null ? ktClassOrObject.getBody() : null);
            } else {
                v2 = body2 = ktCallableDeclaration instanceof KtDeclarationWithBody ? (KtElement)((KtDeclarationWithBody)callable).getBodyExpression() : null;
            }
            if (body2 != null) {
                List list2 = callable.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
                KtParameter ktParameter = (KtParameter)CollectionsKt.getOrNull((List)list2, (int)parameterIndex);
                if (ktParameter == null) {
                    return;
                }
                KtParameter functionParameter = ktParameter;
                for (PsiReference ref : ReferencesSearch.search((PsiElement)((PsiElement)functionParameter), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)body2))).asIterable()) {
                    KtCallExpression callExpression;
                    void $this$getParentOfType$iv$iv;
                    void $this$getParentOfTypeAndBranch_u24default$iv;
                    KtSimpleNameExpression element;
                    PsiElement psiElement = ref.getElement();
                    if ((psiElement instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)psiElement : null) == null) continue;
                    element = element;
                    PsiElement psiElement2 = (PsiElement)element;
                    Function1 branch$iv = Converter::processInternalUsages$lambda$0;
                    boolean strict$iv = false;
                    boolean $i$f$getParentOfTypeAndBranch = false;
                    void var15_15 = $this$getParentOfTypeAndBranch_u24default$iv;
                    boolean strict$iv$iv = strict$iv;
                    boolean $i$f$getParentOfType = false;
                    PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtCallExpression.class, (boolean)strict$iv$iv);
                    if ((KtCallExpression)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement3, (PsiElement)$this$getParentOfTypeAndBranch_u24default$iv, (Function1)branch$iv) : null) == null) continue;
                    ((Collection)usages2).add(new ParameterCallInfo(callExpression));
                }
            }
        }

        private final void processLambdasInReturnExpressions(KtCallableDeclaration callable, ArrayList<AbstractProcessableUsageInfo<?, ConversionData>> usages2) {
            block3: {
                KtCallableDeclaration ktCallableDeclaration;
                block2: {
                    boolean bl;
                    boolean bl2 = bl = this.data.getFunctionParameterIndex() == null;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    ktCallableDeclaration = callable;
                    if (!(ktCallableDeclaration instanceof KtNamedFunction)) break block2;
                    this.processBody((KtDeclaration)callable, usages2, ((KtNamedFunction)callable).getBodyExpression());
                    break block3;
                }
                if (!(ktCallableDeclaration instanceof KtProperty)) break block3;
                this.processBody((KtDeclaration)callable, usages2, ((KtProperty)callable).getInitializer());
                KtPropertyAccessor ktPropertyAccessor = ((KtProperty)callable).getGetter();
                if (ktPropertyAccessor != null) {
                    KtPropertyAccessor it = ktPropertyAccessor;
                    boolean bl = false;
                    this.processBody((KtDeclaration)it, usages2, it.getBodyExpression());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processBody(KtDeclaration declaration, ArrayList<AbstractProcessableUsageInfo<?, ConversionData>> usages2, KtExpression bodyExpression) {
            block1: {
                void $this$forEachDescendantOfType$iv$iv;
                void $this$forEachDescendantOfType$iv;
                KtElement body2;
                block0: {
                    KtExpression ktExpression = bodyExpression;
                    Object object = body2 = ktExpression != null ? KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression)) : null;
                    if (!(body2 instanceof KtLambdaExpression)) break block0;
                    ((Collection)usages2).add(new LambdaInfo((KtLambdaExpression)body2));
                    break block1;
                }
                if (!(body2 instanceof KtBlockExpression)) break block1;
                Lazy context$delegate = LazyKt.lazy(() -> Converter.processBody$lambda$0(declaration));
                Lazy target$delegate = LazyKt.lazy(() -> Converter.processBody$lambda$2(declaration, context$delegate));
                PsiElement psiElement = (PsiElement)bodyExpression;
                Function1 action$iv = arg_0 -> Converter.processBody$lambda$4(context$delegate, target$delegate, usages2, arg_0);
                boolean $i$f$forEachDescendantOfType = false;
                void var10_10 = $this$forEachDescendantOfType$iv;
                Function1 action$iv$iv = action$iv;
                boolean $i$f$forEachDescendantOfType2 = false;
                PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
                $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                    }

                    public void visitElement(PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        PsiElement it = element;
                        boolean bl = false;
                        super.visitElement(element);
                        if (element instanceof KtReturnExpression) {
                            this.$action.invoke((Object)element);
                        }
                    }
                });
            }
        }

        private static final Unit performRefactoring$lambda$0$0(Collection $callables, Converter this$0, MultiMap $conflicts, ArrayList $usages) {
            double progressStep = 1.0 / (double)$callables.size();
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            progressIndicator.setIndeterminate(false);
            Iterator iterator2 = ((Iterable)$callables).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i2 = n++;
                PsiElement callable = (PsiElement)iterator2.next();
                progressIndicator.setFraction((double)(i2 + 1) * progressStep);
                if (!(callable instanceof KtCallableDeclaration)) continue;
                if (!this$0.checkModifiable(callable)) {
                    String string = RefactoringUIUtil.getDescription((PsiElement)callable, (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
                    String renderedCallable = StringsKt.capitalize((String)string);
                    Object[] objectArray = new Object[]{renderedCallable};
                    $conflicts.putValue((Object)callable, (Object)KotlinBundle.message((String)"can.t.modify.0", (Object[])objectArray));
                }
                for (PsiReference ref : ConvertFunctionTypeParameterToReceiverIntentionKt.searchReferencesOrMethodReferences(callable)) {
                    if (!(ref instanceof KtSimpleReference)) continue;
                    this$0.processExternalUsage((KtSimpleReference)ref, $usages);
                }
                ((Collection)$usages).add(new CallableDefinitionInfo((KtCallableDeclaration)callable));
                this$0.processInternalUsages((KtCallableDeclaration)callable, $usages);
            }
            return Unit.INSTANCE;
        }

        private static final Unit performRefactoring$lambda$1$0(ArrayList $usages, Converter this$0) {
            ArrayList elementsToShorten = new ArrayList();
            Iterable $this$sortedByDescending$iv = $usages;
            boolean $i$f$sortedByDescending = false;
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AbstractProcessableUsageInfo it = (AbstractProcessableUsageInfo)((Object)b);
                    boolean bl = false;
                    T t = it.getElement();
                    it = (AbstractProcessableUsageInfo)((Object)a);
                    Comparable comparable = t != null ? Integer.valueOf(t.getTextOffset()) : null;
                    bl = false;
                    T t2 = it.getElement();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(t2 != null ? Integer.valueOf(t2.getTextOffset()) : null));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbstractProcessableUsageInfo it = (AbstractProcessableUsageInfo)((Object)element$iv);
                boolean bl = false;
                it.process(this$0.data, elementsToShorten);
            }
            ShortenReferences.process$default(ShortenReferences.DEFAULT, elementsToShorten, null, false, 6, null);
            return Unit.INSTANCE;
        }

        private static final Unit performRefactoring$lambda$0(Collection $callables, Converter this$0, MultiMap $conflicts, ArrayList $usages) {
            ActionsKt.runReadAction(() -> Converter.performRefactoring$lambda$0$0($callables, this$0, $conflicts, $usages));
            return Unit.INSTANCE;
        }

        private static final Unit performRefactoring$lambda$1(Converter this$0, ConvertFunctionTypeReceiverToParameterIntention this$1, ArrayList $usages) {
            ApplicationUtilsKt.executeWriteCommand(this$0.getProject(), this$1.getText(), (Function0<Unit>)((Function0)() -> Converter.performRefactoring$lambda$1$0($usages, this$0)));
            return Unit.INSTANCE;
        }

        private static final PsiElement processExternalUsage$lambda$0(KtCallElement $this$getParentOfTypeAndBranch) {
            Intrinsics.checkNotNullParameter((Object)$this$getParentOfTypeAndBranch, (String)"$this$getParentOfTypeAndBranch");
            return (PsiElement)$this$getParentOfTypeAndBranch.getCalleeExpression();
        }

        private static final PsiElement processInternalUsages$lambda$0(KtCallExpression $this$getParentOfTypeAndBranch) {
            Intrinsics.checkNotNullParameter((Object)$this$getParentOfTypeAndBranch, (String)"$this$getParentOfTypeAndBranch");
            return (PsiElement)$this$getParentOfTypeAndBranch.getCalleeExpression();
        }

        private static final BindingContext processBody$lambda$1(Lazy<? extends BindingContext> $context$delegate) {
            Lazy<? extends BindingContext> lazy = $context$delegate;
            return (BindingContext)lazy.getValue();
        }

        private static final BindingContext processBody$lambda$0(KtDeclaration $declaration) {
            return ResolutionUtils.analyze((KtElement)$declaration, BodyResolveMode.PARTIAL_WITH_CFA);
        }

        private static final DeclarationDescriptor processBody$lambda$3(Lazy<? extends DeclarationDescriptor> $target$delegate) {
            Lazy<? extends DeclarationDescriptor> lazy = $target$delegate;
            return (DeclarationDescriptor)lazy.getValue();
        }

        private static final DeclarationDescriptor processBody$lambda$2(KtDeclaration $declaration, Lazy $context$delegate) {
            return (DeclarationDescriptor)Converter.processBody$lambda$1((Lazy<? extends BindingContext>)$context$delegate).get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$declaration);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit processBody$lambda$4(Lazy $context$delegate, Lazy $target$delegate, ArrayList $usages, KtReturnExpression returnExpression) {
            block3: {
                KtLambdaExpression ktLambdaExpression;
                void $this$safeAs$iv;
                KtElement ktElement;
                Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
                KtExpression ktExpression = returnExpression.getReturnedExpression();
                if (ktExpression == null || (ktElement = KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression))) == null) break block3;
                KtElement ktElement2 = ktElement;
                boolean $i$f$safeAs = false;
                Object v0 = $this$safeAs$iv;
                if (!(v0 instanceof KtLambdaExpression)) {
                    v0 = null;
                }
                if ((ktLambdaExpression = (KtLambdaExpression)v0) != null) {
                    KtLambdaExpression ktLambdaExpression2;
                    KtLambdaExpression it = ktLambdaExpression2 = ktLambdaExpression;
                    boolean bl = false;
                    Object object = ktElement2 = Intrinsics.areEqual((Object)BindingContextUtilsKt.getTargetFunctionDescriptor((KtReturnExpression)returnExpression, (BindingContext)Converter.processBody$lambda$1((Lazy<? extends BindingContext>)$context$delegate)), (Object)Converter.processBody$lambda$3((Lazy<? extends DeclarationDescriptor>)$target$delegate)) ? ktLambdaExpression2 : null;
                    if (ktElement2 != null) {
                        it = ktElement2;
                        boolean bl2 = false;
                        ((Collection)$usages).add(new LambdaInfo(it));
                    }
                }
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @NotNull
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            return new ConvertFunctionTypeReceiverToParameterIntention();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$LambdaInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;)V", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nConvertFunctionTypeReceiverToParameterIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertFunctionTypeReceiverToParameterIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$LambdaInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1642#2,10:340\n1915#2:350\n1916#2:352\n1652#2:353\n1915#2,2:354\n1#3:351\n*S KotlinDebug\n*F\n+ 1 ConvertFunctionTypeReceiverToParameterIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$LambdaInfo\n*L\n107#1:340,10\n107#1:350\n107#1:352\n107#1:353\n155#1:354,2\n107#1:351\n*E\n"})
    public static final class LambdaInfo
    extends AbstractProcessableUsageInfo<KtLambdaExpression, ConversionData> {
        public LambdaInfo(@NotNull KtLambdaExpression element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(elementsToShorten, (String)"elementsToShorten");
            KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)this.getElement();
            if (ktLambdaExpression == null || (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) == null) {
                return;
            }
            KtLambdaExpression lambda2 = ktLambdaExpression;
            BindingContext context2 = ResolutionUtils.analyze$default((KtElement)lambda2, null, 1, null);
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)lambda2);
            if (simpleFunctionDescriptor == null) {
                return;
            }
            SimpleFunctionDescriptor lambdaDescriptor = simpleFunctionDescriptor;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            List list2 = lambda2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            KtBlockExpression ktBlockExpression = lambda2.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktBlockExpression);
            Function1 function1 = new Fe10KotlinNewDeclarationNameValidator((PsiElement)ktBlockExpression, null, KotlinNameSuggestionProvider.ValidatorTarget.PARAMETER, null, 8, null);
            Collection collection2 = collection;
            CollectingNameValidator validator2 = new CollectingNameValidator(collection2, (Function1<? super String, Boolean>)function1);
            ReceiverParameterDescriptor lambdaExtensionReceiver = lambdaDescriptor.getExtensionReceiverParameter();
            ReceiverParameterDescriptor lambdaDispatchReceiver = lambdaDescriptor.getDispatchReceiverParameter();
            String newParameterName = (String)CollectionsKt.first(Fe10KotlinNameSuggester.INSTANCE.suggestNamesByType(data.getLambdaReceiverType(), (Function1<? super String, Boolean>)((Function1)validator2), "p"));
            KtExpression newParameterRefExpression = psiFactory.createExpression(newParameterName);
            List replacementFunctions = new ArrayList();
            lambda2.accept((PsiElementVisitor)new KtTreeVisitorVoid(context2, lambdaDescriptor, replacementFunctions, psiFactory, newParameterName, lambdaDispatchReceiver, lambdaExtensionReceiver, newParameterRefExpression){
                final /* synthetic */ BindingContext $context;
                final /* synthetic */ SimpleFunctionDescriptor $lambdaDescriptor;
                final /* synthetic */ List<Function0<Unit>> $replacementFunctions;
                final /* synthetic */ KtPsiFactory $psiFactory;
                final /* synthetic */ String $newParameterName;
                final /* synthetic */ ReceiverParameterDescriptor $lambdaDispatchReceiver;
                final /* synthetic */ ReceiverParameterDescriptor $lambdaExtensionReceiver;
                final /* synthetic */ KtExpression $newParameterRefExpression;
                {
                    this.$context = $context;
                    this.$lambdaDescriptor = $lambdaDescriptor;
                    this.$replacementFunctions = $replacementFunctions;
                    this.$psiFactory = $psiFactory;
                    this.$newParameterName = $newParameterName;
                    this.$lambdaDispatchReceiver = $lambdaDispatchReceiver;
                    this.$lambdaExtensionReceiver = $lambdaExtensionReceiver;
                    this.$newParameterRefExpression = $newParameterRefExpression;
                }

                public void visitSimpleNameExpression(KtSimpleNameExpression expression) {
                    DeclarationDescriptor extensionReceiverTarget;
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    super.visitSimpleNameExpression(expression);
                    if (expression instanceof KtOperationReferenceExpression) {
                        return;
                    }
                    ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.$context);
                    if (resolvedCall == null) {
                        return;
                    }
                    ResolvedCall resolvedCall2 = resolvedCall;
                    ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
                    DeclarationDescriptor dispatchReceiverTarget = receiverValue != null ? ExtensionUtils.getReceiverTargetDescriptor(receiverValue, this.$context) : null;
                    ReceiverValue receiverValue2 = resolvedCall2.getExtensionReceiver();
                    DeclarationDescriptor declarationDescriptor = extensionReceiverTarget = receiverValue2 != null ? ExtensionUtils.getReceiverTargetDescriptor(receiverValue2, this.$context) : null;
                    if (Intrinsics.areEqual((Object)dispatchReceiverTarget, (Object)this.$lambdaDescriptor) || Intrinsics.areEqual((Object)extensionReceiverTarget, (Object)this.$lambdaDescriptor)) {
                        PsiElement parent = expression.getParent();
                        if (parent instanceof KtCallExpression && Intrinsics.areEqual((Object)expression, (Object)((KtCallExpression)parent).getCalleeExpression())) {
                            PsiElement psiElement = ((KtCallExpression)parent).getParent();
                            KtQualifiedExpression ktQualifiedExpression = psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
                            if (!((ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null) instanceof KtThisExpression)) {
                                this.$replacementFunctions.add((Function0<Unit>)((Function0)() -> process.1.visitSimpleNameExpression$lambda$0(parent, this.$psiFactory, this.$newParameterName)));
                            }
                        } else if (!(parent instanceof KtQualifiedExpression) || !(((KtQualifiedExpression)parent).getReceiverExpression() instanceof KtThisExpression)) {
                            String referencedName = expression.getReferencedName();
                            this.$replacementFunctions.add((Function0<Unit>)((Function0)() -> process.1.visitSimpleNameExpression$lambda$1(expression, this.$psiFactory, this.$newParameterName, referencedName)));
                        }
                    }
                }

                public void visitThisExpression(KtThisExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.$context);
                    if (resolvedCall == null) {
                        return;
                    }
                    ResolvedCall resolvedCall2 = resolvedCall;
                    if (Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor(), (Object)this.$lambdaDispatchReceiver) || Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor(), (Object)this.$lambdaExtensionReceiver)) {
                        this.$replacementFunctions.add((Function0<Unit>)((Function0)() -> process.1.visitThisExpression$lambda$2(expression, this.$newParameterRefExpression)));
                    }
                }

                private static final Unit visitSimpleNameExpression$lambda$0(PsiElement $parent, KtPsiFactory $psiFactory, String $newParameterName) {
                    Object[] objectArray = new Object[]{$newParameterName, $parent};
                    ((KtCallExpression)$parent).replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)$psiFactory, (String)"$0.$1", (Object[])objectArray, (boolean)false, (int)4, null));
                    return Unit.INSTANCE;
                }

                private static final Unit visitSimpleNameExpression$lambda$1(KtSimpleNameExpression $expression, KtPsiFactory $psiFactory, String $newParameterName, String $referencedName) {
                    $expression.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)$psiFactory, (String)($newParameterName + "." + $referencedName), (Object[])new Object[0], (boolean)false, (int)4, null));
                    return Unit.INSTANCE;
                }

                private static final Unit visitThisExpression$lambda$2(KtThisExpression $expression, KtExpression $newParameterRefExpression) {
                    PsiElement psiElement = $newParameterRefExpression.copy();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"copy(...)");
                    $expression.replace(psiElement);
                    return Unit.INSTANCE;
                }
            });
            Iterable $this$forEach$iv = replacementFunctions;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
            KtParameterList lambdaParameterList = KtPsiUtilKt.getOrCreateParameterList((KtFunctionLiteral)lambda2);
            if (lambda2.getValueParameters().isEmpty()) {
                List list3 = lambdaDescriptor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueParameters(...)");
                if (!((Collection)list3).isEmpty()) {
                    String string = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
                    List list4 = psiFactory.createLambdaParameterList(string).getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getParameters(...)");
                    KtParameter parameterToAdd = (KtParameter)CollectionsKt.first((List)list4);
                    List list5 = lambdaParameterList.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getParameters(...)");
                    lambdaParameterList.addParameterBefore(parameterToAdd, (KtParameter)CollectionsKt.firstOrNull((List)list5));
                }
            }
            List list6 = psiFactory.createLambdaParameterList(newParameterName).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"getParameters(...)");
            KtParameter parameterToAdd = (KtParameter)CollectionsKt.first((List)list6);
            List list7 = lambdaParameterList.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list7, (String)"getParameters(...)");
            lambdaParameterList.addParameterBefore(parameterToAdd, (KtParameter)CollectionsKt.firstOrNull((List)list7));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ParameterCallInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeReceiverToParameterIntention$ConversionData;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.idea"})
    public static final class ParameterCallInfo
    extends AbstractProcessableUsageInfo<KtCallExpression, ConversionData> {
        public ParameterCallInfo(@NotNull KtCallExpression element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(elementsToShorten, (String)"elementsToShorten");
            KtCallExpression ktCallExpression = (KtCallExpression)this.getElement();
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression callExpression = ktCallExpression;
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)callExpression));
            if (ktQualifiedExpression == null) {
                return;
            }
            KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
            KtExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            KtValueArgumentList argumentList = KtPsiUtilKt.getOrCreateValueArgumentList((KtCallExpression)callExpression);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtValueArgument ktValueArgument = KtPsiFactory.createArgument$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (KtExpression)receiverExpression, null, (boolean)false, (boolean)false, (int)14, null);
            List list2 = argumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getArguments(...)");
            argumentList.addArgumentBefore(ktValueArgument, (KtValueArgument)CollectionsKt.firstOrNull((List)list2));
            qualifiedExpression.replace((PsiElement)callExpression);
        }
    }
}

