/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeArgumentsIntention;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeIntention;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/IntentionBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "<init>", "()V", "problemText", "", "getProblemText", "()Ljava/lang/String;", "additionalFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "RemoveExplicitTypeFix", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nRemoveExplicitTypeArgumentsIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveExplicitTypeArgumentsIntention.kt\norg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,200:1\n249#2:201\n*S KotlinDebug\n*F\n+ 1 RemoveExplicitTypeArgumentsIntention.kt\norg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection\n*L\n45#1:201\n*E\n"})
public final class RemoveExplicitTypeArgumentsInspection
extends IntentionBasedInspection<KtTypeArgumentList> {
    @NotNull
    private final String problemText = KotlinBundle.message((String)"explicit.type.arguments.can.be.inferred", (Object[])new Object[0]);

    public RemoveExplicitTypeArgumentsInspection() {
        super(Reflection.getOrCreateKotlinClass(RemoveExplicitTypeArgumentsIntention.class), null, 2, null);
    }

    @Override
    @NotNull
    protected String getProblemText() {
        return this.problemText;
    }

    @Override
    @Nullable
    public List<LocalQuickFix> additionalFixes(@NotNull KtTypeArgumentList element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
        if (ktCallableDeclaration == null) {
            return null;
        }
        KtCallableDeclaration declaration = ktCallableDeclaration;
        if (!RemoveExplicitTypeIntention.Holder.INSTANCE.isApplicableTo(declaration)) {
            return null;
        }
        String string = declaration.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return CollectionsKt.listOf((Object)new RemoveExplicitTypeFix(string));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection$RemoveExplicitTypeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "declarationName", "", "<init>", "(Ljava/lang/String;)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nRemoveExplicitTypeArgumentsIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveExplicitTypeArgumentsIntention.kt\norg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection$RemoveExplicitTypeFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,200:1\n249#2:201\n*S KotlinDebug\n*F\n+ 1 RemoveExplicitTypeArgumentsIntention.kt\norg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection$RemoveExplicitTypeFix\n*L\n57#1:201\n*E\n"})
    private static final class RemoveExplicitTypeFix
    implements LocalQuickFix {
        @NotNull
        private final String declarationName;

        public RemoveExplicitTypeFix(@NotNull String declarationName) {
            Intrinsics.checkNotNullParameter((Object)declarationName, (String)"declarationName");
            this.declarationName = declarationName;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.declarationName};
            return KotlinBundle.message((String)"remove.explicit.type.specification.from.0", (Object[])objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            KtTypeArgumentList ktTypeArgumentList = psiElement instanceof KtTypeArgumentList ? (KtTypeArgumentList)psiElement : null;
            if (ktTypeArgumentList == null) {
                return;
            }
            KtTypeArgumentList element = ktTypeArgumentList;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
            boolean $i$f$getStrictParentOfType = false;
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
            if (ktCallableDeclaration == null) {
                return;
            }
            KtCallableDeclaration declaration = ktCallableDeclaration;
            RemoveExplicitTypeIntention.Holder.INSTANCE.removeExplicitType(declaration);
        }
    }
}

