/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveForLoopIndicesIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "<init>", "()V", "WITH_INDEX_NAME", "", "WITH_INDEX_FQ_NAMES", "", "getWITH_INDEX_FQ_NAMES", "()Ljava/util/Set;", "WITH_INDEX_FQ_NAMES$delegate", "Lkotlin/Lazy;", "startInWriteAction", "", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class RemoveForLoopIndicesIntention
extends SelfTargetingRangeIntention<KtForExpression> {
    @NotNull
    private final String WITH_INDEX_NAME;
    @NotNull
    private final Lazy WITH_INDEX_FQ_NAMES$delegate = LazyKt.lazy(() -> RemoveForLoopIndicesIntention.WITH_INDEX_FQ_NAMES_delegate$lambda$0(this));

    public RemoveForLoopIndicesIntention() {
        super(KtForExpression.class, KotlinBundle.messagePointer((String)"remove.indices.in.for.loop", (Object[])new Object[0]), null, 4, null);
        this.WITH_INDEX_NAME = "withIndex";
    }

    private final Set<String> getWITH_INDEX_FQ_NAMES() {
        Lazy lazy = this.WITH_INDEX_FQ_NAMES$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtForExpression element) {
        ResolvedCall resolvedCall;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getLoopRange();
        KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null;
        if (ktDotQualifiedExpression == null) {
            return null;
        }
        KtDotQualifiedExpression loopRange = ktDotQualifiedExpression;
        KtDestructuringDeclaration ktDestructuringDeclaration = element.getDestructuringDeclaration();
        if (ktDestructuringDeclaration == null) {
            return null;
        }
        KtDestructuringDeclaration multiParameter = ktDestructuringDeclaration;
        if (multiParameter.getEntries().size() != 2) {
            return null;
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)loopRange, null, 1, null);
        if (!CollectionsKt.contains((Iterable)this.getWITH_INDEX_FQ_NAMES(), (resolvedCall = resolvedCall2) != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null && (resolvedCall = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall))) != null ? resolvedCall.asString() : null)) {
            return null;
        }
        KtDestructuringDeclarationEntry indexVar = (KtDestructuringDeclarationEntry)multiParameter.getEntries().get(0);
        if (CollectionsKt.any((Iterable)ReferencesSearch.search((PsiElement)((PsiElement)indexVar)).asIterable())) {
            return null;
        }
        PsiElement psiElement = indexVar.getNameIdentifier();
        return psiElement != null ? FixersUtilKt.getRange((PsiElement)psiElement) : null;
    }

    @Override
    public void applyTo(@NotNull KtForExpression element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtDestructuringDeclaration ktDestructuringDeclaration = element.getDestructuringDeclaration();
        Intrinsics.checkNotNull((Object)ktDestructuringDeclaration);
        KtDestructuringDeclaration multiParameter = ktDestructuringDeclaration;
        KtExpression ktExpression = element.getLoopRange();
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
        KtDotQualifiedExpression loopRange = (KtDotQualifiedExpression)ktExpression;
        KtDestructuringDeclarationEntry elementVar = (KtDestructuringDeclarationEntry)multiParameter.getEntries().get(1);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)elementVar.getText(), (String)"getText(...)");
        KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"for ($0 in _) {}", (Object[])objectArray, (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
        KtForExpression loop = (KtForExpression)ktExpression2;
        ActionsKt.runWriteAction(() -> RemoveForLoopIndicesIntention.applyTo$lambda$0(element, loop, loopRange));
    }

    private static final String WITH_INDEX_FQ_NAMES_delegate$lambda$0$0(RemoveForLoopIndicesIntention this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "kotlin." + it + "." + this$0.WITH_INDEX_NAME;
    }

    private static final Set WITH_INDEX_FQ_NAMES_delegate$lambda$0(RemoveForLoopIndicesIntention this$0) {
        Object[] objectArray = new String[]{"collections", "sequences", "text", "ranges"};
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), arg_0 -> RemoveForLoopIndicesIntention.WITH_INDEX_FQ_NAMES_delegate$lambda$0$0(this$0, arg_0)));
    }

    private static final PsiElement applyTo$lambda$0(KtForExpression $element, KtForExpression $loop, KtDotQualifiedExpression $loopRange) {
        KtParameter ktParameter = $element.getLoopParameter();
        Intrinsics.checkNotNull((Object)ktParameter);
        KtParameter ktParameter2 = $loop.getLoopParameter();
        Intrinsics.checkNotNull((Object)ktParameter2);
        ktParameter.replace((PsiElement)ktParameter2);
        return $loopRange.replace((PsiElement)$loopRange.getReceiverExpression());
    }
}

