/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.StringTemplateUtilsKt;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e*\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ToRawStringLiteralIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "isApplicableTo", "", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "value", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nToRawStringLiteralIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToRawStringLiteralIntention.kt\norg/jetbrains/kotlin/idea/intentions/ToRawStringLiteralIntention\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,62:1\n4253#2,12:63\n25#3,7:75\n*S KotlinDebug\n*F\n+ 1 ToRawStringLiteralIntention.kt\norg/jetbrains/kotlin/idea/intentions/ToRawStringLiteralIntention\n*L\n34#1:63,12\n50#1:75,7\n*E\n"})
public final class ToRawStringLiteralIntention
extends SelfTargetingOffsetIndependentIntention<KtStringTemplateExpression>
implements LowPriorityAction {
    public ToRawStringLiteralIntention() {
        super(KtStringTemplateExpression.class, KotlinBundle.messagePointer((String)"convert.to.raw.string.literal", (Object[])new Object[0]), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (PsiTreeUtil.nextLeaf((PsiElement)((PsiElement)element)) instanceof PsiErrorElement) {
            return false;
        }
        if (element.getInterpolationPrefix() != null) {
            return false;
        }
        String text = element.getText();
        Intrinsics.checkNotNull((Object)text);
        if (StringsKt.startsWith$default((String)text, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$filterIsInstance$iv = ktStringTemplateEntryArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtEscapeStringTemplateEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List escapeEntries = (List)destination$iv$iv;
        for (KtEscapeStringTemplateEntry entry : escapeEntries) {
            String string = entry.getUnescapedValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUnescapedValue(...)");
            Character c = StringsKt.singleOrNull((CharSequence)string);
            if (c == null) {
                return false;
            }
            char c2 = c.charValue();
            if (!Character.isISOControl(c2) || c2 == '\n' || c2 == '\r') continue;
            return false;
        }
        String converted = StringTemplateUtilsKt.convertContentForRawString(element);
        return !StringsKt.contains$default((CharSequence)converted, (CharSequence)"\"\"\"", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element, @Nullable Editor editor) {
        block5: {
            int offset;
            PsiElement psiElement;
            void $this$replaced$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            int startOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
            int endOffset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element));
            Editor editor2 = editor;
            int currentOffset = editor2 != null && (editor2 = editor2.getCaretModel()) != null && (editor2 = editor2.getCurrentCaret()) != null ? editor2.getOffset() : startOffset;
            String text = StringTemplateUtilsKt.convertContentForRawString(element);
            PsiElement psiElement2 = (PsiElement)element;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PsiElement newElement$iv = (PsiElement)new KtPsiFactory(project, false, 2, null).createExpression("\"\"\"" + text + "\"\"\"");
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression;
                }
            }
            KtExpression replaced = (KtExpression)psiElement;
            int n = offset = startOffset == currentOffset ? startOffset : (endOffset == currentOffset ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)replaced)) : Math.min(currentOffset + 2, PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)replaced))));
            Editor editor3 = editor;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block5;
            editor3.moveToOffset(offset);
        }
    }

    private final String value(KtStringTemplateEntry $this$value) {
        return $this$value instanceof KtEscapeStringTemplateEntry ? ((KtEscapeStringTemplateEntry)$this$value).getUnescapedValue() : $this$value.getText();
    }
}

