/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.copyConcatenatedStringToClipboard;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.copyConcatenatedStringToClipboard.ConcatenatedStringGenerator;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/copyConcatenatedStringToClipboard/CopyConcatenatedStringToClipboardIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "<init>", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "checkFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isApplicableTo", "kotlin.idea"})
public final class CopyConcatenatedStringToClipboardIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    public CopyConcatenatedStringToClipboardIntention() {
        super(KtBinaryExpression.class, KotlinBundle.messagePointer((String)"copy.concatenation.text.to.clipboard", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String text = new ConcatenatedStringGenerator().create(element);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
    }

    @Override
    protected boolean checkFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!Intrinsics.areEqual((Object)element.getOperationToken(), (Object)KtTokens.PLUS)) {
            return false;
        }
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)element, null, 1, null);
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        return KotlinBuiltIns.isString((KotlinType)resolvedCall2.getCandidateDescriptor().getReturnType());
    }
}

