/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain.result;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.AssignToVariableResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ChainedCallGenerator;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ReplaceLoopResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.VariableInitialization;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/result/FlatMapToTransformation;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ReplaceLoopResultTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "targetCollection", "Lorg/jetbrains/kotlin/psi/KtExpression;", "transform", "<init>", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "presentation", "", "getPresentation", "()Ljava/lang/String;", "generateCode", "chainedCallGenerator", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ChainedCallGenerator;", "lazyMakesSense", "", "getLazyMakesSense", "()Z", "Companion", "kotlin.idea"})
public final class FlatMapToTransformation
extends ReplaceLoopResultTransformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCallableDeclaration inputVariable;
    @NotNull
    private final KtExpression targetCollection;
    @NotNull
    private final KtExpression transform;

    private FlatMapToTransformation(KtForExpression loop, KtCallableDeclaration inputVariable, KtExpression targetCollection, KtExpression transform2) {
        super(loop);
        this.inputVariable = inputVariable;
        this.targetCollection = targetCollection;
        this.transform = transform2;
    }

    @Override
    @NotNull
    public String getPresentation() {
        return "flatMapTo(){}";
    }

    @Override
    @NotNull
    public KtExpression generateCode(@NotNull ChainedCallGenerator chainedCallGenerator2) {
        Intrinsics.checkNotNullParameter((Object)chainedCallGenerator2, (String)"chainedCallGenerator");
        KtLambdaExpression lambda2 = UtilsKt.generateLambda(this.inputVariable, this.transform, chainedCallGenerator2.getReformat());
        Object[] objectArray = new Object[]{this.targetCollection, lambda2};
        return ChainedCallGenerator.generate$default(chainedCallGenerator2, "flatMapTo($0) $1:'{}'", objectArray, null, false, 12, null);
    }

    @Override
    public boolean getLazyMakesSense() {
        return true;
    }

    public /* synthetic */ FlatMapToTransformation(KtForExpression loop, KtCallableDeclaration inputVariable, KtExpression targetCollection, KtExpression transform2, DefaultConstructorMarker $constructor_marker) {
        this(loop, inputVariable, targetCollection, transform2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/result/FlatMapToTransformation$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ResultTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "targetCollection", "Lorg/jetbrains/kotlin/psi/KtExpression;", "transform", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResultTransformation create(@NotNull KtForExpression loop, @NotNull KtCallableDeclaration inputVariable, @NotNull KtExpression targetCollection, @NotNull KtExpression transform2) {
            ResultTransformation resultTransformation;
            Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
            Intrinsics.checkNotNullParameter((Object)inputVariable, (String)"inputVariable");
            Intrinsics.checkNotNullParameter((Object)targetCollection, (String)"targetCollection");
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            VariableInitialization initialization = UtilsKt.findVariableInitializationBeforeLoop(targetCollection, loop, true);
            if (initialization != null && UtilsKt.hasNoSideEffect(initialization.getInitializer())) {
                FlatMapToTransformation transformation = new FlatMapToTransformation(loop, inputVariable, initialization.getInitializer(), transform2, null);
                resultTransformation = AssignToVariableResultTransformation.Companion.createDelegated(transformation, initialization);
            } else {
                resultTransformation = new FlatMapToTransformation(loop, inputVariable, targetCollection, transform2, null);
            }
            return resultTransformation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

