/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain.result;

import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.AssignToVariableResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ChainedCallGenerator;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchingState;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.SequenceTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatch;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatcher;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.VariableInitialization;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence.MapTransformation;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/result/MaxOrMinTransformation;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/AssignToVariableResultTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "initialization", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/VariableInitialization;", "isMax", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/VariableInitialization;Z)V", "presentation", "", "getPresentation", "()Ljava/lang/String;", "generateCode", "Lorg/jetbrains/kotlin/psi/KtExpression;", "chainedCallGenerator", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ChainedCallGenerator;", "Matcher", "kotlin.idea"})
public final class MaxOrMinTransformation
extends AssignToVariableResultTransformation {
    private final boolean isMax;

    public MaxOrMinTransformation(@NotNull KtForExpression loop, @NotNull VariableInitialization initialization, boolean isMax) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)initialization, (String)"initialization");
        super(loop, initialization);
        this.isMax = isMax;
    }

    @Override
    @NotNull
    public String getPresentation() {
        return this.isMax ? "maxOrNull()" : "minOrNull()";
    }

    @Override
    @NotNull
    public KtExpression generateCode(@NotNull ChainedCallGenerator chainedCallGenerator2) {
        Intrinsics.checkNotNullParameter((Object)chainedCallGenerator2, (String)"chainedCallGenerator");
        KtExpression call = ChainedCallGenerator.generate$default(chainedCallGenerator2, this.getPresentation(), new Object[0], null, false, 12, null);
        Project project = call.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object[] objectArray = new Object[]{call, this.getInitialization().getInitializer()};
        return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0\n ?: $1", (Object[])objectArray, (boolean)chainedCallGenerator2.getReformat());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002JB\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/result/MaxOrMinTransformation$Matcher;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatcher;", "<init>", "()V", "indexVariableAllowed", "", "getIndexVariableAllowed", "()Z", "match", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatch$Result;", "state", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/MatchingState;", "matchIfAssign", "matchAssignIf", "matchMathMaxOrMin", "variableInitialization", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/VariableInitialization;", "assignment", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isMax", "condition", "Lorg/jetbrains/kotlin/psi/KtExpression;", "assignmentTarget", "valueAssignedIfTrue", "valueAssignedIfFalse", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "kotlin.idea"})
    public static final class Matcher
    implements TransformationMatcher {
        @NotNull
        public static final Matcher INSTANCE = new Matcher();

        private Matcher() {
        }

        @Override
        public boolean getIndexVariableAllowed() {
            return true;
        }

        @Override
        @Nullable
        public TransformationMatch.Result match(@NotNull MatchingState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            TransformationMatch.Result result2 = this.matchIfAssign(state);
            if (result2 == null && (result2 = this.matchAssignIf(state)) == null) {
                result2 = this.matchMathMaxOrMin(state);
            }
            return result2;
        }

        private final TransformationMatch.Result matchIfAssign(MatchingState state) {
            Object object = CollectionsKt.singleOrNull(state.getStatements());
            KtIfExpression ktIfExpression = object instanceof KtIfExpression ? (KtIfExpression)object : null;
            if (ktIfExpression == null) {
                return null;
            }
            KtIfExpression ifExpression2 = ktIfExpression;
            if (ifExpression2.getElse() != null) {
                return null;
            }
            KtExpression ktExpression = ifExpression2.getThen();
            if (ktExpression == null) {
                return null;
            }
            KtExpression then = ktExpression;
            Object object2 = SequencesKt.singleOrNull((Sequence)KtPsiUtilKt.blockExpressionsOrSingle((KtElement)((KtElement)then)));
            KtBinaryExpression ktBinaryExpression = object2 instanceof KtBinaryExpression ? (KtBinaryExpression)object2 : null;
            if (ktBinaryExpression == null) {
                return null;
            }
            KtBinaryExpression statement = ktBinaryExpression;
            if (!Intrinsics.areEqual((Object)statement.getOperationToken(), (Object)KtTokens.EQ)) {
                return null;
            }
            return this.match(ifExpression2.getCondition(), statement.getLeft(), statement.getRight(), null, state.getInputVariable(), state.getOuterLoop());
        }

        private final TransformationMatch.Result matchAssignIf(MatchingState state) {
            Object object = CollectionsKt.singleOrNull(state.getStatements());
            KtBinaryExpression ktBinaryExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
            if (ktBinaryExpression == null) {
                return null;
            }
            KtBinaryExpression assignment2 = ktBinaryExpression;
            if (!Intrinsics.areEqual((Object)assignment2.getOperationToken(), (Object)KtTokens.EQ)) {
                return null;
            }
            KtExpression ktExpression = assignment2.getRight();
            KtIfExpression ktIfExpression = ktExpression instanceof KtIfExpression ? (KtIfExpression)ktExpression : null;
            if (ktIfExpression == null) {
                return null;
            }
            KtIfExpression ifExpression2 = ktIfExpression;
            return this.match(ifExpression2.getCondition(), assignment2.getLeft(), ifExpression2.getThen(), ifExpression2.getElse(), state.getInputVariable(), state.getOuterLoop());
        }

        private final TransformationMatch.Result matchMathMaxOrMin(MatchingState state) {
            Object object = CollectionsKt.singleOrNull(state.getStatements());
            KtBinaryExpression ktBinaryExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
            if (ktBinaryExpression == null) {
                return null;
            }
            KtBinaryExpression assignment2 = ktBinaryExpression;
            if (!Intrinsics.areEqual((Object)assignment2.getOperationToken(), (Object)KtTokens.EQ)) {
                return null;
            }
            VariableInitialization variableInitialization = UtilsKt.findVariableInitializationBeforeLoop(assignment2.getLeft(), state.getOuterLoop(), false);
            if (variableInitialization == null) {
                return null;
            }
            VariableInitialization variableInitialization2 = variableInitialization;
            TransformationMatch.Result result2 = this.matchMathMaxOrMin(variableInitialization2, assignment2, state, true);
            if (result2 == null) {
                result2 = this.matchMathMaxOrMin(variableInitialization2, assignment2, state, false);
            }
            return result2;
        }

        private final TransformationMatch.Result matchMathMaxOrMin(VariableInitialization variableInitialization, KtBinaryExpression assignment2, MatchingState state, boolean isMax) {
            KtExpression value;
            KtExpression ktExpression;
            String functionName = isMax ? "max" : "min";
            List<KtExpression> list2 = CommonUtilsKt.extractStaticFunctionCallArguments(assignment2.getRight(), "java.lang.Math." + functionName);
            if (list2 == null) {
                return null;
            }
            List<KtExpression> arguments2 = list2;
            if (arguments2.size() != 2) {
                return null;
            }
            if (CommonUtilsKt.isVariableReference(arguments2.get(0), (KtCallableDeclaration)variableInitialization.getVariable())) {
                ktExpression = arguments2.get(1);
                if (ktExpression == null) {
                    return null;
                }
            } else if (CommonUtilsKt.isVariableReference(arguments2.get(1), (KtCallableDeclaration)variableInitialization.getVariable())) {
                ktExpression = arguments2.get(0);
                if (ktExpression == null) {
                    return null;
                }
            } else {
                return null;
            }
            MapTransformation mapTransformation = CommonUtilsKt.isVariableReference(value = ktExpression, state.getInputVariable()) ? null : new MapTransformation(state.getOuterLoop(), state.getInputVariable(), state.getIndexVariable(), value, false);
            MaxOrMinTransformation transformation = new MaxOrMinTransformation(state.getOuterLoop(), variableInitialization, isMax);
            return new TransformationMatch.Result((ResultTransformation)transformation, CollectionsKt.listOfNotNull((Object)mapTransformation));
        }

        private final TransformationMatch.Result match(KtExpression condition2, KtExpression assignmentTarget, KtExpression valueAssignedIfTrue, KtExpression valueAssignedIfFalse, KtCallableDeclaration inputVariable, KtForExpression loop) {
            KtExpression ktExpression;
            KtNameReferenceExpression ktNameReferenceExpression;
            if (!(condition2 instanceof KtBinaryExpression)) {
                return null;
            }
            IElementType iElementType = ((KtBinaryExpression)condition2).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
            IElementType comparison = iElementType;
            Object[] objectArray = new KtSingleValueToken[]{KtTokens.GT, KtTokens.LT, KtTokens.GTEQ, KtTokens.LTEQ};
            if (!CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)comparison)) {
                return null;
            }
            KtExpression ktExpression2 = ((KtBinaryExpression)condition2).getLeft();
            KtNameReferenceExpression ktNameReferenceExpression2 = ktExpression2 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression2 : null;
            if (ktNameReferenceExpression2 == null) {
                return null;
            }
            KtNameReferenceExpression left = ktNameReferenceExpression2;
            KtExpression ktExpression3 = ((KtBinaryExpression)condition2).getRight();
            KtNameReferenceExpression ktNameReferenceExpression3 = ktExpression3 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression3 : null;
            if (ktNameReferenceExpression3 == null) {
                return null;
            }
            KtNameReferenceExpression right = ktNameReferenceExpression3;
            if (CommonUtilsKt.isVariableReference((KtExpression)left, inputVariable)) {
                ktNameReferenceExpression = right;
            } else if (CommonUtilsKt.isVariableReference((KtExpression)right, inputVariable)) {
                ktNameReferenceExpression = left;
            } else {
                return null;
            }
            KtNameReferenceExpression otherHand = ktNameReferenceExpression;
            VariableInitialization variableInitialization = UtilsKt.findVariableInitializationBeforeLoop((KtExpression)otherHand, loop, false);
            if (variableInitialization == null) {
                return null;
            }
            VariableInitialization variableInitialization2 = variableInitialization;
            if (!CommonUtilsKt.isVariableReference(assignmentTarget, (KtCallableDeclaration)variableInitialization2.getVariable())) {
                return null;
            }
            if (CommonUtilsKt.isVariableReference(valueAssignedIfTrue, inputVariable)) {
                ktExpression = valueAssignedIfFalse;
            } else if (CommonUtilsKt.isVariableReference(valueAssignedIfFalse, inputVariable)) {
                ktExpression = valueAssignedIfTrue;
            } else {
                return null;
            }
            KtExpression valueToBeVariable = ktExpression;
            if (valueToBeVariable != null && !CommonUtilsKt.isVariableReference(valueToBeVariable, (KtCallableDeclaration)variableInitialization2.getVariable())) {
                return null;
            }
            boolean isMax = (Intrinsics.areEqual((Object)comparison, (Object)KtTokens.GT) || Intrinsics.areEqual((Object)comparison, (Object)KtTokens.GTEQ)) ^ Intrinsics.areEqual((Object)otherHand, (Object)left);
            MaxOrMinTransformation transformation = new MaxOrMinTransformation(loop, variableInitialization2, isMax);
            return new TransformationMatch.Result((ResultTransformation)transformation, new SequenceTransformation[0]);
        }
    }
}

