/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence.Condition;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/AtomicCondition;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/Condition;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isNegated", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "asExpression", "reformat", "asNegatedExpression", "toAtomicConditions", "", "negate", "kotlin.idea"})
public final class AtomicCondition
implements Condition {
    @NotNull
    private final KtExpression expression;
    private final boolean isNegated;

    public AtomicCondition(@NotNull KtExpression expression, boolean isNegated2) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.expression = expression;
        this.isNegated = isNegated2;
        boolean bl = this.expression.isPhysical();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ AtomicCondition(KtExpression ktExpression, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(ktExpression, bl);
    }

    @NotNull
    public final KtExpression getExpression() {
        return this.expression;
    }

    @Override
    @NotNull
    public KtExpression asExpression(boolean reformat) {
        return this.isNegated ? UtilsKt.negate(this.expression, reformat) : this.expression;
    }

    @Override
    @NotNull
    public KtExpression asNegatedExpression(boolean reformat) {
        return this.isNegated ? this.expression : UtilsKt.negate(this.expression, reformat);
    }

    @Override
    @NotNull
    public List<AtomicCondition> toAtomicConditions() {
        return CollectionsKt.listOf((Object)this);
    }

    @NotNull
    public final AtomicCondition negate() {
        return new AtomicCondition(this.expression, !this.isNegated);
    }
}

