/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing.inference.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.Constraint;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.ConstraintBound;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.ConstraintKt;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.ConstraintPriority;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.DebugPrinter;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.DefaultStateProvider;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.EqualsConstraint;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.InferenceContext;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.LiteralBound;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.State;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.SubtypeConstraint;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariable;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariableBound;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariablesKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0012\u0010\u0014\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u0012\u0010\u001d\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010 \u001a\u00020\u0017H\u0002J \u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010 \u001a\u00020\u0017H\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010#*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0012\u0010$\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/Solver;", "", "inferenceContext", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/InferenceContext;", "printConstraints", "", "defaultStateProvider", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DefaultStateProvider;", "<init>", "(Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/InferenceContext;ZLorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DefaultStateProvider;)V", "printer", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DebugPrinter;", "printDebugInfo", "", "", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/Constraint;", "step", "", "solveConstraints", "constraints", "cleanConstraints", "", "handleConstraintsWithNullableLowerBound", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/ConstraintPriority;", "handleConstraintsWithNotNullUpperBound", "fixedState", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/State;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/ConstraintBound;", "handleEqualsConstraints", "substituteConstraints", "getConstraintsWithNullableLowerBound", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/SubtypeConstraint;", "priority", "getConstraintsWithNotNullUpperBound", "getTypeVariableAsEqualsOrUpperBound", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/TypeVariable;", "filterOutConstraintsWithUnusedState", "kotlin.j2k.k1.new.post-processing"})
@SourceDebugExtension(value={"SMAP\nSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Solver.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/Solver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n296#2,2:206\n812#2,12:208\n777#2:220\n873#2,2:221\n812#2,12:223\n777#2:235\n873#2:236\n874#2:238\n812#2,12:239\n777#2:251\n873#2:252\n874#2:254\n137#3:237\n137#3:253\n137#3:255\n137#3:257\n137#3:258\n137#3:259\n1#4:256\n*S KotlinDebug\n*F\n+ 1 Solver.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/Solver\n*L\n60#1:206,2\n117#1:208,12\n117#1:220\n117#1:221,2\n159#1:223,12\n159#1:235\n159#1:236\n159#1:238\n165#1:239,12\n165#1:251\n165#1:252\n165#1:254\n161#1:237\n167#1:253\n175#1:255\n179#1:257\n186#1:258\n187#1:259\n*E\n"})
public final class Solver {
    @NotNull
    private final InferenceContext inferenceContext;
    private final boolean printConstraints;
    @NotNull
    private final DefaultStateProvider defaultStateProvider;
    @NotNull
    private final DebugPrinter printer;

    public Solver(@NotNull InferenceContext inferenceContext, boolean printConstraints, @NotNull DefaultStateProvider defaultStateProvider) {
        Intrinsics.checkNotNullParameter((Object)inferenceContext, (String)"inferenceContext");
        Intrinsics.checkNotNullParameter((Object)defaultStateProvider, (String)"defaultStateProvider");
        this.inferenceContext = inferenceContext;
        this.printConstraints = printConstraints;
        this.defaultStateProvider = defaultStateProvider;
        this.printer = new DebugPrinter(this.inferenceContext);
    }

    private final void printDebugInfo(List<? extends Constraint> $this$printDebugInfo, int step2) {
        DebugPrinter $this$printDebugInfo_u24lambda_u240 = this.printer;
        boolean bl = false;
        if (this.printConstraints) {
            System.out.println((Object)("Step " + step2 + ":"));
            for (Constraint constraint : $this$printDebugInfo) {
                System.out.println((Object)$this$printDebugInfo_u24lambda_u240.asString(constraint));
            }
            System.out.println();
            System.out.println((Object)"type variables:");
            for (TypeVariable typeVariable : this.inferenceContext.getTypeVariables()) {
                if (typeVariable.getState() == State.UNUSED) continue;
                System.out.println((Object)($this$printDebugInfo_u24lambda_u240.getName(typeVariable) + " := " + typeVariable.getState()));
            }
            System.out.println((Object)"---------------\n");
        }
    }

    public final void solveConstraints(@NotNull List<? extends Constraint> constraints) {
        boolean somethingChanged;
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        List mutableConstraints = CollectionsKt.toMutableList((Collection)constraints);
        this.filterOutConstraintsWithUnusedState(mutableConstraints);
        Object currentStep = null;
        currentStep = ArraysKt.first((Object[])ConstraintPriority.values());
        int i2 = 0;
        do {
            somethingChanged = false;
            List $this$solveConstraints_u24lambda_u240 = mutableConstraints;
            boolean bl = false;
            this.printDebugInfo($this$solveConstraints_u24lambda_u240, i2);
            somethingChanged = this.handleConstraintsWithNullableLowerBound($this$solveConstraints_u24lambda_u240, (ConstraintPriority)((Object)currentStep));
            somethingChanged = this.handleConstraintsWithNotNullUpperBound($this$solveConstraints_u24lambda_u240, (ConstraintPriority)((Object)currentStep)) || somethingChanged;
            somethingChanged = this.handleEqualsConstraints($this$solveConstraints_u24lambda_u240, (ConstraintPriority)((Object)currentStep)) || somethingChanged;
            somethingChanged = this.substituteConstraints($this$solveConstraints_u24lambda_u240) || somethingChanged;
            this.cleanConstraints($this$solveConstraints_u24lambda_u240);
            if (!somethingChanged && ((ConstraintPriority)((Object)currentStep)).ordinal() < ArraysKt.getLastIndex((Object[])ConstraintPriority.values())) {
                currentStep = ConstraintPriority.values()[((ConstraintPriority)((Object)currentStep)).ordinal() + 1];
                somethingChanged = true;
            }
            if (!somethingChanged) {
                TypeVariable typeVariable;
                TypeVariable typeVariable2 = this.getTypeVariableAsEqualsOrUpperBound(mutableConstraints);
                if (typeVariable2 == null) {
                    Object v1;
                    block6: {
                        Iterable $this$firstOrNull$iv = this.inferenceContext.getTypeVariables();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            TypeVariable it = (TypeVariable)element$iv;
                            boolean bl2 = false;
                            if (!(!TypeVariablesKt.isFixed(it))) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    typeVariable2 = v1;
                }
                if ((typeVariable = typeVariable2) != null) {
                    TypeVariablesKt.setStateIfNotFixed(typeVariable, this.defaultStateProvider.defaultStateFor(typeVariable));
                    somethingChanged = true;
                }
            }
            int n = i2;
            i2 = n + 1;
        } while (somethingChanged);
    }

    private final void cleanConstraints(List<Constraint> $this$cleanConstraints) {
        $this$cleanConstraints.removeIf(arg_0 -> Solver.cleanConstraints$lambda$1(Solver::cleanConstraints$lambda$0, arg_0));
    }

    private final boolean handleConstraintsWithNullableLowerBound(List<Constraint> $this$handleConstraintsWithNullableLowerBound, ConstraintPriority step2) {
        boolean somethingChanged = false;
        List<SubtypeConstraint> nullableConstraints = this.getConstraintsWithNullableLowerBound($this$handleConstraintsWithNullableLowerBound, step2);
        if (!((Collection)nullableConstraints).isEmpty()) {
            CollectionsKt.removeAll((Collection)$this$handleConstraintsWithNullableLowerBound, (Iterable)nullableConstraints);
            Iterator<SubtypeConstraint> iterator2 = nullableConstraints.iterator();
            while (iterator2.hasNext()) {
                ConstraintBound upperBound = iterator2.next().component2();
                if (!(upperBound instanceof TypeVariableBound)) continue;
                somethingChanged = true;
                TypeVariablesKt.setStateIfNotFixed(((TypeVariableBound)upperBound).getTypeVariable(), State.UPPER);
            }
        }
        return somethingChanged;
    }

    private final boolean handleConstraintsWithNotNullUpperBound(List<Constraint> $this$handleConstraintsWithNotNullUpperBound, ConstraintPriority step2) {
        boolean somethingChanged = false;
        List<SubtypeConstraint> nullableConstraints = this.getConstraintsWithNotNullUpperBound($this$handleConstraintsWithNotNullUpperBound, step2);
        if (!((Collection)nullableConstraints).isEmpty()) {
            CollectionsKt.removeAll((Collection)$this$handleConstraintsWithNotNullUpperBound, (Iterable)nullableConstraints);
            Iterator<SubtypeConstraint> iterator2 = nullableConstraints.iterator();
            while (iterator2.hasNext()) {
                ConstraintBound lowerBound = iterator2.next().component1();
                if (!(lowerBound instanceof TypeVariableBound)) continue;
                somethingChanged = true;
                TypeVariablesKt.setStateIfNotFixed(((TypeVariableBound)lowerBound).getTypeVariable(), State.LOWER);
            }
        }
        return somethingChanged;
    }

    private final State fixedState(ConstraintBound $this$fixedState) {
        return $this$fixedState instanceof LiteralBound ? ((LiteralBound)$this$fixedState).getState() : ($this$fixedState instanceof TypeVariableBound && TypeVariablesKt.isFixed(((TypeVariableBound)$this$fixedState).getTypeVariable()) ? ((TypeVariableBound)$this$fixedState).getTypeVariable().getState() : null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handleEqualsConstraints(List<Constraint> $this$handleEqualsConstraints, ConstraintPriority step2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        boolean somethingChanged = false;
        Iterable $this$filterIsInstance$iv = $this$handleEqualsConstraints;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EqualsConstraint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EqualsConstraint it = (EqualsConstraint)element$iv$iv;
            boolean bl = false;
            if (!(it.getPriority().compareTo((Enum)step2) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List equalsConstraints = (List)destination$iv$iv;
        if (!((Collection)equalsConstraints).isEmpty()) {
            for (EqualsConstraint constraint : equalsConstraints) {
                ConstraintBound leftBound = constraint.component1();
                ConstraintBound rightBound = constraint.component2();
                if (leftBound instanceof TypeVariableBound && this.fixedState(rightBound) != null) {
                    ((Collection)$this$handleEqualsConstraints).remove(constraint);
                    somethingChanged = true;
                    TypeVariable typeVariable = ((TypeVariableBound)leftBound).getTypeVariable();
                    State state = this.fixedState(rightBound);
                    Intrinsics.checkNotNull((Object)((Object)state));
                    TypeVariablesKt.setStateIfNotFixed(typeVariable, state);
                    continue;
                }
                if (!(rightBound instanceof TypeVariableBound) || this.fixedState(leftBound) == null) continue;
                ((Collection)$this$handleEqualsConstraints).remove(constraint);
                somethingChanged = true;
                TypeVariable typeVariable = ((TypeVariableBound)rightBound).getTypeVariable();
                State state = this.fixedState(leftBound);
                Intrinsics.checkNotNull((Object)((Object)state));
                TypeVariablesKt.setStateIfNotFixed(typeVariable, state);
            }
        }
        return somethingChanged;
    }

    private final boolean substituteConstraints(List<? extends Constraint> $this$substituteConstraints) {
        boolean somethingChanged = false;
        for (Constraint constraint : $this$substituteConstraints) {
            if (!(constraint instanceof SubtypeConstraint)) continue;
            Constraint constraint2 = constraint;
            ConstraintBound lower = ((SubtypeConstraint)constraint2).component1();
            ConstraintBound upper = ((SubtypeConstraint)constraint2).component2();
            if (lower instanceof TypeVariableBound && TypeVariablesKt.isFixed(((TypeVariableBound)lower).getTypeVariable())) {
                somethingChanged = true;
                LiteralBound literalBound = ConstraintKt.constraintBound(((TypeVariableBound)lower).getTypeVariable().getState());
                if (literalBound == null) {
                    continue;
                }
                ((SubtypeConstraint)constraint).setSubtype(literalBound);
            }
            if (!(upper instanceof TypeVariableBound) || !TypeVariablesKt.isFixed(((TypeVariableBound)upper).getTypeVariable())) continue;
            somethingChanged = true;
            LiteralBound literalBound = ConstraintKt.constraintBound(((TypeVariableBound)upper).getTypeVariable().getState());
            if (literalBound == null) {
                continue;
            }
            ((SubtypeConstraint)constraint).setSupertype(literalBound);
        }
        return somethingChanged;
    }

    /*
     * Unable to fully structure code
     */
    private final List<SubtypeConstraint> getConstraintsWithNullableLowerBound(List<? extends Constraint> $this$getConstraintsWithNullableLowerBound, ConstraintPriority priority) {
        $this$filterIsInstance$iv = $this$getConstraintsWithNullableLowerBound;
        $i$f$filterIsInstance = false;
        var5_5 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SubtypeConstraint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            constraint = (SubtypeConstraint)element$iv$iv;
            $i$a$-filter-Solver$getConstraintsWithNullableLowerBound$1 = false;
            if (constraint.getPriority().compareTo((Enum)priority) > 0) ** GOTO lbl-1000
            $this$safeAs$iv = constraint.getSubtype();
            $i$f$safeAs = false;
            v0 = $this$safeAs$iv;
            if (!(v0 instanceof LiteralBound)) {
                v0 = null;
            }
            v1 = (LiteralBound)v0;
            if ((v1 != null ? v1.getState() : null) == State.UPPER) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final List<SubtypeConstraint> getConstraintsWithNotNullUpperBound(List<? extends Constraint> $this$getConstraintsWithNotNullUpperBound, ConstraintPriority priority) {
        $this$filterIsInstance$iv = $this$getConstraintsWithNotNullUpperBound;
        $i$f$filterIsInstance = false;
        var5_5 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SubtypeConstraint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            constraint = (SubtypeConstraint)element$iv$iv;
            $i$a$-filter-Solver$getConstraintsWithNotNullUpperBound$1 = false;
            if (constraint.getPriority().compareTo((Enum)priority) > 0) ** GOTO lbl-1000
            $this$safeAs$iv = constraint.getSupertype();
            $i$f$safeAs = false;
            v0 = $this$safeAs$iv;
            if (!(v0 instanceof LiteralBound)) {
                v0 = null;
            }
            v1 = (LiteralBound)v0;
            if ((v1 != null ? v1.getState() : null) == State.LOWER) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final TypeVariable getTypeVariableAsEqualsOrUpperBound(List<? extends Constraint> $this$getTypeVariableAsEqualsOrUpperBound) {
        for (Constraint constraint : $this$getTypeVariableAsEqualsOrUpperBound) {
            TypeVariableBound typeVariableBound;
            Constraint constraint2 = constraint;
            if (constraint2 instanceof SubtypeConstraint) {
                TypeVariable typeVariable;
                boolean bl;
                Object it;
                Object object;
                Object $this$safeAs$iv = ((SubtypeConstraint)constraint).getSupertype();
                boolean $i$f$safeAs = false;
                Object object2 = $this$safeAs$iv;
                if (!(object2 instanceof TypeVariableBound)) {
                    object2 = null;
                }
                if ((typeVariableBound = (TypeVariableBound)object2) != null && ($this$safeAs$iv = typeVariableBound.getTypeVariable()) != null) {
                    it = object = $this$safeAs$iv;
                    bl = false;
                    Object object3 = $i$f$safeAs = this.defaultStateProvider.defaultStateFor((TypeVariable)it) == State.LOWER ? object : null;
                    if ($i$f$safeAs != null) {
                        it = $i$f$safeAs;
                        boolean bl2 = false;
                        return it;
                    }
                }
                $this$safeAs$iv = ((SubtypeConstraint)constraint).getSubtype();
                boolean $i$f$safeAs32 = false;
                Object object4 = $this$safeAs$iv;
                if (!(object4 instanceof TypeVariableBound)) {
                    object4 = null;
                }
                if ((typeVariableBound = (TypeVariableBound)object4) == null || (typeVariable = typeVariableBound.getTypeVariable()) == null) continue;
                it = object = typeVariable;
                bl = false;
                Object $i$f$safeAs32 = this.defaultStateProvider.defaultStateFor((TypeVariable)it) == State.UPPER ? object : null;
                if ($i$f$safeAs32 == null) continue;
                it = $i$f$safeAs32;
                boolean bl3 = false;
                return it;
            }
            if (constraint2 instanceof EqualsConstraint) {
                TypeVariableBound typeVariableBound2;
                ConstraintBound $this$safeAs$iv = ((EqualsConstraint)constraint).getLeft();
                boolean $i$f$safeAs = false;
                ConstraintBound constraintBound = $this$safeAs$iv;
                if (!(constraintBound instanceof TypeVariableBound)) {
                    constraintBound = null;
                }
                if ((typeVariableBound2 = (TypeVariableBound)constraintBound) == null) {
                    $this$safeAs$iv = ((EqualsConstraint)constraint).getRight();
                    $i$f$safeAs = false;
                    ConstraintBound constraintBound2 = $this$safeAs$iv;
                    if (!(constraintBound2 instanceof TypeVariableBound)) {
                        constraintBound2 = null;
                    }
                    typeVariableBound2 = (TypeVariableBound)constraintBound2;
                }
                if ((typeVariableBound = typeVariableBound2) == null) continue;
                TypeVariableBound it = typeVariableBound;
                boolean bl = false;
                return it.getTypeVariable();
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    private final void filterOutConstraintsWithUnusedState(List<Constraint> $this$filterOutConstraintsWithUnusedState) {
        $this$filterOutConstraintsWithUnusedState.removeIf(arg_0 -> Solver.filterOutConstraintsWithUnusedState$lambda$1(Solver::filterOutConstraintsWithUnusedState$lambda$0, arg_0));
    }

    private static final boolean cleanConstraints$lambda$0(Constraint constraint) {
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        return constraint instanceof SubtypeConstraint && ((SubtypeConstraint)constraint).getSubtype() instanceof LiteralBound && ((SubtypeConstraint)constraint).getSupertype() instanceof LiteralBound;
    }

    private static final boolean cleanConstraints$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filterOutConstraintsWithUnusedState$lambda$0(Constraint constraint) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        Constraint constraint2 = constraint;
        if (constraint2 instanceof SubtypeConstraint) {
            bl = ConstraintKt.isUnused(((SubtypeConstraint)constraint).getSubtype()) || ConstraintKt.isUnused(((SubtypeConstraint)constraint).getSupertype());
        } else if (constraint2 instanceof EqualsConstraint) {
            bl = ConstraintKt.isUnused(((EqualsConstraint)constraint).getLeft()) || ConstraintKt.isUnused(((EqualsConstraint)constraint).getRight());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final boolean filterOutConstraintsWithUnusedState$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

