/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing.inference.nullability;

import com.intellij.psi.PsiElement;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.psi.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundType;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypeEnhancer;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypeImpl;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypeLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypesKt;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.InferenceContext;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.State;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeParameter;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.WithForcedStateBoundType;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacadeKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.EnhancedNullabilityInfo;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0002J1\u0010\u0017\u001a\u0004\u0018\u00010\u0015*\u00020\t2 \u0010\u0018\u001a\u001c\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0019H\u0082\bJ\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0015*\u00020\tH\u0002J\u001c\u0010\u001d\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/nullability/NullabilityBoundTypeEnhancer;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundTypeEnhancer;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "<init>", "(Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;)V", "enhance", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "boundType", "inferenceContext", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/InferenceContext;", "enhanceCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "enhanceKotlinType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "allowLowerEnhancement", "", "smartCastEnhancement", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/State;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "analyzeExpressionUponTheTypeInfo", "analyzer", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getExternallyAnnotatedForcedState", "isExternallyAnnotatedNotNull", "dataFlowInfo", "dataFlowValue", "kotlin.j2k.k1.new.post-processing"})
@SourceDebugExtension(value={"SMAP\nNullabilityBoundTypeEnhancer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NullabilityBoundTypeEnhancer.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/inference/nullability/NullabilityBoundTypeEnhancer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n94#1,7:123\n94#1,7:130\n3590#2,7:116\n*S KotlinDebug\n*F\n+ 1 NullabilityBoundTypeEnhancer.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/inference/nullability/NullabilityBoundTypeEnhancer\n*L\n88#1:123,7\n103#1:130,7\n68#1:116,7\n*E\n"})
public final class NullabilityBoundTypeEnhancer
extends BoundTypeEnhancer {
    @NotNull
    private final ResolutionFacade resolutionFacade;

    public NullabilityBoundTypeEnhancer(@NotNull ResolutionFacade resolutionFacade) {
        Intrinsics.checkNotNullParameter((Object)resolutionFacade, (String)"resolutionFacade");
        this.resolutionFacade = resolutionFacade;
    }

    @Override
    @NotNull
    public BoundType enhance(@NotNull KtExpression expression, @NotNull BoundType boundType, @NotNull InferenceContext inferenceContext) {
        BoundType boundType2;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)boundType, (String)"boundType");
        Intrinsics.checkNotNullParameter((Object)inferenceContext, (String)"inferenceContext");
        if (IfThenUtilsKt.isNullExpression(expression)) {
            boundType2 = new WithForcedStateBoundType(boundType, State.UPPER);
        } else if (expression instanceof KtCallExpression) {
            boundType2 = this.enhanceCallExpression((KtCallExpression)expression, boundType, inferenceContext);
        } else if (expression instanceof KtQualifiedExpression && ((KtQualifiedExpression)expression).getSelectorExpression() instanceof KtCallExpression) {
            KtExpression ktExpression = ((KtQualifiedExpression)expression).getSelectorExpression();
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            boundType2 = this.enhanceCallExpression((KtCallExpression)ktExpression, boundType, inferenceContext);
        } else {
            boundType2 = expression instanceof KtNameReferenceExpression ? BoundTypesKt.enhanceWith(boundType, this.smartCastEnhancement((KtReferenceExpression)expression)) : (expression instanceof KtLambdaExpression ? (BoundType)new WithForcedStateBoundType(boundType, State.LOWER) : boundType);
        }
        return boundType2;
    }

    private final BoundType enhanceCallExpression(KtCallExpression expression, BoundType boundType, InferenceContext inferenceContext) {
        ResolvedCall resolvedCall = ExtendedResolutionApiKt.resolveToCall$default((KtElement)expression, this.resolutionFacade, null, 2, null);
        if ((resolvedCall != null ? resolvedCall.getCandidateDescriptor() : null) instanceof ConstructorDescriptor) {
            return new WithForcedStateBoundType(boundType, State.LOWER);
        }
        KtExpression ktExpression = expression.getCalleeExpression();
        if (ktExpression == null || (ktExpression = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression))) == null || (ktExpression = ktExpression.resolve()) == null) {
            return boundType;
        }
        KtExpression resolved = ktExpression;
        if (inferenceContext.isInConversionScope((PsiElement)resolved)) {
            return boundType;
        }
        return BoundTypesKt.enhanceWith(boundType, this.getExternallyAnnotatedForcedState((KtExpression)expression));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BoundType enhanceKotlinType(@NotNull KotlinType type2, @NotNull BoundType boundType, boolean allowLowerEnhancement, @NotNull InferenceContext inferenceContext) {
        void other$iv;
        void $this$zip$iv;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)boundType, (String)"boundType");
        Intrinsics.checkNotNullParameter((Object)inferenceContext, (String)"inferenceContext");
        if (type2.getArguments().size() != boundType.getTypeParameters().size()) {
            return boundType;
        }
        Iterable iterable = boundType.getTypeParameters();
        Iterable iterable2 = type2.getArguments();
        BoundTypeLabel boundTypeLabel = boundType.getLabel();
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<TypeParameter> list$iv = new ArrayList<TypeParameter>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void typeParameter;
            void typeArgument;
            TypeProjection typeProjection = (TypeProjection)second$iv.next();
            TypeParameter typeParameter2 = (TypeParameter)first$iv.next();
            ArrayList<TypeParameter> arrayList = list$iv;
            boolean bl = false;
            KotlinType kotlinType = typeArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            arrayList.add(new TypeParameter(this.enhanceKotlinType(kotlinType, typeParameter.getBoundType(), allowLowerEnhancement, inferenceContext), typeParameter.getVariance()));
        }
        List list2 = list$iv;
        BoundTypeLabel boundTypeLabel2 = boundTypeLabel;
        BoundTypeImpl inner = new BoundTypeImpl(boundTypeLabel2, list2);
        State enhancement = type2.isMarkedNullable() ? State.UPPER : (allowLowerEnhancement ? State.LOWER : null);
        return BoundTypesKt.enhanceWith(inner, enhancement);
    }

    /*
     * WARNING - void declaration
     */
    private final State smartCastEnhancement(KtReferenceExpression $this$smartCastEnhancement) {
        State state;
        void this_$iv;
        NullabilityBoundTypeEnhancer nullabilityBoundTypeEnhancer = this;
        KtExpression $this$analyzeExpressionUponTheTypeInfo$iv = (KtExpression)$this$smartCastEnhancement;
        boolean $i$f$analyzeExpressionUponTheTypeInfo = false;
        BindingContext bindingContext$iv = ExtendedResolutionApiKt.analyze$default((KtElement)$this$analyzeExpressionUponTheTypeInfo$iv, this_$iv.resolutionFacade, null, 2, null);
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$analyzeExpressionUponTheTypeInfo$iv, (BindingContext)bindingContext$iv);
        if (kotlinType == null) {
            state = null;
        } else {
            KotlinType type$iv = kotlinType;
            DataFlowValue dataFlowValue$iv = ResolutionFacadeKt.getDataFlowValueFactory(this_$iv.resolutionFacade).createDataFlowValue($this$analyzeExpressionUponTheTypeInfo$iv, type$iv, bindingContext$iv, (DeclarationDescriptor)this_$iv.resolutionFacade.getModuleDescriptor());
            KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)bindingContext$iv.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)$this$analyzeExpressionUponTheTypeInfo$iv);
            if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getDataFlowInfo()) == null) {
                state = null;
            } else {
                void dataFlowInfo;
                KotlinTypeInfo dataFlowInfo$iv;
                KotlinTypeInfo kotlinTypeInfo2 = dataFlowInfo$iv = kotlinTypeInfo;
                DataFlowValue dataFlowValue = dataFlowValue$iv;
                boolean bl = false;
                Option option = dataFlowInfo.getCompleteNullabilityInfo().get((Object)dataFlowValue);
                state = (option != null ? (Nullability)option.getOrNull() : null) == Nullability.NOT_NULL ? State.LOWER : null;
            }
        }
        return state;
    }

    private final State analyzeExpressionUponTheTypeInfo(KtExpression $this$analyzeExpressionUponTheTypeInfo, Function3<? super DataFlowValue, ? super DataFlowInfo, ? super KotlinType, ? extends State> analyzer) {
        boolean $i$f$analyzeExpressionUponTheTypeInfo = false;
        BindingContext bindingContext = ExtendedResolutionApiKt.analyze$default((KtElement)$this$analyzeExpressionUponTheTypeInfo, this.resolutionFacade, null, 2, null);
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$analyzeExpressionUponTheTypeInfo, (BindingContext)bindingContext);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        DataFlowValue dataFlowValue = ResolutionFacadeKt.getDataFlowValueFactory(this.resolutionFacade).createDataFlowValue($this$analyzeExpressionUponTheTypeInfo, type2, bindingContext, (DeclarationDescriptor)this.resolutionFacade.getModuleDescriptor());
        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)bindingContext.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)$this$analyzeExpressionUponTheTypeInfo);
        if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getDataFlowInfo()) == null) {
            return null;
        }
        KotlinTypeInfo dataFlowInfo = kotlinTypeInfo;
        return (State)((Object)analyzer.invoke((Object)dataFlowValue, (Object)dataFlowInfo, (Object)type2));
    }

    /*
     * WARNING - void declaration
     */
    private final State getExternallyAnnotatedForcedState(KtExpression $this$getExternallyAnnotatedForcedState) {
        State state;
        void this_$iv;
        NullabilityBoundTypeEnhancer nullabilityBoundTypeEnhancer = this;
        KtExpression $this$analyzeExpressionUponTheTypeInfo$iv = $this$getExternallyAnnotatedForcedState;
        boolean $i$f$analyzeExpressionUponTheTypeInfo = false;
        BindingContext bindingContext$iv = ExtendedResolutionApiKt.analyze$default((KtElement)$this$analyzeExpressionUponTheTypeInfo$iv, this_$iv.resolutionFacade, null, 2, null);
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$analyzeExpressionUponTheTypeInfo$iv, (BindingContext)bindingContext$iv);
        if (kotlinType == null) {
            state = null;
        } else {
            KotlinType type$iv = kotlinType;
            DataFlowValue dataFlowValue$iv = ResolutionFacadeKt.getDataFlowValueFactory(this_$iv.resolutionFacade).createDataFlowValue($this$analyzeExpressionUponTheTypeInfo$iv, type$iv, bindingContext$iv, (DeclarationDescriptor)this_$iv.resolutionFacade.getModuleDescriptor());
            KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)bindingContext$iv.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)$this$analyzeExpressionUponTheTypeInfo$iv);
            if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getDataFlowInfo()) == null) {
                state = null;
            } else {
                void type2;
                KotlinTypeInfo dataFlowInfo$iv = kotlinTypeInfo;
                KotlinType kotlinType2 = type$iv;
                KotlinTypeInfo kotlinTypeInfo2 = dataFlowInfo$iv;
                DataFlowValue dataFlowValue = dataFlowValue$iv;
                boolean bl = false;
                if (!KotlinTypeKt.isNullable((KotlinType)type2)) {
                    state = State.LOWER;
                } else {
                    void dataFlowInfo;
                    Option option = dataFlowInfo.getCompleteNullabilityInfo().get((Object)dataFlowValue);
                    state = (option != null ? (Nullability)option.getOrNull() : null) == Nullability.NOT_NULL ? State.LOWER : (this.isExternallyAnnotatedNotNull((KotlinType)type2, (DataFlowInfo)dataFlowInfo, dataFlowValue) ? State.LOWER : null);
                }
            }
        }
        return state;
    }

    private final boolean isExternallyAnnotatedNotNull(KotlinType $this$isExternallyAnnotatedNotNull, DataFlowInfo dataFlowInfo, DataFlowValue dataFlowValue) {
        EnhancedNullabilityInfo enhancedNullabilityInfo = JavaNullabilityCheckerKt.mustNotBeNull((KotlinType)$this$isExternallyAnnotatedNotNull);
        return (enhancedNullabilityInfo != null ? enhancedNullabilityInfo.isFromJava() : false) && dataFlowInfo.getStableNullability(dataFlowValue).canBeNull();
    }
}

