/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.k1.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManagerKt;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.jvm.shared.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J\b\u0010\u000e\u001a\u00020\u000fH\u0016J#\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0094\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/inspections/AddKotlinLibQuickFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;Lcom/intellij/openapi/roots/DependencyScope;)V", "getLibraryDescriptor", "Lorg/jetbrains/kotlin/idea/jvm/k1/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "startInWriteAction", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "currentFile", "Lcom/intellij/psi/PsiFile;", "MavenExternalLibraryDescriptor", "kotlin.jvm.k1"})
public abstract class AddKotlinLibQuickFix
extends KotlinQuickFixAction<KtElement> {
    @NotNull
    private final LibraryJarDescriptor libraryJarDescriptor;
    @NotNull
    private final DependencyScope scope;

    public AddKotlinLibQuickFix(@NotNull KtElement element, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull DependencyScope scope) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)libraryJarDescriptor), (String)"libraryJarDescriptor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super((PsiElement)element);
        this.libraryJarDescriptor = libraryJarDescriptor;
        this.scope = scope;
    }

    @NotNull
    protected abstract MavenExternalLibraryDescriptor getLibraryDescriptor(@NotNull Module var1);

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KtElement ktElement = (KtElement)this.getElement();
            if (ktElement == null) {
                return;
            }
            KtElement element = ktElement;
            Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(element.getContainingFile().getVirtualFile());
            if (module == null) {
                return;
            }
            Module module2 = module;
            KotlinBuildSystemDependencyManager kotlinBuildSystemDependencyManager = KotlinBuildSystemDependencyManager.Companion.findApplicableConfigurator(module2);
            if (kotlinBuildSystemDependencyManager == null) {
                return;
            }
            KotlinBuildSystemDependencyManager configurator = kotlinBuildSystemDependencyManager;
            DependencyScope dependencyScope = OrderEntryFix.suggestScopeByLocation((Module)module2, (PsiElement)((PsiElement)element));
            Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"suggestScopeByLocation(...)");
            DependencyScope scopeOverride = dependencyScope;
            configurator.addDependency(module2, KotlinBuildSystemDependencyManagerKt.withScope(this.getLibraryDescriptor(module2), scopeOverride));
            VirtualFile virtualFile = configurator.getBuildScriptFile(module2);
            if (virtualFile == null) break block3;
            VirtualFile it = virtualFile;
            boolean bl = false;
            NotificationMessageCollector notificationMessageCollector = NotificationMessageCollector.Companion.create(project);
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)it.getPath(), (String)"getPath(...)");
            notificationMessageCollector.addMessage(KotlinJvmBundle.message("text.was.modified", objectArray)).showNotification();
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "groupId", "", "artifactId", "version", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLibraryClassesRoots", "", "Companion", "kotlin.jvm.k1"})
    public static final class MavenExternalLibraryDescriptor
    extends ExternalLibraryDescriptor {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private MavenExternalLibraryDescriptor(String groupId, String artifactId, String version) {
            super(groupId, artifactId, version, version);
        }

        @NotNull
        public List<String> getLibraryClassesRoots() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ MavenExternalLibraryDescriptor(String groupId, String artifactId, String version, DefaultConstructorMarker $constructor_marker) {
            this(groupId, artifactId, version);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/jvm/k1/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "groupId", "", "artifactId", "version", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "kotlin.jvm.k1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MavenExternalLibraryDescriptor create(@NotNull String groupId, @NotNull String artifactId, @NotNull IdeKotlinVersion version) {
                Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                String artifactVersion = version.getArtifactVersion();
                return new MavenExternalLibraryDescriptor(groupId, artifactId, artifactVersion, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

