/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.k1.run;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/run/KotlinFE10MainFunctionDetector;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector;", "<init>", "()V", "isMain", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "configuration", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector$Configuration;", "isParameterNumberSuitsForMain", "parametersCount", "", "isTopLevel", "hasAnnotationWithExactNumberOfArguments", "number", "kotlin.jvm.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinFE10MainFunctionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFE10MainFunctionDetector.kt\norg/jetbrains/kotlin/idea/jvm/k1/run/KotlinFE10MainFunctionDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1807#2,3:60\n*S KotlinDebug\n*F\n+ 1 KotlinFE10MainFunctionDetector.kt\norg/jetbrains/kotlin/idea/jvm/k1/run/KotlinFE10MainFunctionDetector\n*L\n58#1:60,3\n*E\n"})
public final class KotlinFE10MainFunctionDetector
implements KotlinMainFunctionDetector {
    @Override
    public boolean isMain(@NotNull KtNamedFunction function, @NotNull KotlinMainFunctionDetector.Configuration configuration2) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        if (function.isLocal()) {
            return false;
        }
        int parametersCount = function.getValueParameters().size();
        if (function.getReceiverTypeReference() != null) {
            ++parametersCount;
        }
        if (!this.isParameterNumberSuitsForMain(parametersCount, function.isTopLevel())) {
            return false;
        }
        if (!function.getTypeParameters().isEmpty()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)"main", (Object)function.getName()) && !this.hasAnnotationWithExactNumberOfArguments(function, 1)) {
            return false;
        }
        if (configuration2.getCheckJvmStaticAnnotation() && !function.isTopLevel() && !this.hasAnnotationWithExactNumberOfArguments(function, 0)) {
            return false;
        }
        LanguageVersionSettings languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)function);
        MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(languageVersionSettings, KotlinFE10MainFunctionDetector::isMain$lambda$0);
        return mainFunctionDetector.isMain(function, configuration2.getCheckJvmStaticAnnotation(), configuration2.getAllowParameterless());
    }

    private final boolean isParameterNumberSuitsForMain(int parametersCount, boolean isTopLevel) {
        return switch (parametersCount) {
            case 1 -> true;
            case 0 -> isTopLevel;
            default -> false;
        };
    }

    private final boolean hasAnnotationWithExactNumberOfArguments(KtNamedFunction function, int number) {
        boolean bl;
        block3: {
            List list2 = function.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    if (!(it.getValueArguments().size() == number)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final FunctionDescriptor isMain$lambda$0(KtNamedFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ResolutionUtils.resolveToDescriptorIfAny$default(it, null, 1, null);
    }
}

