/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.k1.scratch.compile;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \t2\u00020\u0001:\u0003\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor;", "", "<init>", "()V", "process", "Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$Result;", "expressions", "", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "Companion", "KtSourceProcessor", "Result", "kotlin.jvm.k1"})
@SourceDebugExtension(value={"SMAP\nKtScratchSourceFileProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtScratchSourceFileProcessor.kt\norg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1915#2,2:124\n*S KotlinDebug\n*F\n+ 1 KtScratchSourceFileProcessor.kt\norg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor\n*L\n29#1:124,2\n*E\n"})
public final class KtScratchSourceFileProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String GENERATED_OUTPUT_PREFIX = "##scratch##generated##";
    @NotNull
    public static final String LINES_INFO_MARKER = "end##";
    @NotNull
    public static final String END_OUTPUT_MARKER = "end##!@#%^&*";
    @NotNull
    public static final String OBJECT_NAME = "ScratchFileRunnerGenerated";
    @NotNull
    public static final String INSTANCE_NAME = "instanceScratchFileRunner";
    @NotNull
    public static final String PACKAGE_NAME = "org.jetbrains.kotlin.idea.scratch.generated";
    @NotNull
    public static final String GET_RES_FUN_NAME_PREFIX = "generated_get_instance_res";

    @NotNull
    public final Result process(@NotNull List<ScratchExpression> expressions) {
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        KtSourceProcessor sourceProcessor = new KtSourceProcessor();
        Iterable $this$forEach$iv = expressions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScratchExpression it = (ScratchExpression)element$iv;
            boolean bl = false;
            sourceProcessor.process(it);
        }
        String codeResult = "\n                package org.jetbrains.kotlin.idea.scratch.generated\n\n                " + CollectionsKt.joinToString$default((Iterable)sourceProcessor.getImports(), (CharSequence)"\n", null, null, (int)0, null, KtScratchSourceFileProcessor::process$lambda$1, (int)30, null) + "\n\n                object ScratchFileRunnerGenerated {\n                    class ScratchFileRunnerGenerated {\n                        " + sourceProcessor.getClassBuilder() + "\n                    }\n\n                    @JvmStatic fun main(args: Array<String>) {\n                        val instanceScratchFileRunner = ScratchFileRunnerGenerated()\n                        " + sourceProcessor.getObjectBuilder() + "\n                        println(\"end##!@#%^&*\")\n                    }\n                }\n            ";
        return new Result.OK("org.jetbrains.kotlin.idea.scratch.generated.ScratchFileRunnerGenerated", codeResult);
    }

    private static final CharSequence process$lambda$1(KtImportDirective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$Companion;", "", "<init>", "()V", "GENERATED_OUTPUT_PREFIX", "", "LINES_INFO_MARKER", "END_OUTPUT_MARKER", "OBJECT_NAME", "INSTANCE_NAME", "PACKAGE_NAME", "GET_RES_FUN_NAME_PREFIX", "kotlin.jvm.k1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u0014*\u00060\u0005j\u0002`\u00062\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J \u0010!\u001a\n \"*\u0004\u0018\u00010\u00050\u0005*\u00060\u0005j\u0002`\u00062\u0006\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\n \"*\u0004\u0018\u00010\u00050\u0005*\u00060\u0005j\u0002`\u00062\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010&\u001a\n \"*\u0004\u0018\u00010\u00050\u0005*\u00060\u0005j\u0002`\u0006H\u0002R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\t\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$KtSourceProcessor;", "", "<init>", "()V", "classBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getClassBuilder", "()Ljava/lang/StringBuilder;", "objectBuilder", "getObjectBuilder", "imports", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lkotlin/collections/ArrayList;", "getImports", "()Ljava/util/ArrayList;", "resCount", "", "process", "", "expression", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "processDeclaration", "e", "c", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "processDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "processExpression", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "appendLineInfo", "println", "kotlin.jvm.PlatformType", "str", "", "printlnObj", "newLine", "kotlin.jvm.k1"})
    @SourceDebugExtension(value={"SMAP\nKtScratchSourceFileProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtScratchSourceFileProcessor.kt\norg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$KtSourceProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1642#2,10:124\n1915#2:134\n1916#2:136\n1652#2:137\n1915#2,2:138\n1915#2,2:140\n1#3:135\n*S KotlinDebug\n*F\n+ 1 KtScratchSourceFileProcessor.kt\norg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$KtSourceProcessor\n*L\n83#1:124,10\n83#1:134\n83#1:136\n83#1:137\n84#1:138,2\n93#1:140,2\n83#1:135\n*E\n"})
    public static final class KtSourceProcessor {
        @NotNull
        private final StringBuilder classBuilder = new StringBuilder();
        @NotNull
        private final StringBuilder objectBuilder = new StringBuilder();
        @NotNull
        private final ArrayList<KtImportDirective> imports = new ArrayList();
        private int resCount;

        @NotNull
        public final StringBuilder getClassBuilder() {
            return this.classBuilder;
        }

        @NotNull
        public final StringBuilder getObjectBuilder() {
            return this.objectBuilder;
        }

        @NotNull
        public final ArrayList<KtImportDirective> getImports() {
            return this.imports;
        }

        public final void process(@NotNull ScratchExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            PsiElement psiElement = expression.getElement();
            if (psiElement instanceof KtDestructuringDeclaration) {
                this.processDestructuringDeclaration(expression, (KtDestructuringDeclaration)psiElement);
            } else if (psiElement instanceof KtVariableDeclaration) {
                this.processDeclaration(expression, (KtDeclaration)psiElement);
            } else if (psiElement instanceof KtFunction) {
                this.processDeclaration(expression, (KtDeclaration)psiElement);
            } else if (psiElement instanceof KtClassOrObject) {
                this.processDeclaration(expression, (KtDeclaration)psiElement);
            } else if (psiElement instanceof KtImportDirective) {
                this.imports.add((KtImportDirective)psiElement);
            } else if (psiElement instanceof KtExpression) {
                this.processExpression(expression, (KtExpression)psiElement);
            }
        }

        private final void processDeclaration(ScratchExpression e, KtDeclaration c) {
            StringBuilder stringBuilder = this.classBuilder.append(c.getText());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            this.newLine(stringBuilder);
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(c, null, 1, null);
            if (declarationDescriptor == null) {
                return;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            Object[] objectArray = new Object[]{descriptor2};
            RenderingContext context2 = RenderingContext.Companion.of(objectArray);
            this.println(this.objectBuilder, Renderers.COMPACT.render(descriptor2, context2));
            this.appendLineInfo(this.objectBuilder, e);
        }

        /*
         * WARNING - void declaration
         */
        private final void processDestructuringDeclaration(ScratchExpression e, KtDestructuringDeclaration c) {
            void $this$mapNotNullTo$iv$iv;
            List list2 = c.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterator iterator2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach3 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                DeclarationDescriptor it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                KtDestructuringDeclarationEntry it = (KtDestructuringDeclarationEntry)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if ((UnderscoreUtilKt.isSingleUnderscore((KtNamedDeclaration)((KtNamedDeclaration)it)) ? null : ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)it, null, 1, null)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List entries = (List)destination$iv$iv;
            Iterable $this$forEach$iv = entries;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                Object[] $i$f$forEach3 = new Object[]{it};
                RenderingContext context2 = RenderingContext.Companion.of($i$f$forEach3);
                String rendered = Renderers.COMPACT.render(it, context2);
                StringBuilder stringBuilder = this.classBuilder.append(rendered);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                this.newLine(stringBuilder);
                this.println(this.objectBuilder, rendered);
            }
            this.appendLineInfo(this.objectBuilder, e);
            StringBuilder stringBuilder = this.classBuilder.append("init {");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            this.newLine(stringBuilder);
            StringBuilder stringBuilder2 = this.classBuilder.append(c.getText());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            this.newLine(stringBuilder2);
            $this$forEach$iv = entries;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                StringBuilder stringBuilder3 = this.classBuilder.append("this." + it.getName() + " = " + it.getName());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                this.newLine(stringBuilder3);
            }
            StringBuilder stringBuilder4 = this.classBuilder.append("}");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            this.newLine(stringBuilder4);
        }

        private final void processExpression(ScratchExpression e, KtExpression expr) {
            String resName = KtScratchSourceFileProcessor.GET_RES_FUN_NAME_PREFIX + this.resCount;
            StringBuilder stringBuilder = this.classBuilder.append("fun " + resName + "() = run { " + expr.getText() + " }");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            this.newLine(stringBuilder);
            this.printlnObj(this.objectBuilder, "instanceScratchFileRunner." + resName + "()");
            this.appendLineInfo(this.objectBuilder, e);
            ++this.resCount;
        }

        private final void appendLineInfo(StringBuilder $this$appendLineInfo, ScratchExpression e) {
            this.println($this$appendLineInfo, KtScratchSourceFileProcessor.LINES_INFO_MARKER + e.getLineStart() + "|" + e.getLineEnd());
        }

        private final StringBuilder println(StringBuilder $this$println, String str) {
            StringBuilder stringBuilder = $this$println.append("println(\"##scratch##generated##" + str + "\")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            return this.newLine(stringBuilder);
        }

        private final StringBuilder printlnObj(StringBuilder $this$printlnObj, String str) {
            StringBuilder stringBuilder = $this$printlnObj.append("println(\"##scratch##generated##${" + str + "}\")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            return this.newLine(stringBuilder);
        }

        private final StringBuilder newLine(StringBuilder $this$newLine) {
            return $this$newLine.append("\n");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$Result;", "", "<init>", "()V", "Error", "OK", "Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$Result$Error;", "Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "kotlin.jvm.k1"})
    public static abstract sealed class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$Result$Error;", "Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$Result;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "kotlin.jvm.k1"})
        public static final class Error
        extends Result {
            @NotNull
            private final String message;

            public Error(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                super(null);
                this.message = message2;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchSourceFileProcessor$Result;", "mainClassName", "", "code", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getMainClassName", "()Ljava/lang/String;", "getCode", "kotlin.jvm.k1"})
        public static final class OK
        extends Result {
            @NotNull
            private final String mainClassName;
            @NotNull
            private final String code;

            public OK(@NotNull String mainClassName, @NotNull String code) {
                Intrinsics.checkNotNullParameter((Object)mainClassName, (String)"mainClassName");
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                super(null);
                this.mainClassName = mainClassName;
                this.code = code;
            }

            @NotNull
            public final String getMainClassName() {
                return this.mainClassName;
            }

            @NotNull
            public final String getCode() {
                return this.code;
            }
        }
    }
}

