/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.framework;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.projectConfiguration.JavaRuntimeLibraryDescription;

public class JavaRuntimePresentationProvider
extends LibraryPresentationProvider<LibraryVersionProperties> {
    private static final Pattern KOTLIN_LIBRARY_JAR_PATTERN = Pattern.compile("kotlinx?-(reflect|stdlib-jdk.|test|atomicfu|coroutines|datetime|serialization)-.*\\.jar");

    public static JavaRuntimePresentationProvider getInstance() {
        return (JavaRuntimePresentationProvider)((Object)LibraryPresentationProvider.EP_NAME.findExtension(JavaRuntimePresentationProvider.class));
    }

    protected JavaRuntimePresentationProvider() {
        super(JavaRuntimeLibraryDescription.Companion.getKOTLIN_JAVA_RUNTIME_KIND());
    }

    @Nullable
    public Icon getIcon(@Nullable LibraryVersionProperties properties) {
        return KotlinIcons.SMALL_LOGO;
    }

    @Nullable
    public LibraryVersionProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            JavaRuntimePresentationProvider.$$$reportNull$$$0(0);
        }
        if (classesRoots.size() > 5) {
            return null;
        }
        IdeKotlinVersion version = KotlinJvmStdlibDetectorFacility.INSTANCE.getStdlibVersion(classesRoots);
        if (version != null) {
            return new LibraryVersionProperties(version.getArtifactVersion());
        }
        IdeKotlinVersion kotlinLibraryVersion = JavaRuntimePresentationProvider.getKotlinLibraryVersion(classesRoots);
        if (kotlinLibraryVersion != null) {
            return new LibraryVersionProperties(kotlinLibraryVersion.getArtifactVersion());
        }
        return null;
    }

    private static IdeKotlinVersion getKotlinLibraryVersion(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            JavaRuntimePresentationProvider.$$$reportNull$$$0(1);
        }
        for (VirtualFile root : roots) {
            String name2 = root.getName();
            if (!KOTLIN_LIBRARY_JAR_PATTERN.matcher(name2).matches()) continue;
            IdeKotlinVersion kotlinVersion = IdeKotlinVersion.fromManifest(root);
            return kotlinVersion;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/jvm/shared/framework/JavaRuntimePresentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getKotlinLibraryVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

