/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptRelatedModuleNameFile;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchFileOptions;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchFileOptionsByFile;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rH&J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001f\u0010\u001d\u001a\u00020\u00112\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001f\u00a2\u0006\u0002\b J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0010\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010%\u001a\u00020&J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010'\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "currentModule", "Lcom/intellij/openapi/module/Module;", "getCurrentModule", "()Lcom/intellij/openapi/module/Module;", "setModule", "", "module", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "options", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchFileOptions;", "getOptions", "()Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchFileOptions;", "saveOptions", "update", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getExpressions", "", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "getExpressionAtLine", "line", "", "psiFile", "kotlin.jvm.shared"})
@SourceDebugExtension(value={"SMAP\nScratchFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFile.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n1#2:98\n137#3:99\n30#4,2:100\n30#4,2:102\n*S KotlinDebug\n*F\n+ 1 ScratchFile.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile\n*L\n36#1:99\n39#1:100,2\n42#1:102,2\n*E\n"})
public abstract class ScratchFile {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;

    public ScratchFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.project = project;
        this.virtualFile = virtualFile;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Nullable
    public final Module getCurrentModule() {
        Module module;
        String string = ScriptRelatedModuleNameFile.Companion.get(this.project, this.virtualFile);
        if (string != null) {
            String it = string;
            boolean bl = false;
            module = ModuleManager.Companion.getInstance(this.project).findModuleByName(it);
        } else {
            module = null;
        }
        return module;
    }

    public abstract void setModule(@Nullable Module var1);

    @Nullable
    public final PsiFile getPsiFile() {
        return (PsiFile)ActionsKt.runReadAction(() -> ScratchFile.getPsiFile$lambda$0(this));
    }

    @Nullable
    public final KtFile getKtFile() {
        PsiFile $this$safeAs$iv = this.getPsiFile();
        boolean $i$f$safeAs = false;
        PsiFile psiFile = $this$safeAs$iv;
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        return (KtFile)psiFile;
    }

    @NotNull
    public final ScratchFileOptions getOptions() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ScratchFileOptionsByFile> serviceClass$iv = ScratchFileOptionsByFile.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ScratchFileOptions scratchFileOptions = (ScratchFileOptions)((ScratchFileOptionsByFile)object).get(this.virtualFile);
        if (scratchFileOptions == null) {
            scratchFileOptions = new ScratchFileOptions(false, false, false, 7, null);
        }
        return scratchFileOptions;
    }

    public final void saveOptions(@NotNull Function1<? super ScratchFileOptions, ScratchFileOptions> update2) {
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ScratchFileOptionsByFile> serviceClass$iv = ScratchFileOptionsByFile.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((ScratchFileOptionsByFile)object).set(this.virtualFile, update2.invoke((Object)this.getOptions()));
    }

    @NotNull
    public final List<ScratchExpression> getExpressions() {
        return (List)ActionsKt.runReadAction(() -> ScratchFile.getExpressions$lambda$0(this));
    }

    @Nullable
    public final ScratchExpression getExpressionAtLine(int line) {
        Object v1;
        block1: {
            Iterable iterable = this.getExpressions();
            for (Object t : iterable) {
                ScratchExpression it = (ScratchExpression)t;
                boolean bl = false;
                int n = it.getLineStart();
                boolean bl2 = line <= it.getLineEnd() ? n <= line : false;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final List<ScratchExpression> getExpressions(PsiFile psiFile) {
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getLastCommittedDocument(psiFile);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Document doc = document;
        int line = 0;
        ArrayList<ScratchExpression> result2 = new ArrayList<ScratchExpression>();
        while (line < doc.getLineCount()) {
            KtElement ktElement;
            PsiElement element;
            int start2;
            block9: {
                block8: {
                    start2 = 0;
                    start2 = doc.getLineStartOffset(line);
                    element = psiFile.findElementAt(start2);
                    if (element instanceof PsiWhiteSpace) break block8;
                    if (!(element instanceof PsiComment)) break block9;
                }
                Class[] classArray = new Class[]{PsiWhiteSpace.class, PsiComment.class};
                PsiElement psiElement = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])classArray);
                start2 = psiElement != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement) : start2;
                element = psiFile.findElementAt(start2);
            }
            if (element != null) {
                PsiElement it;
                boolean bl = false;
                Class[] classArray = new Class[]{KtImportDirective.class, KtDeclaration.class};
                ktElement = (KtElement)KotlinPsiUtils.getTopmostElementAtOffset(it, start2, classArray);
            } else {
                ktElement = null;
            }
            element = (PsiElement)ktElement;
            if (element == null) {
                ++line;
                continue;
            }
            ScratchExpression scratchExpression = new ScratchExpression(element, doc.getLineNumber(PsiUtilsKt.getStartOffset((PsiElement)element)), doc.getLineNumber(PsiUtilsKt.getEndOffset((PsiElement)element)));
            result2.add(scratchExpression);
            line = scratchExpression.getLineEnd() + 1;
        }
        return result2;
    }

    private static final PsiFile getPsiFile$lambda$0(ScratchFile this$0) {
        return PhysicalFileSystemUtilsKt.toPsiFile(this$0.virtualFile, this$0.project);
    }

    private static final List getExpressions$lambda$0(ScratchFile this$0) {
        Object object;
        block3: {
            block2: {
                object = this$0.getPsiFile();
                if (object == null) break block2;
                PsiFile it = object;
                boolean bl = false;
                List<ScratchExpression> list2 = this$0.getExpressions(it);
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

