/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchFileEditorWithPreview;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchFileEditorWithPreviewKt;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0007\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0005*\u00020\u0015\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u0016"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "printDebugMessage", "", "str", "", "isKotlinScratch", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "getScratchEditorForSelectedFile", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchFileEditorWithPreview;", "fileManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "virtualFile", "getScratchFile", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "updateToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "kotlin.jvm.shared"})
public final class ScratchUtilsKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    public static final void printDebugMessage(@NotNull Logger $this$printDebugMessage, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)$this$printDebugMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if ($this$printDebugMessage.isDebugEnabled()) {
            $this$printDebugMessage.debug("SCRATCH: " + str);
        }
    }

    public static final boolean isKotlinScratch(@NotNull VirtualFile $this$isKotlinScratch) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinScratch, (String)"<this>");
        return Intrinsics.areEqual((Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX, (Object)$this$isKotlinScratch.getExtension()) && ScratchFileService.getInstance().getRootType($this$isKotlinScratch) instanceof ScratchRootType;
    }

    @TestOnly
    @Nullable
    public static final ScratchFileEditorWithPreview getScratchEditorForSelectedFile(@NotNull FileEditorManager fileManager, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        FileEditor fileEditor = fileManager.getSelectedEditor(virtualFile);
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null) {
            return null;
        }
        TextEditor editor = textEditor;
        return ScratchFileEditorWithPreviewKt.findScratchFileEditorWithPreview(editor);
    }

    @Nullable
    public static final ScratchFile getScratchFile(@NotNull TextEditor $this$getScratchFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getScratchFile, (String)"<this>");
        ScratchFileEditorWithPreview scratchFileEditorWithPreview = ScratchFileEditorWithPreviewKt.findScratchFileEditorWithPreview($this$getScratchFile);
        return scratchFileEditorWithPreview != null ? scratchFileEditorWithPreview.getScratchFile() : null;
    }

    public static final void updateToolbar(@NotNull ActionToolbar $this$updateToolbar) {
        Intrinsics.checkNotNullParameter((Object)$this$updateToolbar, (String)"<this>");
        ApplicationManager.getApplication().invokeLater(() -> ScratchUtilsKt.updateToolbar$lambda$0($this$updateToolbar));
    }

    private static final void updateToolbar$lambda$0(ActionToolbar $this_updateToolbar) {
        $this_updateToolbar.updateActionsAsync();
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.scratch");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

