/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ToolWindowScratchOutputHandlerKt;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\b\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\t0\u0005j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\t`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/TestOutputHandler;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandlerAdapter;", "<init>", "()V", "errors", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "inlays", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "handle", "", "file", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "expression", "output", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutput;", "error", "message", "onFinish", "testPrint", "Lcom/intellij/psi/PsiFile;", "comments", "", "kotlin.jvm.shared"})
@SourceDebugExtension(value={"SMAP\nToolWindowScratchOutputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/output/TestOutputHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1586#2:271\n1661#2,3:272\n*S KotlinDebug\n*F\n+ 1 ToolWindowScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/output/TestOutputHandler\n*L\n246#1:271\n246#1:272,3\n*E\n"})
final class TestOutputHandler
extends ScratchOutputHandlerAdapter {
    @NotNull
    public static final TestOutputHandler INSTANCE = new TestOutputHandler();
    @NotNull
    private static final ArrayList<String> errors = new ArrayList();
    @NotNull
    private static final ArrayList<Pair<ScratchExpression, String>> inlays = new ArrayList();

    private TestOutputHandler() {
    }

    @Override
    public void handle(@NotNull ScratchFile file, @NotNull ScratchExpression expression, @NotNull ScratchOutput output) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        inlays.add((Pair<ScratchExpression, String>)TuplesKt.to((Object)expression, (Object)output.getText()));
    }

    @Override
    public void error(@NotNull ScratchFile file, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        errors.add(message2);
    }

    @Override
    public void onFinish(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TransactionGuard.submitTransaction((Disposable)KotlinPluginDisposable.Companion.getInstance(file.getProject()), () -> TestOutputHandler.onFinish$lambda$0(file));
    }

    private final void testPrint(PsiFile file, List<String> comments2) {
        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), () -> TestOutputHandler.testPrint$lambda$0(comments2, file));
    }

    private static final CharSequence onFinish$lambda$0$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)it.getSecond();
    }

    /*
     * WARNING - void declaration
     */
    private static final void onFinish$lambda$0(ScratchFile $file) {
        PsiFile psiFile = $file.getPsiFile();
        if (psiFile == null) {
            throw new IllegalStateException(("PsiFile cannot be found for scratch to render inlays in tests:\nproject.isDisposed = " + $file.getProject().isDisposed() + "\ninlays = " + CollectionsKt.joinToString$default((Iterable)inlays, null, null, null, (int)0, null, TestOutputHandler::onFinish$lambda$0$0, (int)31, null) + "\nerrors = " + CollectionsKt.joinToString$default((Iterable)errors, null, null, null, (int)0, null, null, (int)63, null)).toString());
        }
        PsiFile psiFile2 = psiFile;
        if (!((Collection)inlays).isEmpty()) {
            Collection<CallSite> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = inlays;
            PsiFile psiFile3 = psiFile2;
            TestOutputHandler testOutputHandler = INSTANCE;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ScratchExpression expression = (ScratchExpression)pair.component1();
                String text = (String)pair.component2();
                collection.add((CallSite)((Object)("/** " + ToolWindowScratchOutputHandlerKt.access$getLineInfo(psiFile2, expression) + " " + text + " */")));
            }
            collection = (List)destination$iv$iv;
            testOutputHandler.testPrint(psiFile3, (List<String>)collection);
            inlays.clear();
        }
        if (!((Collection)errors).isEmpty()) {
            INSTANCE.testPrint(psiFile2, CollectionsKt.listOf((Object)CollectionsKt.joinToString$default((Iterable)errors, null, (CharSequence)"/** ", (CharSequence)" */", (int)0, null, null, (int)57, null)));
            errors.clear();
        }
    }

    private static final void testPrint$lambda$0(List $comments, PsiFile $file) {
        for (String comment : $comments) {
            Project project = $file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            $file.addAfter((PsiElement)new KtPsiFactory(project, false, 2, null).createComment(comment), $file.getLastChild());
        }
    }
}

