/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch.output;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchToolWindowFactory;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ToolWindowScratchOutputHandlerKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J)\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\u0013\u00a2\u0006\u0002\b\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018*\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ToolWindowScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandlerAdapter;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "handle", "", "file", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "output", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutput;", "expression", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "error", "message", "", "printToConsole", "print", "Lkotlin/Function1;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "Lkotlin/ExtensionFunctionType;", "clear", "convert", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputType;", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "createToolWindow", "kotlin.jvm.shared"})
@SourceDebugExtension(value={"SMAP\nToolWindowScratchOutputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ToolWindowScratchOutputHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
final class ToolWindowScratchOutputHandler
extends ScratchOutputHandlerAdapter {
    @NotNull
    private final Disposable parentDisposable;

    public ToolWindowScratchOutputHandler(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.parentDisposable = parentDisposable;
    }

    @Override
    public void handle(@NotNull ScratchFile file, @NotNull ScratchOutput output) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.printToConsole(file, (Function1<? super ConsoleViewImpl, Unit>)((Function1)arg_0 -> ToolWindowScratchOutputHandler.handle$lambda$0(output, this, arg_0)));
    }

    @Override
    public void handle(@NotNull ScratchFile file, @NotNull ScratchExpression expression, @NotNull ScratchOutput output) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.printToConsole(file, (Function1<? super ConsoleViewImpl, Unit>)((Function1)arg_0 -> ToolWindowScratchOutputHandler.handle$lambda$1(file, expression, output, this, arg_0)));
    }

    @Override
    public void error(@NotNull ScratchFile file, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.printToConsole(file, (Function1<? super ConsoleViewImpl, Unit>)((Function1)arg_0 -> ToolWindowScratchOutputHandler.error$lambda$0(message2, arg_0)));
    }

    private final void printToConsole(ScratchFile file, Function1<? super ConsoleViewImpl, Unit> print) {
        ActionsKt.invokeLater$default(null, () -> ToolWindowScratchOutputHandler.printToConsole$lambda$0(file, this, print), (int)1, null);
    }

    @Override
    public void clear(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ActionsKt.invokeLater$default(null, () -> ToolWindowScratchOutputHandler.clear$lambda$0(this, file), (int)1, null);
    }

    private final ConsoleViewContentType convert(ScratchOutputType $this$convert) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$convert.ordinal()]) {
            case 1 -> ConsoleViewContentType.SYSTEM_OUTPUT;
            case 2 -> ConsoleViewContentType.NORMAL_OUTPUT;
            case 3 -> ConsoleViewContentType.ERROR_OUTPUT;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ToolWindow getToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        return toolWindowManager.getToolWindow("Scratch Output");
    }

    private final ToolWindow createToolWindow(ScratchFile file) {
        Project project = file.getProject();
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
        toolWindowManager.registerToolWindow("Scratch Output", true, toolWindowAnchor);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Scratch Output");
        if (toolWindow == null) {
            throw new IllegalStateException("ScratchToolWindowFactory.ID should be registered".toString());
        }
        ToolWindow window = toolWindow;
        new ScratchToolWindowFactory().createToolWindowContent(project, window);
        Disposer.register((Disposable)this.parentDisposable, () -> ToolWindowScratchOutputHandler.createToolWindow$lambda$0(toolWindowManager));
        return window;
    }

    private static final Unit handle$lambda$0(ScratchOutput $output, ToolWindowScratchOutputHandler this$0, ConsoleViewImpl $this$printToConsole) {
        Intrinsics.checkNotNullParameter((Object)$this$printToConsole, (String)"$this$printToConsole");
        String string = $output.getText();
        ConsoleViewContentType consoleViewContentType = this$0.convert($output.getType());
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"convert(...)");
        $this$printToConsole.print(string, consoleViewContentType);
        return Unit.INSTANCE;
    }

    private static final Unit handle$lambda$1(ScratchFile $file, ScratchExpression $expression, ScratchOutput $output, ToolWindowScratchOutputHandler this$0, ConsoleViewImpl $this$printToConsole) {
        Intrinsics.checkNotNullParameter((Object)$this$printToConsole, (String)"$this$printToConsole");
        PsiFile psiFile = $file.getPsiFile();
        if (psiFile != null) {
            $this$printToConsole.printHyperlink(ToolWindowScratchOutputHandlerKt.access$getLineInfo(psiFile, $expression), (HyperlinkInfo)new OpenFileHyperlinkInfo($this$printToConsole.getProject(), psiFile.getVirtualFile(), $expression.getLineStart()));
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
            $this$printToConsole.print(" ", consoleViewContentType);
        }
        String string = $output.getText();
        ConsoleViewContentType consoleViewContentType = this$0.convert($output.getType());
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"convert(...)");
        $this$printToConsole.print(string, consoleViewContentType);
        return Unit.INSTANCE;
    }

    private static final Unit error$lambda$0(String $message, ConsoleViewImpl $this$printToConsole) {
        Intrinsics.checkNotNullParameter((Object)$this$printToConsole, (String)"$this$printToConsole");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ERROR_OUTPUT");
        $this$printToConsole.print($message, consoleViewContentType);
        return Unit.INSTANCE;
    }

    private static final Unit printToConsole$lambda$0(ScratchFile $file, ToolWindowScratchOutputHandler this$0, Function1 $print) {
        Project project;
        Project it = project = $file.getProject();
        boolean bl = false;
        Object object = !it.isDisposed() ? project : null;
        if (object == null) {
            return Unit.INSTANCE;
        }
        Project project2 = object;
        ToolWindow toolWindow = this$0.getToolWindow(project2);
        if (toolWindow == null) {
            toolWindow = this$0.createToolWindow($file);
        }
        ToolWindow toolWindow2 = toolWindow;
        Content[] contentArray = toolWindow2.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        for (Content content : contentArray) {
            JComponent component;
            Intrinsics.checkNotNullExpressionValue((Object)content.getComponent(), (String)"getComponent(...)");
            if (!(component instanceof ConsoleViewImpl)) continue;
            ((ConsoleViewImpl)component).clear();
            $print.invoke((Object)component);
            ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)component;
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
            consoleViewImpl.print("\n", consoleViewContentType);
        }
        toolWindow2.setAvailable(true, null);
        if (!$file.getOptions().isInteractiveMode()) {
            toolWindow2.show(null);
        }
        toolWindow2.setIcon(ExecutionUtil.getLiveIndicator((Icon)AllIcons.FileTypes.Text));
        return Unit.INSTANCE;
    }

    private static final Unit clear$lambda$0(ToolWindowScratchOutputHandler this$0, ScratchFile $file) {
        ToolWindow toolWindow = this$0.getToolWindow($file.getProject());
        if (toolWindow == null) {
            return Unit.INSTANCE;
        }
        ToolWindow toolWindow2 = toolWindow;
        Content[] contentArray = toolWindow2.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        for (Content content : contentArray) {
            JComponent component;
            Intrinsics.checkNotNullExpressionValue((Object)content.getComponent(), (String)"getComponent(...)");
            if (!(component instanceof ConsoleViewImpl)) continue;
            ((ConsoleViewImpl)component).clear();
        }
        if (!$file.getOptions().isInteractiveMode()) {
            toolWindow2.hide(null);
        }
        toolWindow2.setIcon(AllIcons.FileTypes.Text);
        return Unit.INSTANCE;
    }

    private static final void createToolWindow$lambda$0(ToolWindowManager $toolWindowManager) {
        $toolWindowManager.unregisterToolWindow("Scratch Output");
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScratchOutputType.values().length];
            try {
                nArray[ScratchOutputType.OUTPUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScratchOutputType.RESULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScratchOutputType.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

