/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch.ui;

import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.jvm.shared.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFileAutoRunner;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.InlayScratchOutputHandler;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.PreviewEditorScratchOutputHandler;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.PreviewOutputBlocksManager;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputBlock;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ToolWindowScratchOutputHandlerKt;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.LayoutDependantOutputHandler;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchEditorLinesTranslator;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchEditorSyncHighlighterKt;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchFileEditorWithPreviewKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010 \u001a\u00020!H\u0016J\u001e\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0018\u00010#2\u0006\u0010%\u001a\u00020$H\u0016J\u001e\u0010&\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0018\u00010#2\u0006\u0010'\u001a\u00020$H\u0016J\b\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\b\u00100\u001a\u000201H\u0016J\u0006\u00102\u001a\u00020)J\b\u00105\u001a\u000206H\u0014J\u001c\u0010=\u001a\u00020)2\b\u0010>\u001a\u0004\u0018\u00010?2\b\u0010@\u001a\u0004\u0018\u00010?H\u0014J\u0010\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020/H\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u00103\u001a\u00020/8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00107\u001a\u0002088TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\u0002088TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010:\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchFileEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorLinesTranslator;", "kotlinScratchFile", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "sourceTextEditor", "previewTextEditor", "<init>", "(Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;Lcom/intellij/openapi/fileEditor/TextEditor;Lcom/intellij/openapi/fileEditor/TextEditor;)V", "scratchFile", "getScratchFile", "()Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "sourceEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "_previewEditor", "previewOutputManager", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/PreviewOutputBlocksManager;", "toolWindowHandler", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandler;", "getToolWindowHandler", "()Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandler;", "inlayScratchOutputHandler", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/InlayScratchOutputHandler;", "previewEditorScratchOutputHandler", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/PreviewEditorScratchOutputHandler;", "getPreviewEditorScratchOutputHandler", "()Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/PreviewEditorScratchOutputHandler;", "commonPreviewOutputHandler", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/LayoutDependantOutputHandler;", "getCommonPreviewOutputHandler", "()Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/LayoutDependantOutputHandler;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "previewLineToSourceLines", "Lkotlin/Pair;", "", "previewLine", "sourceLineToPreviewLines", "sourceLine", "configureSyncScrollForSourceAndPreview", "", "dispose", "navigateTo", "navigatable", "Lcom/intellij/pom/Navigatable;", "canNavigateTo", "", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "clearOutputHandlers", "isShowActionsInTabs", "()Z", "createViewActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "showEditorAction", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "getShowEditorAction", "()Lcom/intellij/openapi/actionSystem/ToggleAction;", "showEditorAndPreviewAction", "getShowEditorAndPreviewAction", "onLayoutChange", "oldValue", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "newValue", "setPreviewEnabled", "isPreviewEnabled", "kotlin.jvm.shared"})
public abstract class ScratchFileEditorWithPreview
extends TextEditorWithPreview
implements TextEditor,
ScratchEditorLinesTranslator {
    @NotNull
    private final ScratchFile scratchFile;
    @NotNull
    private final EditorEx sourceEditor;
    @NotNull
    private final EditorEx _previewEditor;
    @NotNull
    private final PreviewOutputBlocksManager previewOutputManager;
    @NotNull
    private final ScratchOutputHandler toolWindowHandler;
    @NotNull
    private final InlayScratchOutputHandler inlayScratchOutputHandler;
    @NotNull
    private final PreviewEditorScratchOutputHandler previewEditorScratchOutputHandler;
    @NotNull
    private final LayoutDependantOutputHandler commonPreviewOutputHandler;

    public ScratchFileEditorWithPreview(@NotNull ScratchFile kotlinScratchFile, @NotNull TextEditor sourceTextEditor, @NotNull TextEditor previewTextEditor) {
        Intrinsics.checkNotNullParameter((Object)kotlinScratchFile, (String)"kotlinScratchFile");
        Intrinsics.checkNotNullParameter((Object)sourceTextEditor, (String)"sourceTextEditor");
        Intrinsics.checkNotNullParameter((Object)previewTextEditor, (String)"previewTextEditor");
        super(sourceTextEditor, (FileEditor)previewTextEditor, null, null, false, null, 60, null);
        this.scratchFile = kotlinScratchFile;
        Editor editor = sourceTextEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        this.sourceEditor = (EditorEx)editor;
        Editor editor2 = previewTextEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        this._previewEditor = (EditorEx)editor2;
        this.previewOutputManager = new PreviewOutputBlocksManager((Editor)this._previewEditor);
        this.toolWindowHandler = ToolWindowScratchOutputHandlerKt.requestToolWindowHandler();
        this.inlayScratchOutputHandler = new InlayScratchOutputHandler(sourceTextEditor, this.toolWindowHandler);
        this.previewEditorScratchOutputHandler = new PreviewEditorScratchOutputHandler(this.previewOutputManager, this.toolWindowHandler, (Disposable)previewTextEditor);
        this.commonPreviewOutputHandler = new LayoutDependantOutputHandler(this.inlayScratchOutputHandler, this.previewEditorScratchOutputHandler, (Function0<? extends TextEditorWithPreview.Layout>)((Function0)() -> ScratchFileEditorWithPreview.commonPreviewOutputHandler$lambda$0(this)));
        ScratchFileEditorWithPreviewKt.setParentScratchEditorWithPreview(sourceTextEditor, this);
        ScratchFileEditorWithPreviewKt.setParentScratchEditorWithPreview(previewTextEditor, this);
        this.configureSyncScrollForSourceAndPreview();
        ScratchEditorSyncHighlighterKt.configureSyncHighlighting(this.sourceEditor, this._previewEditor, this);
        ScratchFileAutoRunner.Companion.addListener(kotlinScratchFile.getProject(), sourceTextEditor);
    }

    @NotNull
    public final ScratchFile getScratchFile() {
        return this.scratchFile;
    }

    @NotNull
    protected final ScratchOutputHandler getToolWindowHandler() {
        return this.toolWindowHandler;
    }

    @NotNull
    protected final PreviewEditorScratchOutputHandler getPreviewEditorScratchOutputHandler() {
        return this.previewEditorScratchOutputHandler;
    }

    @NotNull
    protected final LayoutDependantOutputHandler getCommonPreviewOutputHandler() {
        return this.commonPreviewOutputHandler;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.scratchFile.getVirtualFile();
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> previewLineToSourceLines(int previewLine) {
        ScratchExpression scratchExpression = this.scratchFile.getExpressionAtLine(previewLine);
        if (scratchExpression == null) {
            return null;
        }
        ScratchExpression expressionUnderCaret = scratchExpression;
        ScratchOutputBlock scratchOutputBlock = this.previewOutputManager.getBlock(expressionUnderCaret);
        if (scratchOutputBlock == null) {
            return null;
        }
        ScratchOutputBlock outputBlock = scratchOutputBlock;
        return TuplesKt.to((Object)outputBlock.getLineStart(), (Object)outputBlock.getLineEnd());
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> sourceLineToPreviewLines(int sourceLine) {
        ScratchOutputBlock scratchOutputBlock = this.previewOutputManager.getBlockAtLine(sourceLine);
        if (scratchOutputBlock == null) {
            return null;
        }
        ScratchOutputBlock block = scratchOutputBlock;
        if (!ScratchFileEditorWithPreviewKt.linesInformationIsCorrect(block.getSourceExpression())) {
            return null;
        }
        return TuplesKt.to((Object)block.getSourceExpression().getLineStart(), (Object)block.getSourceExpression().getLineEnd());
    }

    private final void configureSyncScrollForSourceAndPreview() {
        BaseSyncScrollable scrollable2 = new BaseSyncScrollable(this){
            final /* synthetic */ ScratchFileEditorWithPreview this$0;
            {
                this.this$0 = $receiver;
            }

            protected void processHelper(BaseSyncScrollable.ScrollHelper helper2) {
                Intrinsics.checkNotNullParameter((Object)helper2, (String)"helper");
                if (!helper2.process(0, 0)) {
                    return;
                }
                List<Pair<Integer, Integer>> alignments = ScratchFileEditorWithPreview.access$getPreviewOutputManager$p(this.this$0).computeSourceToPreviewAlignments();
                for (Pair<Integer, Integer> pair : alignments) {
                    int fromPreview;
                    int fromSource = ((Number)pair.component1()).intValue();
                    if (!helper2.process(fromSource, fromPreview = ((Number)pair.component2()).intValue())) {
                        return;
                    }
                    if (helper2.process(fromSource, fromPreview)) continue;
                    return;
                }
                helper2.process(ScratchFileEditorWithPreview.access$getSourceEditor$p(this.this$0).getDocument().getLineCount(), ScratchFileEditorWithPreview.access$get_previewEditor$p(this.this$0).getDocument().getLineCount());
            }

            public boolean isSyncScrollEnabled() {
                return true;
            }
        };
        Object[] objectArray = new EditorEx[]{this.sourceEditor, this._previewEditor};
        SyncScrollSupport.TwosideSyncScrollSupport scrollSupport = new SyncScrollSupport.TwosideSyncScrollSupport(CollectionsKt.listOf((Object[])objectArray), (SyncScrollSupport.SyncScrollable)scrollable2);
        VisibleAreaListener listener2 = arg_0 -> ScratchFileEditorWithPreview.configureSyncScrollForSourceAndPreview$lambda$0(scrollSupport, arg_0);
        this.sourceEditor.getScrollingModel().addVisibleAreaListener(listener2);
        this._previewEditor.getScrollingModel().addVisibleAreaListener(listener2);
    }

    public void dispose() {
        ToolWindowScratchOutputHandlerKt.releaseToolWindowHandler(this.toolWindowHandler);
        super.dispose();
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        this.myEditor.navigateTo(navigatable);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        return this.myEditor.canNavigateTo(navigatable);
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        return editor;
    }

    public final void clearOutputHandlers() {
        this.commonPreviewOutputHandler.clear(this.scratchFile);
    }

    protected boolean isShowActionsInTabs() {
        return false;
    }

    @NotNull
    protected ActionGroup createViewActionGroup() {
        AnAction[] anActionArray = new AnAction[]{this.getShowEditorAction(), this.getShowEditorAndPreviewAction()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    @NotNull
    protected ToggleAction getShowEditorAction() {
        ToggleAction toggleAction;
        ToggleAction $this$_get_showEditorAction__u24lambda_u240 = toggleAction = super.getShowEditorAction();
        boolean bl = false;
        $this$_get_showEditorAction__u24lambda_u240.getTemplatePresentation().setText(KotlinJvmBundle.message("scratch.inlay.output.mode.title", new Object[0]));
        $this$_get_showEditorAction__u24lambda_u240.getTemplatePresentation().setDescription(KotlinJvmBundle.message("scratch.inlay.output.mode.description", new Object[0]));
        return toggleAction;
    }

    @NotNull
    protected ToggleAction getShowEditorAndPreviewAction() {
        ToggleAction toggleAction;
        ToggleAction $this$_get_showEditorAndPreviewAction__u24lambda_u240 = toggleAction = super.getShowEditorAndPreviewAction();
        boolean bl = false;
        $this$_get_showEditorAndPreviewAction__u24lambda_u240.getTemplatePresentation().setText(KotlinJvmBundle.message("scratch.side.panel.output.mode.title", new Object[0]));
        $this$_get_showEditorAndPreviewAction__u24lambda_u240.getTemplatePresentation().setDescription(KotlinJvmBundle.message("scratch.side.panel.output.mode.description", new Object[0]));
        return toggleAction;
    }

    protected void onLayoutChange(@Nullable TextEditorWithPreview.Layout oldValue, @Nullable TextEditorWithPreview.Layout newValue) {
        if (oldValue != newValue) {
            this.clearOutputHandlers();
        }
    }

    @TestOnly
    public final void setPreviewEnabled(boolean isPreviewEnabled) {
        this.setLayout(isPreviewEnabled ? TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW : TextEditorWithPreview.Layout.SHOW_EDITOR);
    }

    private static final TextEditorWithPreview.Layout commonPreviewOutputHandler$lambda$0(ScratchFileEditorWithPreview this$0) {
        TextEditorWithPreview.Layout layout = this$0.getLayout();
        Intrinsics.checkNotNull((Object)layout);
        return layout;
    }

    private static final void configureSyncScrollForSourceAndPreview$lambda$0(SyncScrollSupport.TwosideSyncScrollSupport $scrollSupport, VisibleAreaEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $scrollSupport.visibleAreaChanged(e);
    }

    public static final /* synthetic */ PreviewOutputBlocksManager access$getPreviewOutputManager$p(ScratchFileEditorWithPreview $this) {
        return $this.previewOutputManager;
    }

    public static final /* synthetic */ EditorEx access$getSourceEditor$p(ScratchFileEditorWithPreview $this) {
        return $this.sourceEditor;
    }

    public static final /* synthetic */ EditorEx access$get_previewEditor$p(ScratchFileEditorWithPreview $this) {
        return $this._previewEditor;
    }
}

