/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvmDecompiler;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.jvm.shared.internal.KotlinJvmDecompilerFacade;
import org.jetbrains.kotlin.idea.jvmDecompiler.DecompileKotlinToJavaActionKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/jvmDecompiler/DecompileKotlinToJavaAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "getBinaryKotlinFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "intellij.kotlin.jvm.decompiler"})
public final class DecompileKotlinToJavaAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            KtFile ktFile2 = this.getBinaryKotlinFile(e);
            if (ktFile2 == null) {
                return;
            }
            KtFile binaryFile = ktFile2;
            KotlinJvmDecompilerFacade kotlinJvmDecompilerFacade = KotlinJvmDecompilerFacade.Companion.getInstance();
            if (kotlinJvmDecompilerFacade == null) break block1;
            kotlinJvmDecompilerFacade.showDecompiledCode(binaryFile);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (KotlinPlatformUtils.isCidr()) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabled(this.getBinaryKotlinFile(e) != null);
        }
    }

    private final KtFile getBinaryKotlinFile(AnActionEvent e) {
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        KtFile ktFile2 = object instanceof KtFile ? (KtFile)object : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile file = ktFile2;
        if (!DecompileKotlinToJavaActionKt.canBeDecompiledToJava(file)) {
            return null;
        }
        return file;
    }
}

