/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvmDecompiler;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaCompilationResult;
import org.jetbrains.kotlin.analysis.api.components.KaCompiledFile;
import org.jetbrains.kotlin.analysis.api.components.KaCompilerFacilityKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.jvm.shared.bytecode.KotlinBytecodeToolWindow;
import org.jetbrains.kotlin.idea.jvm.shared.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.jvmDecompiler.DecompileKotlinToJavaActionKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0006\u0010\u0006\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/jvmDecompiler/KotlinBytecodeDecompiler;", "", "<init>", "()V", "decompile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "bytecodeMapForExistingClassfile", "", "Ljava/io/File;", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "bytecodeMapForSourceFile", "KotlinResultSaver", "intellij.kotlin.jvm.decompiler"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKotlinBytecodeDecompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBytecodeDecompiler.kt\norg/jetbrains/kotlin/idea/jvmDecompiler/KotlinBytecodeDecompiler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 5 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,133:1\n3938#2:134\n4474#2,2:135\n1586#3:137\n1661#3,3:138\n1205#3,2:141\n1282#3,4:143\n30#4,2:147\n36#5,15:149\n*S KotlinDebug\n*F\n+ 1 KotlinBytecodeDecompiler.kt\norg/jetbrains/kotlin/idea/jvmDecompiler/KotlinBytecodeDecompiler\n*L\n64#1:134\n64#1:135,2\n66#1:137\n66#1:138,3\n68#1:141,2\n68#1:143,4\n79#1:147,2\n79#1:149,15\n*E\n"})
public final class KotlinBytecodeDecompiler {
    @NotNull
    public static final KotlinBytecodeDecompiler INSTANCE = new KotlinBytecodeDecompiler();

    private KotlinBytecodeDecompiler() {
    }

    @Nullable
    public final String decompile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            Map map2 = (Map)ActionsKt.runReadAction(() -> KotlinBytecodeDecompiler.decompile$lambda$0(file));
            if (map2 == null) {
                return null;
            }
            Map bytecodeMap = map2;
            KotlinResultSaver resultSaver = new KotlinResultSaver();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"rbr", (Object)"0")};
            HashMap options2 = MapsKt.hashMapOf((Pair[])pairArray);
            IBytecodeProvider bytecodeProvider = (arg_0, arg_1) -> KotlinBytecodeDecompiler.decompile$lambda$1(bytecodeMap, arg_0, arg_1);
            BaseDecompiler decompiler = new BaseDecompiler(bytecodeProvider, (IResultSaver)resultSaver, (Map)options2, (IFernflowerLogger)new IdeaLogger());
            for (File path2 : bytecodeMap.keySet()) {
                decompiler.addSource(path2);
            }
            decompiler.decompileContext();
            return resultSaver.getResultText();
        }
        catch (IdeaLogger.InternalException ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            throw new DecompileFailedException(string, ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, Function0<byte[]>> bytecodeMapForExistingClassfile(VirtualFile file) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String mask = file.getNameWithoutExtension() + "$";
        Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)file.getPath(), (Object)file));
        VirtualFile[] virtualFileArray = file.getParent().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        Object[] objectArray = virtualFileArray;
        Map map3 = map2;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = element$iv$iv;
            boolean bl = false;
            String string = it.getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            if (!(StringsKt.startsWith$default((String)string, (String)mask, (boolean)false, (int)2, null) && it.getFileType() == JavaClassFileType.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getPath(), (Object)it));
        }
        Map files = MapsKt.plus((Map)map3, (Iterable)((List)destination$iv$iv));
        Iterable $this$associate$iv = files.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map4 = destination$iv$iv2;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)new File((String)it.getKey()), () -> KotlinBytecodeDecompiler.bytecodeMapForExistingClassfile$lambda$2$0(it));
            map4.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<File, Function0<byte[]>> bytecodeMapForSourceFile(KtFile file) {
        void this_$iv$iv;
        CompilerConfiguration compilerConfiguration;
        CompilerConfiguration $this$bytecodeMapForSourceFile_u24lambda_u240 = compilerConfiguration = new CompilerConfiguration();
        boolean $i$a$-apply-KotlinBytecodeDecompiler$bytecodeMapForSourceFile$configuration$22 = false;
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)$this$bytecodeMapForSourceFile_u24lambda_u240, (LanguageVersionSettings)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)file));
        CompilerConfiguration configuration2 = compilerConfiguration;
        KtElement useSiteElement$iv = (KtElement)file;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider $i$a$-apply-KotlinBytecodeDecompiler$bytecodeMapForSourceFile$configuration$22 = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                Object object2;
                block16: {
                    boolean bl = false;
                    KaSession $this$bytecodeMapForSourceFile_u24lambda_u241 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    KotlinBytecodeToolWindow.Companion $this$bytecodeMapForSourceFile_u24lambda_u241_u240 = KotlinBytecodeToolWindow.Companion;
                    boolean bl3 = false;
                    object2 = $this$bytecodeMapForSourceFile_u24lambda_u241_u240.compileSingleFile($this$bytecodeMapForSourceFile_u24lambda_u241, file, configuration2);
                    if (object2 != null && (object2 = (KaCompilationResult)object2.getFirst()) != null) break block16;
                    Map map2 = MapsKt.emptyMap();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl29 : MonitorExitStatement: MONITOREXIT : var10_12
                    Map map3 = map2;
                    return map3;
                }
                try {
                    Map map4;
                    Object result2;
                    Object object3 = result2 = object2;
                    if (object3 instanceof KaCompilationResult.Success) {
                        Map map5;
                        Map $this$bytecodeMapForSourceFile_u24lambda_u241_u240_u240 = map5 = MapsKt.createMapBuilder();
                        boolean bl = false;
                        for (KaCompiledFile outputFile : ((KaCompilationResult.Success)result2).getOutput()) {
                            if (!KaCompilerFacilityKt.isClassFile(outputFile)) continue;
                            File file2 = new File("/" + outputFile.getPath()).getAbsoluteFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
                            $this$bytecodeMapForSourceFile_u24lambda_u241_u240_u240.put(file2, () -> KotlinBytecodeDecompiler.bytecodeMapForSourceFile$lambda$1$0$0$0(outputFile));
                        }
                        map4 = MapsKt.build((Map)map5);
                    } else if (object3 instanceof KaCompilationResult.Failure) {
                        map4 = MapsKt.emptyMap();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    Map map6 = map4;
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl53 : MonitorExitStatement: MONITOREXIT : var10_12
                    Map map7 = map6;
                    return map7;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable$iv$iv) {
                        this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                        throw new KotlinNothingValueException();
                    }
                }
            }
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
    }

    private static final Map decompile$lambda$0(KtFile $file) {
        Map<File, Function0<byte[]>> map2;
        if (DecompileKotlinToJavaActionKt.canBeDecompiledToJava($file)) {
            VirtualFile virtualFile = $file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            map2 = INSTANCE.bytecodeMapForExistingClassfile(virtualFile);
        } else {
            map2 = !$file.isCompiled() ? INSTANCE.bytecodeMapForSourceFile($file) : null;
        }
        return map2;
    }

    private static final byte[] decompile$lambda$1(Map $bytecodeMap, String externalPath, String string) {
        File path2 = new File(FileUtil.toSystemIndependentName((String)externalPath));
        Function0 function0 = (Function0)$bytecodeMap.get(path2);
        return (byte[])(function0 != null ? (byte[])function0.invoke() : null);
    }

    private static final byte[] bytecodeMapForExistingClassfile$lambda$2$0(Map.Entry $it) {
        return ((VirtualFile)$it.getValue()).contentsToByteArray(false);
    }

    private static final byte[] bytecodeMapForSourceFile$lambda$1$0$0$0(KaCompiledFile $outputFile) {
        return $outputFile.getContent();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\r\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016J0\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016J&\u0010\u0012\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J:\u0010\u0015\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J&\u0010\u001b\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0016J:\u0010\u001c\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0016J&\u0010\u001d\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/jvmDecompiler/KotlinBytecodeDecompiler$KotlinResultSaver;", "Lorg/jetbrains/java/decompiler/main/extern/IResultSaver;", "<init>", "()V", "decompiledText", "", "", "resultText", "getResultText", "()Ljava/lang/String;", "saveFolder", "", "path", "closeArchive", "archiveName", "copyEntry", "source", "entry", "createArchive", "manifest", "Ljava/util/jar/Manifest;", "saveClassFile", "qualifiedName", "entryName", "content", "mapping", "", "copyFile", "saveClassEntry", "saveDirEntry", "intellij.kotlin.jvm.decompiler"})
    @SourceDebugExtension(value={"SMAP\nKotlinBytecodeDecompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBytecodeDecompiler.kt\norg/jetbrains/kotlin/idea/jvmDecompiler/KotlinBytecodeDecompiler$KotlinResultSaver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
    private static final class KotlinResultSaver
    implements IResultSaver {
        @NotNull
        private final Map<String, String> decompiledText = new LinkedHashMap();

        @NotNull
        public final String getResultText() {
            CharSequence charSequence = (String)CollectionsKt.singleOrNull((Iterable)this.decompiledText.values());
            if (charSequence != null) {
                String it = charSequence;
                boolean bl = false;
                return it;
            }
            CharSequence $this$_get_resultText__u24lambda_u241 = charSequence = new StringBuilder();
            boolean bl = false;
            for (Map.Entry<String, String> entry : this.decompiledText.entrySet()) {
                String filename = entry.getKey();
                String content = entry.getValue();
                ((StringBuilder)$this$_get_resultText__u24lambda_u241).append("// " + filename).append('\n');
                ((StringBuilder)$this$_get_resultText__u24lambda_u241).append(content);
            }
            return ((StringBuilder)charSequence).toString();
        }

        public void saveFolder(@Nullable String path2) {
        }

        public void closeArchive(@Nullable String path2, @Nullable String archiveName) {
        }

        public void copyEntry(@Nullable String source, @Nullable String path2, @Nullable String archiveName, @Nullable String entry) {
        }

        public void createArchive(@Nullable String path2, @Nullable String archiveName, @Nullable Manifest manifest) {
        }

        public void saveClassFile(@Nullable String path2, @Nullable String qualifiedName, @Nullable String entryName, @Nullable String content, @Nullable int[] mapping2) {
            if (entryName != null && content != null) {
                this.decompiledText.put(entryName, content);
            }
        }

        public void copyFile(@Nullable String source, @Nullable String path2, @Nullable String entryName) {
        }

        public void saveClassEntry(@Nullable String path2, @Nullable String archiveName, @Nullable String qualifiedName, @Nullable String entryName, @Nullable String content) {
        }

        public void saveDirEntry(@Nullable String path2, @Nullable String archiveName, @Nullable String entryName) {
        }
    }
}

